/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.company.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.company.bean.CompanyStateEntity;
import com.ejianc.foundation.company.mapper.CompanyStateDetailMapper;
import com.ejianc.foundation.company.mapper.CompanyStateMapper;
import com.ejianc.foundation.company.service.ICompanyStateService;
import com.ejianc.foundation.cpmpany.vo.CompanyStateDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="companyStateService")
public class CompanyStateServiceImpl
extends BaseServiceImpl<CompanyStateMapper, CompanyStateEntity>
implements ICompanyStateService {
    @Autowired
    private CompanyStateDetailMapper companyStateDetailMapper;
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, Integer flag) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            if (entity == null) continue;
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        if (mf == null) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6587\u4ef6\u4e2d\u6ca1\u6709\u6570\u636e");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<CompanyStateDetailVO> successList = new ArrayList<CompanyStateDetailVO>();
        ArrayList<CompanyStateDetailVO> errorList = new ArrayList<CompanyStateDetailVO>();
        if (result == null || result.isEmpty()) {
            throw new BusinessException("\u6570\u636e\u8868\u683c\u9519\u8bef");
        }
        if (((List)result.get(0)).size() >= 40) {
            throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e \u3010" + ((List)result.get(0)).size() + "\u3011\u5927\u4e8e\u89c4\u5b9a\u957f\u5ea6 \u5c0f\u4e8e\u7b49\u4e8e40");
        }
        if (result.size() >= 10000) {
            throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc710000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
        }
        for (int i = 1; i < result.size(); ++i) {
            CompanyStateDetailVO vo = new CompanyStateDetailVO();
            String branch = (String)((List)result.get(i)).get(0);
            vo.setBranch(branch);
            String projectName = (String)((List)result.get(i)).get(1);
            vo.setProjectName(projectName);
            try {
                String s = (String)((List)result.get(i)).get(2);
                vo.setProjectStatus(Integer.valueOf(Integer.parseInt(s)));
            }
            catch (NumberFormatException e) {
                vo.setErrorMsg("\u3010\u9879\u76ee\u72b6\u6001\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(2));
                errorList.add(vo);
                continue;
            }
            try {
                String actualCommencement = (String)((List)result.get(i)).get(3);
                Date date = null;
                LocalDate parse = LocalDate.parse(actualCommencement, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                date = Date.from(parse.atStartOfDay(ZoneId.systemDefault()).toInstant());
                vo.setActualCommencement(date);
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u5b9e\u9645\u5f00\u5de5\u65e5\u671f\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(3));
                errorList.add(vo);
                continue;
            }
            try {
                String contractAmount = (String)((List)result.get(i)).get(4);
                vo.setContractAmount(new BigDecimal(contractAmount));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u5408\u540c\u91d1\u989d\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(3));
                errorList.add(vo);
                continue;
            }
            try {
                String taxRate = (String)((List)result.get(i)).get(5);
                vo.setTaxRate(new BigDecimal(taxRate));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u7a0e\u7387\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(5));
                errorList.add(vo);
                continue;
            }
            try {
                String profitMargin = (String)((List)result.get(i)).get(6);
                vo.setProfitMargin(new BigDecimal(profitMargin));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u76ee\u6807\u5229\u6da6\u7387\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(6));
                errorList.add(vo);
                continue;
            }
            try {
                String freeIncomeTax = (String)((List)result.get(i)).get(7);
                vo.setFreeIncomeTax(new BigDecimal(freeIncomeTax));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u9884\u8ba1\u4e0d\u542b\u7a0e\u603b\u6536\u5165\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(7));
                errorList.add(vo);
                continue;
            }
            try {
                String revenueIncludingTax = (String)((List)result.get(i)).get(8);
                vo.setRevenueIncludingTax(new BigDecimal(revenueIncludingTax));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u9884\u8ba1\u542b\u7a0e\u603b\u6536\u5165\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(7));
                errorList.add(vo);
                continue;
            }
            try {
                BigDecimal totalOutputTax = null;
                totalOutputTax = vo.getRevenueIncludingTax().subtract(vo.getFreeIncomeTax());
                vo.setTotalOutputTax(totalOutputTax);
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u9884\u8ba1\u603b\u9500\u9879\u7a0e\u3011\u8ba1\u7b97\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(8));
                errorList.add(vo);
                continue;
            }
            try {
                String costExcludingTaxStr = (String)((List)result.get(i)).get(9);
                vo.setCostExcludingTax(new BigDecimal(costExcludingTaxStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u9884\u8ba1\u4e0d\u542b\u7a0e\u603b\u6210\u672c\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(9));
                errorList.add(vo);
                continue;
            }
            try {
                String inputTaxVatSurchargeStr = (String)((List)result.get(i)).get(10);
                vo.setInputTaxVatSurcharge(new BigDecimal(inputTaxVatSurchargeStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u9884\u8ba1\u603b\u8fdb\u9879\u7a0e\u3001\u589e\u503c\u7a0e\u3001\u9644\u52a0\u7a0e\u7b49\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(10));
                errorList.add(vo);
                continue;
            }
            try {
                String totalFinancialExpensesStr = (String)((List)result.get(i)).get(11);
                vo.setTotalFinancialExpenses(new BigDecimal(totalFinancialExpensesStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u9884\u8ba1\u603b\u8d22\u52a1\u8d39\u7528\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(11));
                errorList.add(vo);
                continue;
            }
            try {
                String costIncludingTaxStr = (String)((List)result.get(i)).get(12);
                vo.setCostIncludingTax(new BigDecimal(costIncludingTaxStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u9884\u8ba1\u542b\u7a0e\u603b\u6210\u672c\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(12));
                errorList.add(vo);
                continue;
            }
            try {
                String totalProfitLossStr = (String)((List)result.get(i)).get(13);
                vo.setTotalProfitLoss(new BigDecimal(totalProfitLossStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u9884\u8ba1\u603b\u76c8\u4e8f\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(13));
                errorList.add(vo);
                continue;
            }
            try {
                String totalProfitMarginStr = (String)((List)result.get(i)).get(14);
                vo.setTotalProfitMargin(new BigDecimal(totalProfitMarginStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u9884\u8ba1\u603b\u5229\u6da6\u7387\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(14));
                errorList.add(vo);
                continue;
            }
            try {
                String cumulativeFreeIncomeStr = (String)((List)result.get(i)).get(15);
                vo.setCumulativeFreeIncome(new BigDecimal(cumulativeFreeIncomeStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u7d2f\u8ba1\u4e0d\u542b\u7a0e\u6536\u5165\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(15));
                errorList.add(vo);
                continue;
            }
            try {
                String cumulativeOutputTaxStr = (String)((List)result.get(i)).get(16);
                vo.setCumulativeOutputTax(new BigDecimal(cumulativeOutputTaxStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u7d2f\u8ba1\u9500\u9879\u7a0e\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(16));
                errorList.add(vo);
                continue;
            }
            try {
                String cumulativeRevenueIncludingTaxStr = (String)((List)result.get(i)).get(17);
                vo.setCumulativeRevenueIncludingTax(new BigDecimal(cumulativeRevenueIncludingTaxStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u7d2f\u8ba1\u542b\u7a0e\u6536\u5165\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(17));
                errorList.add(vo);
                continue;
            }
            try {
                String cumulativeFreeCostStr = (String)((List)result.get(i)).get(18);
                vo.setCumulativeFreeCost(new BigDecimal(cumulativeFreeCostStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u7d2f\u8ba1\u4e0d\u542b\u7a0e\u6210\u672c\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(18));
                errorList.add(vo);
                continue;
            }
            try {
                String cumulativeInputTaxVatSurchargeStr = (String)((List)result.get(i)).get(19);
                vo.setCumulativeInputTaxVatSurcharge(new BigDecimal(cumulativeInputTaxVatSurchargeStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u7d2f\u8ba1\u8fdb\u9879\u7a0e\u3001\u5e94\u7eb3\u589e\u503c\u7a0e\u3001\u9644\u52a0\u7a0e\u7b49\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(19));
                errorList.add(vo);
                continue;
            }
            try {
                String cumulativeFinancialExpensesStr = (String)((List)result.get(i)).get(20);
                vo.setCumulativeFinancialExpenses(new BigDecimal(cumulativeFinancialExpensesStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u7d2f\u8ba1\u8d22\u52a1\u8d39\u7528\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(20));
                errorList.add(vo);
                continue;
            }
            try {
                String cumulativeCostIncludingTaxStr = (String)((List)result.get(i)).get(21);
                vo.setCumulativeCostIncludingTax(new BigDecimal(cumulativeCostIncludingTaxStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u7d2f\u8ba1\u542b\u7a0e\u6210\u672c\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(21));
                errorList.add(vo);
                continue;
            }
            try {
                String cumulativeProfitLossStr = (String)((List)result.get(i)).get(22);
                vo.setCumulativeProfitLoss(new BigDecimal(cumulativeProfitLossStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u7d2f\u8ba1\u76c8\u4e8f\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(22));
                errorList.add(vo);
                continue;
            }
            try {
                String cumulativeProfitMarginStr = (String)((List)result.get(i)).get(23);
                vo.setCumulativeProfitMargin(new BigDecimal(cumulativeProfitMarginStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u7d2f\u8ba1\u5229\u6da6\u7387\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(23));
                errorList.add(vo);
                continue;
            }
            try {
                String mainBusinessIncomeStr = (String)((List)result.get(i)).get(24);
                vo.setMainBusinessIncome(new BigDecimal(mainBusinessIncomeStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u4e3b\u8425\u4e1a\u52a1\u6536\u5165\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(24));
                errorList.add(vo);
                continue;
            }
            try {
                String mainBusinessCostStr = (String)((List)result.get(i)).get(25);
                vo.setMainBusinessCost(new BigDecimal(mainBusinessCostStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u4e3b\u8425\u4e1a\u52a1\u6210\u672c\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(25));
                errorList.add(vo);
                continue;
            }
            try {
                String grossProfitStr = (String)((List)result.get(i)).get(26);
                vo.setGrossProfit(new BigDecimal(grossProfitStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u6bdb\u5229\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(26));
                errorList.add(vo);
                continue;
            }
            try {
                String taxesSurchargesStr = (String)((List)result.get(i)).get(27);
                vo.setTaxesSurcharges(new BigDecimal(taxesSurchargesStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u7a0e\u91d1\u53ca\u9644\u52a0\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(27));
                errorList.add(vo);
                continue;
            }
            try {
                String managementExpensesStr = (String)((List)result.get(i)).get(28);
                vo.setManagementExpenses(new BigDecimal(managementExpensesStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u7ba1\u7406\u8d39\u7528\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(28));
                errorList.add(vo);
                continue;
            }
            try {
                String rdExpensesStr = (String)((List)result.get(i)).get(29);
                vo.setRdExpenses(new BigDecimal(rdExpensesStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u7814\u53d1\u8d39\u7528\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(29));
                errorList.add(vo);
                continue;
            }
            try {
                String financialExpensesStr = (String)((List)result.get(i)).get(30);
                vo.setFinancialExpenses(new BigDecimal(financialExpensesStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u8d22\u52a1\u8d39\u7528\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(30));
                errorList.add(vo);
                continue;
            }
            try {
                String assetCreditImpairmentLossStr = (String)((List)result.get(i)).get(31);
                vo.setAssetCreditImpairmentLoss(new BigDecimal(assetCreditImpairmentLossStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u8d44\u4ea7/\u4fe1\u7528\u51cf\u503c\u635f\u5931\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(31));
                errorList.add(vo);
                continue;
            }
            try {
                String otherIncomeExpensesStr = (String)((List)result.get(i)).get(32);
                vo.setOtherIncomeExpenses(new BigDecimal(otherIncomeExpensesStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u5176\u4ed6\uff08\u6536\u76ca\u8d1f\u6570\u5217\u793a\uff09\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(32));
                errorList.add(vo);
                continue;
            }
            try {
                String financialProjectProfitStr = (String)((List)result.get(i)).get(33);
                vo.setFinancialProjectProfit(new BigDecimal(financialProjectProfitStr));
            }
            catch (Exception e) {
                vo.setErrorMsg("\u3010\u8d22\u52a1\u9879\u76ee\u51c0\u5229\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1a" + (String)((List)result.get(i)).get(33));
                errorList.add(vo);
                continue;
            }
            successList.add(vo);
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @Override
    public CommonResponse<List<Map<String, String>>> selectCompanyState(List<Map<String, String>> ans, String data, String value) {
        int check = 1;
        if (value != null) {
            try {
                check = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return CommonResponse.error((String)("\u68c0\u67e5\u7b5b\u9009\u6761\u4ef6\u503c\u3010value\u3011\uff01=>\u3010" + value + "\u3011"), ans);
            }
        }
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        Map<String, Object> map = null;
        switch (check) {
            case 1: {
                map = this.companyStateDetailMapper.countByCompletionEstimateType();
                break;
            }
            case 2: {
                map = this.companyStateDetailMapper.countByCumulativeOperationType();
                break;
            }
            case 3: {
                map = this.companyStateDetailMapper.countByFinancialProfitType();
                break;
            }
            default: {
                return CommonResponse.error((String)("\u68c0\u67e5\u7b5b\u9009\u6761\u4ef6\u503c\u3010value\u3011\uff01=>\u3010" + value + "\u3011"), ans);
            }
        }
        if (map == null || map.isEmpty()) {
            for (Map<String, String> an : ans) {
                an.put("one", "0");
                an.put("two", "0");
                an.put("three", "0");
            }
            return CommonResponse.success((String)"\u6570\u636e\u67e5\u8be2\u6210\u529f", ans);
        }
        for (Map<String, String> an : ans) {
            Object one = map.get("one");
            an.put("one", one == null ? "0" : one.toString());
            Object two = map.get("two");
            an.put("two", two == null ? "0" : two.toString());
            Object three = map.get("three");
            an.put("three", three == null ? "0" : three.toString());
        }
        return CommonResponse.success((String)"\u6570\u636e\u67e5\u8be2\u6210\u529f", ans);
    }
}

