package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.FinancialOrgEntity;
import com.ejianc.foundation.share.service.IFinancialOrgService;
import com.ejianc.foundation.share.vo.FinancialOrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 集团财务科目实体
 *
 * @author generator
 */
@Controller
@RequestMapping("financialOrg")
public class FinancialOrgController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IBillTypeApi billTypeApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IFinancialOrgService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FinancialOrgVO> saveOrUpdate(@RequestBody FinancialOrgVO saveOrUpdateVO) {
        return service.saveOrUpdate(saveOrUpdateVO);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FinancialOrgVO> queryDetail(Long id) {
        FinancialOrgEntity entity = service.selectById(id);
        FinancialOrgVO vo = BeanMapper.map(entity, FinancialOrgVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @GetMapping(value = "/queryByCodeAndName")
    @ResponseBody
    public CommonResponse<FinancialOrgVO> queryByCodeAndName(@RequestParam(value = "code") String code,
                                                           @RequestParam(value = "name") String name) {
        QueryWrapper<FinancialOrgEntity> query = new QueryWrapper<>();
        query.eq("code", code);
        query.eq("name", name);
        FinancialOrgEntity entity = service.getOne(query);

        if(null != entity) {
            return CommonResponse.success("查询成功！", BeanMapper.map(entity, FinancialOrgVO.class));
        }

        return CommonResponse.error("配找到匹配的集团财务科目信息！");
    }


    /**
     * @Description saveOrUpdate 修改状态
     */
    @RequestMapping(value = "/updateEn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FinancialOrgVO> updateEn(@RequestBody FinancialOrgVO saveorUpdateVO) {
        return service.updateEn(saveorUpdateVO);
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody FinancialOrgVO vo) {
        List<Long> ids = vo.getIds();
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                CommonResponse<String> resp = billTypeApi.checkQuote("EJCBT202206000016", id);
                if (!resp.isSuccess()) {
                    return CommonResponse.error("删除失败！" + resp.getMsg());
                }
            }
            service.removeByIds(ids);
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询分类树
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @SuppressWarnings("rawtypes")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("code", "asc");
        List<FinancialOrgEntity> list = service.queryList(param, false);
        List<Map> resultMapList = BeanMapper.mapList(list, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }

    /**
     * 导出的模板 的下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "financialOrg-export.xlsx", "集团财务科目导出模板");
    }

    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImport(request,response);
    }


    @RequestMapping(value = "/saveImportExcel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<FinancialOrgVO> importVOS) {
        return CommonResponse.success((String) service.saveImportExcel(request, importVOS));
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<FinancialOrgEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FinancialOrg-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refFinancialOrgData", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> refFinancialOrgData(@RequestParam(value = "searchText", required = false) String searchText,
                                       @RequestParam(value = "condition", required = false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("innerCode")) {
                param.getParams().put("innerCode", new Parameter(QueryParam.LIKE, _con.get("innerCode")));
            }
        }
        param.getOrderMap().put("code", "asc");

        List<FinancialOrgEntity> list = service.queryList(param, false);
        List<Map> resultMapList = new ArrayList<Map>();
        Map map = null;
        for(FinancialOrgEntity entity:list) {
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getName());
            map.put("code", entity.getCode());
            map.put("parentId", entity.getParentId());
            map.put("memo", entity.getMemo());
            map.put("innerCode", entity.getInnerCode());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }
}
