package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.teautil.Common;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.bean.ProsubCategoryEntity;
import com.ejianc.foundation.share.bean.SubjectOrgCategoryEntity;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.service.ISubjectOrgCategoryService;
import com.ejianc.foundation.share.service.ISubjectOrgService;
import com.ejianc.foundation.share.vo.RefProsubCategoryVO;
import com.ejianc.foundation.share.vo.SubjectOrgCategoryVO;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.naming.CompositeName;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 成本专业类型
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("subjectOrgCategory")
public class SubjectOrgCategoryController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "SUBJECT_CATEGORY";

    @Autowired
    private ISubjectOrgCategoryService service;

    @Autowired
    private IProjectSetService projectSetService;

    @Autowired
    private ISubjectOrgService subjectOrgService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    public CommonResponse<SubjectOrgCategoryVO> saveOrUpdate(@RequestBody SubjectOrgCategoryVO saveOrUpdateVO) {
        SubjectOrgCategoryEntity entity = BeanMapper.map(saveOrUpdateVO, SubjectOrgCategoryEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            if(StringUtils.isBlank(entity.getCode())) {
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setCode(billCode.getData());
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
        }
        service.saveOrUpdate(entity, false);
        SubjectOrgCategoryVO vo = BeanMapper.map(entity, SubjectOrgCategoryVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    public CommonResponse<SubjectOrgCategoryVO> queryDetail(Long id) {
        SubjectOrgCategoryEntity entity = service.selectById(id);
        SubjectOrgCategoryVO vo = BeanMapper.map(entity, SubjectOrgCategoryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@RequestBody List<SubjectOrgCategoryVO> vos) {
        List<Long> ids = vos.stream().map(SubjectOrgCategoryVO::getId).collect(Collectors.toList());
        List<SubjectOrgVO> subjectOrgVOList = subjectOrgService.getAllByCategoryIds(ids);
        if(CollectionUtils.isNotEmpty(subjectOrgVOList)) {
            return CommonResponse.error("要删除的专业类型下存在成本科目信息，不能进行删除操作！");
        }
        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    public CommonResponse<IPage<SubjectOrgCategoryVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<SubjectOrgCategoryEntity> page = service.queryPage(param,false);
        IPage<SubjectOrgCategoryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubjectOrgCategoryVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @Description saveOrUpdate 修改状态
     */
    @RequestMapping(value = "/updateEnableStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubjectOrgCategoryVO> updateEnableStatus(@RequestBody SubjectOrgCategoryVO saveOrUpdateVO) {
        SubjectOrgCategoryEntity entity = service.selectById(saveOrUpdateVO.getId());
        entity.setEnabled(saveOrUpdateVO.getEnabled());
        service.saveOrUpdate(entity, false);
        return CommonResponse.success("操作成功！", BeanMapper.map(entity, SubjectOrgCategoryVO.class));
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        List<SubjectOrgCategoryEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubjectOrgCategory-export.xlsx", beans, response);
    }

    /**
     * 参照异步（懒加载）树----专业分包分类树
     *
     * @param condition
     * @param searchText lazyProsubCategoryTree
     * @return
     */
    @RequestMapping(value = "/subjectCategoryTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> lazyProsubCategoryTree(@RequestParam(required = false) Integer pageNumber, @RequestParam(required = false) Integer pageSize,
                                                            String condition,
                                                            String searchObject,
                                                            String searchText,
                                                            Long pid
    ) {
        QueryParam param = new QueryParam();
        param.setPageSize(-1);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", Parameter.getEqInstance(1));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(null != _con.getString("projectId")) {
                //查询项目专业类型
                ProjectSetPoolEntity project = projectSetService.selectById(Long.valueOf(_con.getString("projectId")));
                if(null == project) {
                    throw new BusinessException("查询失败，未查询到当前项目信息！");
                }
                if(null == project.getSubjectOrgCategoryId()) {
                    throw new BusinessException("查询失败，当前项目未设置成本专业类型！");
                }

                param.getParams().put("id", Parameter.getEqInstance(project.getSubjectOrgCategoryId()));
            }
        }
        List<SubjectOrgCategoryEntity> categoryEntities = service.queryList(param);
        List<SubjectOrgCategoryVO> categoryVOS = BeanMapper.mapList(categoryEntities, SubjectOrgCategoryVO.class);
        List<Map> map = BeanMapper.mapList(categoryVOS, Map.class);

        List<Map<String, Object>> treeData = ResultAsTree.createTreeData(map);
        if (CollectionUtils.isNotEmpty(treeData)) {
            map.forEach(item -> {
                item.put("isLeaf", true);
            });
        }
        return treeData;
    }

    @RequestMapping(value = "/refSubjectOrgCategoryData", method = RequestMethod.GET)
    public CommonResponse<IPage<SubjectOrgCategoryVO>> refSubjectOrgCategoryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                 String condition,
                                                                                 String searchObject,
                                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", Parameter.getEqInstance(1));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(null != _con.getString("projectId")) {
                //查询项目专业类型
                ProjectSetPoolEntity project = projectSetService.selectById(Long.valueOf(_con.getString("projectId")));
                if(null == project) {
                    return CommonResponse.error("查询失败，未查询到当前项目信息！");
                }
                if(null == project.getSubjectOrgCategoryId()) {
                    return CommonResponse.error("查询失败，当前项目未设置成本专业类型！");
                }

                param.getParams().put("id", Parameter.getEqInstance(project.getSubjectOrgCategoryId()));
            }
        }

        IPage<SubjectOrgCategoryEntity> page = service.queryPage(param,false);
        IPage<SubjectOrgCategoryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubjectOrgCategoryVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }
}
