/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.ejianc.foundation.share.bean.ItemDocApplyDetailEntity;
import com.ejianc.foundation.share.bean.ItemDocApplyEntity;
import com.ejianc.foundation.share.bean.LabsubItemEntity;
import com.ejianc.foundation.share.bean.ProsubItemEntity;
import com.ejianc.foundation.share.service.IItemDocApplyService;
import com.ejianc.foundation.share.service.ILabsubItemService;
import com.ejianc.foundation.share.service.IProsubItemService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="itemDocApply")
public class ItemDocApplyBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IItemDocApplyService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProsubItemService prosubItemService;
    @Autowired
    private ILabsubItemService labsubItemService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ItemDocApplyEntity entity = (ItemDocApplyEntity)((Object)this.service.selectById(billId));
        UserContext user = this.sessionManager.getUserContext();
        entity.setCommitDate(new Date());
        entity.setCommitUserCode(user.getUserCode());
        entity.setCommitUserName(user.getUserName());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        ItemDocApplyEntity entity = (ItemDocApplyEntity)((Object)this.service.selectById(billId));
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(entity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(entity.getBillState())) {
            return CommonResponse.error((String)"\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        List<BaseEntity> saveEntities;
        ItemDocApplyEntity entity = (ItemDocApplyEntity)((Object)this.service.selectById(billId));
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
            UserContext user = this.sessionManager.getUserContext();
            entity.setCommitDate(new Date());
            entity.setCommitUserCode(user.getUserCode());
            entity.setCommitUserName(user.getUserName());
        }
        if ("labsub".equals(entity.getApplyItemType())) {
            saveEntities = this.transferLabsubList(entity.getDetailList());
            this.labsubItemService.saveOrUpdateBatch(saveEntities, saveEntities.size(), false);
        } else {
            saveEntities = this.transferProsubList(entity.getDetailList());
            this.prosubItemService.saveOrUpdateBatch(saveEntities, saveEntities.size(), false);
        }
        entity.setEffectiveDate(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success();
    }

    private List<ProsubItemEntity> transferProsubList(List<ItemDocApplyDetailEntity> detailList) {
        ArrayList<ProsubItemEntity> saveList = new ArrayList<ProsubItemEntity>();
        ProsubItemEntity tmp = null;
        for (ItemDocApplyDetailEntity item : detailList) {
            tmp = new ProsubItemEntity();
            tmp.setTrawlingName(item.getItemName());
            tmp.setTrawlingCode(item.getItemCode());
            tmp.setCategoryId(item.getCategoryId());
            tmp.setCategoryName(item.getCategoryName());
            tmp.setJobContent(item.getJobContent());
            tmp.setPriceType(item.getPriceType());
            tmp.setDetailMeasurementRules(item.getSpec());
            tmp.setUnitName(item.getUnitName());
            tmp.setEnabled(0);
            tmp.setCreateUserCode(InvocationInfoProxy.getUsercode());
            tmp.setCreateTime(new Date());
            tmp.setTenantId(InvocationInfoProxy.getTenantid());
            tmp.setSubjectIds(item.getExtField1());
            tmp.setSubjectNames(item.getExtField2());
            tmp.setSubjectRelations(item.getExtField3());
            saveList.add(tmp);
        }
        return saveList;
    }

    private List<LabsubItemEntity> transferLabsubList(List<ItemDocApplyDetailEntity> detailList) {
        ArrayList<LabsubItemEntity> saveList = new ArrayList<LabsubItemEntity>();
        LabsubItemEntity tmp = null;
        for (ItemDocApplyDetailEntity item : detailList) {
            tmp = new LabsubItemEntity();
            tmp.setTrawlingName(item.getItemName());
            tmp.setTrawlingCode(item.getItemCode());
            tmp.setCategoryId(item.getCategoryId());
            tmp.setCategoryName(item.getCategoryName());
            tmp.setJobContent(item.getJobContent());
            tmp.setPriceType(item.getPriceType());
            tmp.setDetailMeasurementRules(item.getSpec());
            tmp.setUnitName(item.getUnitName());
            tmp.setEnabled(0);
            tmp.setCreateUserCode(InvocationInfoProxy.getUsercode());
            tmp.setCreateTime(new Date());
            tmp.setTenantId(InvocationInfoProxy.getTenantid());
            tmp.setSubjectIds(item.getExtField1());
            tmp.setSubjectNames(item.getExtField2());
            tmp.setSubjectRelations(item.getExtField3());
            saveList.add(tmp);
        }
        return saveList;
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ItemDocApplyEntity entity = (ItemDocApplyEntity)((Object)this.service.selectById(billId));
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(entity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(entity.getBillState())) {
            return CommonResponse.error((String)"\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

