/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.support.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.support.bean.CommonSNEntity;
import com.ejianc.foundation.support.mapper.CommonSNMapper;
import com.ejianc.foundation.support.service.ICommonSNService;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="commonNSService")
public class CommonSNServiceImpl
extends BaseServiceImpl<CommonSNMapper, CommonSNEntity>
implements ICommonSNService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JedisPool jedisPool;
    private final String LOCK_KEY_PREFIX = "redis_lock_key::material";
    private final String OPERATE = "GENERATE_ITEM_CODE";
    private long retryInterval = 5000L;
    private final int maxRetryTime = 10;
    private final String billType = "EJCBT202311000003";
    private final Integer defaultSnLength = 9;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> generateSnList(String code, int count, Integer snLength) {
        String lockKey = "redis_lock_key::material" + code;
        Jedis jedis = this.jedisPool.getResource();
        this.logger.info("\u4ecejedisPool\u83b7\u53d6jedis\u5bf9\u8c61\uff0cjedis\u5bf9\u8c61-{}", (Object)jedis);
        boolean lock = this.getLock(lockKey, jedis);
        if (!lock) {
            this.logger.info("\u952e-{}\u5c1d\u8bd5\u83b7\u53d6\u9501\u5931\u8d25,", (Object)lockKey);
            throw new BusinessException("\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u83b7\u53d6\u9501\u5931\u8d25");
        }
        try {
            Integer snLen;
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"source_type", (Object)"EJCBT202311000003");
            query.eq((Object)"dimension", (Object)code);
            query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
            CommonSNEntity curSn = (CommonSNEntity)((Object)super.getOne((Wrapper)query));
            Long startSn = 1L;
            Integer n = snLen = null != snLength ? snLength : this.defaultSnLength;
            if (null == curSn) {
                curSn = new CommonSNEntity();
                curSn.setDimension(code);
                curSn.setTenantId(InvocationInfoProxy.getTenantid());
                curSn.setSourceType("EJCBT202311000003");
                curSn.setSnLength(snLen);
                curSn.setCurSn(Long.valueOf(count));
                curSn.setVersion(0);
            } else {
                startSn = curSn.getCurSn() + 1L;
                curSn.setCurSn(curSn.getCurSn() + (long)count);
            }
            boolean rs = super.saveOrUpdate((Object)curSn, false);
            if (!rs) {
                throw new BusinessException("\u751f\u6210\u6d41\u6c34\u53f7\u5931\u8d25\uff0c\u83b7\u53d6\u6700\u65b0\u6d41\u6c34\u53f7\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            }
            ArrayList<String> codes = new ArrayList<String>();
            for (long start = startSn.longValue(); start <= curSn.getCurSn(); ++start) {
                if (snLen > 0) {
                    codes.add(code + String.format("%0" + snLen + "d", start));
                    continue;
                }
                codes.add(code + (start < 10L ? "0" + start : Long.valueOf(start)));
            }
            ArrayList<String> arrayList = codes;
            return arrayList;
        }
        finally {
            this.unLock(jedis, true, lockKey, "GENERATE_ITEM_CODE");
        }
    }

    public boolean getLock(String key, Jedis jedis) {
        boolean lock = false;
        for (int retryTime = 0; !lock && retryTime <= 10; ++retryTime) {
            try {
                if (retryTime <= 0) continue;
                this.logger.info("\u952e-{}\u7b2c{}\u6b21\u5c1d\u8bd5\u83b7\u53d6redis\u9501, \u7b2c{}\u6beb\u79d2\u540e\u5f00\u59cb\u5c1d\u8bd5", new Object[]{key, retryTime, (long)retryTime * this.retryInterval});
                Thread.sleep((long)retryTime * this.retryInterval);
                lock = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"GENERATE_ITEM_CODE", (int)600);
                if (!lock) continue;
                return true;
            }
            catch (Exception e) {
                this.logger.error("\u6839\u636e\u952e-{}\u83b7\u53d6reids\u9501\u5f02\u5e38", (Object)JSONObject.toJSONString((Object)key));
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unLock(Jedis jedis, boolean locked, String key, String operate) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)operate);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }
}

