package com.ejianc.foundation.share.mapper;

import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.vo.ProjectDesktopSubParentVO;
import com.ejianc.foundation.share.vo.ProjectDesktopSubVO;
import com.ejianc.foundation.share.vo.ProjectDesktopVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Mapper
public interface ProjectSetMapper extends BaseCrudMapper<ProjectSetPoolEntity> {


    List<ProjectDesktopSubVO> countBusinessStatus(@Param("commonOrgIds") List<Long> commonOrgIds, @Param("departmentIds") List<Long> departmentIds, @Param("businessStatusList") List<String> businessStatusList);

    List<ProjectDesktopSubParentVO> countBusinessStatusParent(@Param("commonOrgIds") List<Long> commonOrgIds, @Param("departmentIds") List<Long> departmentIds);

    ProjectDesktopVO countProjectStatus(@Param("commonOrgIds") List<Long> commonOrgIds, @Param("departmentIds") List<Long> departmentIds, @Param("startDate") String startDate);

    void deleteProjectById(@Param("ids") List<Long> ids);

    List<ProjectSetPoolEntity> queryMdmPage(Map<String, Object> condition);

    BigDecimal queryThisYearProjectNum(@Param("commonOrgIds") List<Long> commonOrgIds, @Param("departmentIds") List<Long> departmentIds, @Param("thisYear") String thisYear);
}
