/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.share.bean.UnitEntity;
import com.ejianc.foundation.share.mapper.UnitMapper;
import com.ejianc.foundation.share.service.IUnitService;
import com.ejianc.foundation.share.service.impl.EquipmentServiceImpl;
import com.ejianc.foundation.share.vo.UnitVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="unitService")
public class UnitServiceImpl
extends BaseServiceImpl<UnitMapper, UnitEntity>
implements IUnitService {
    @Autowired
    private IUnitService unitService;
    @Autowired
    private UnitMapper unitMapper;
    @Autowired
    private EquipmentServiceImpl equipmentService;

    @Override
    public CommonResponse<UnitVO> saveOrUpdate(UnitVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        UnitEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(saveorUpdateVO.getId());
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(UnitEntity::getUnitCode, (Object)saveorUpdateVO.getUnitCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            List entities = super.list((Wrapper)lambda);
            if (entities != null && entities.size() > 0) {
                return CommonResponse.error((String)"\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            LambdaQueryWrapper nameLambda = Wrappers.lambdaQuery();
            nameLambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            nameLambda.eq(UnitEntity::getUnitName, (Object)saveorUpdateVO.getUnitName());
            nameLambda.ne(BaseEntity::getId, (Object)saveorUpdateVO.getId());
            List nameEntities = super.list((Wrapper)nameLambda);
            if (nameEntities != null && nameEntities.size() > 0) {
                return CommonResponse.error((String)"\u5b58\u5728\u76f8\u540c\u540d\u79f0\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            entity = (UnitEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, UnitEntity.class));
            super.saveOrUpdate((Object)entity, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        LambdaQueryWrapper codeLambda = Wrappers.lambdaQuery();
        codeLambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        codeLambda.eq(UnitEntity::getUnitCode, (Object)saveorUpdateVO.getUnitCode());
        List codeEntities = super.list((Wrapper)codeLambda);
        if (codeEntities != null && codeEntities.size() > 0) {
            return CommonResponse.error((String)"\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        LambdaQueryWrapper nameLambda = Wrappers.lambdaQuery();
        nameLambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        nameLambda.eq(UnitEntity::getUnitName, (Object)saveorUpdateVO.getUnitName());
        List nameEntities = super.list((Wrapper)nameLambda);
        if (nameEntities != null && nameEntities.size() > 0) {
            return CommonResponse.error((String)"\u5b58\u5728\u76f8\u540c\u540d\u79f0\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity = (UnitEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, UnitEntity.class));
        entity.setId(IdWorker.getId());
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            ArrayList<UnitVO> unitVOList = new ArrayList<UnitVO>();
            for (int i = 1; i < result.size(); ++i) {
                QueryParam queryParam = new QueryParam();
                ArrayList<String> codeList = new ArrayList<String>();
                ArrayList<String> nameList = new ArrayList<String>();
                List oldList = this.unitService.queryList(queryParam);
                for (UnitEntity unitEntity : oldList) {
                    codeList.add(unitEntity.getUnitCode());
                    nameList.add(unitEntity.getUnitName());
                }
                List datas = (List)result.get(i);
                UnitVO vo2 = new UnitVO();
                boolean flag = false;
                String warnType = "";
                String unitCode = (String)datas.get(0);
                vo2.setUnitCode(unitCode);
                if (StringUtils.isEmpty((CharSequence)unitCode)) {
                    vo2.setUnitCode(null);
                    warnType = warnType + "\u7f16\u7801\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    if (codeList.contains(unitCode)) {
                        vo2.setUnitCode(unitCode);
                        warnType = warnType + "\u7f16\u7801\u91cd\u590d,";
                        flag = true;
                    }
                    vo2.setUnitCode(unitCode);
                }
                String unitName = (String)datas.get(1);
                vo2.setUnitName(unitName);
                if (StringUtils.isEmpty((CharSequence)unitName)) {
                    vo2.setUnitName(null);
                    warnType = warnType + "\u540d\u79f0\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    if (codeList.contains(unitName)) {
                        vo2.setUnitName(unitName);
                        warnType = warnType + "\u540d\u79f0\u91cd\u590d,";
                        flag = true;
                    }
                    vo2.setUnitName(unitName);
                }
                vo2.setEnabled(Integer.valueOf(1));
                vo2.setImportFlag(Boolean.valueOf(!flag));
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo2.setWarnType(warnType);
                vo2.setRowState("add");
                unitVOList.add(vo2);
            }
            ArrayList successList = new ArrayList();
            ArrayList errorList = new ArrayList();
            if (CollectionUtils.isNotEmpty(unitVOList)) {
                unitVOList.forEach(vo -> {
                    if (StringUtils.isEmpty((CharSequence)vo.getWarnType())) {
                        successList.add(vo);
                    } else {
                        errorList.add(vo);
                    }
                });
            }
            resp.put("successList", successList);
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)(result.size() - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public Object saveImportExcel(HttpServletRequest request, List<UnitVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList<UnitEntity> list = new ArrayList<UnitEntity>();
        for (UnitVO importVO : importVOS) {
            UnitEntity unit = (UnitEntity)((Object)BeanMapper.map((Object)importVO, UnitEntity.class));
            unit.setEnabled(1);
            list.add(unit);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            super.saveOrUpdateBatch(list);
        }
        return "\u4fdd\u5b58\u6210\u529f\uff01";
    }

    @Override
    public List<UnitVO> getAllByNames(List<String> unitNames) {
        ArrayList<UnitVO> resp = new ArrayList<UnitVO>();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.in((Object)"unit_name", unitNames);
        List dbEntities = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)dbEntities)) {
            return BeanMapper.mapList((Iterable)dbEntities, UnitVO.class);
        }
        return resp;
    }
}

