package com.ejianc.foundation.share.config;

import org.apache.activemq.ActiveMQConnectionFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.config.SimpleJmsListenerContainerFactory;

import javax.jms.ConnectionFactory;

/**
 * @author yqls
 * @date 2025-02-08 15:32:28
 */

@Configuration
public class ActiveMQConfig {

    @Value("${spring.activemq.broker-url}")
    private String brokerUrl;

    @Value("${spring.activemq.user}")
    private String user;

    @Value("${spring.activemq.password}")
    private String password;

    @Bean("mqConnectionFactory")
    public ConnectionFactory connectionFactory() {
        return new ActiveMQConnectionFactory(user, password, brokerUrl);
    }

    /**
     * 在Queue模式中，对消息的监听需要对containerFactory进行配置
     *
     * @param connectionFactory
     * @return
     */
    @Bean("queueListener")
    public JmsListenerContainerFactory<?> queueJmsListenerContainerFactory(@Qualifier("mqConnectionFactory") ConnectionFactory connectionFactory) {
        SimpleJmsListenerContainerFactory factory = new SimpleJmsListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
//        //队列后缀添加，后续不需要可以注掉
//        factory.setDestinationResolver((session, destinationName, pubSubDomain) -> {
//            String dynamicDestination = destinationName + queueTestFlag;
//            return session.createQueue(dynamicDestination);
//        });
        factory.setPubSubDomain(false);
        return factory;
    }

    /**
     * 在Topic模式中，对消息的监听需要对containerFactory进行配置
     *
     * @param connectionFactory
     * @return
     */
    @Bean("topicListener")
    public JmsListenerContainerFactory<?> topicJmsListenerContainerFactory(@Qualifier("mqConnectionFactory") ConnectionFactory connectionFactory) {
        SimpleJmsListenerContainerFactory factory = new SimpleJmsListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setPubSubDomain(true);
        // 设置为持久化订阅
        //factory.setSubscriptionDurable(subscriptionDurable);
        //factory.setClientId(clientId);
        return factory;
    }

    /**
     * 监听器容器工厂
     *
     * @param connectionFactory
//     * @param errorHandler
     * @return
     */
    @Bean
    public JmsListenerContainerFactory<?> jmsListenerContainerFactory(@Qualifier("mqConnectionFactory") ConnectionFactory connectionFactory) {
        DefaultJmsListenerContainerFactory factory = new DefaultJmsListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
//        // 设置自定义的ErrorHandler
//        factory.setErrorHandler(errorHandler);
        return factory;
    }
}
