/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.company.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pro.income.api.IProincomeBudgetApi;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.pro.income.vo.ProductionVO;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.zhht.vo.BuildDutyVO;
import com.ejianc.foundation.company.bean.CompanyStateDetailEntity;
import com.ejianc.foundation.company.bean.CompanyStateEntity;
import com.ejianc.foundation.company.service.ICompanyStateService;
import com.ejianc.foundation.cpmpany.vo.CompanyStateDetailVO;
import com.ejianc.foundation.cpmpany.vo.CompanyStateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"companyState"})
public class CompanyStateController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDutyApi iDutyApi;
    @Autowired
    private IProincomeBudgetApi proincomeBudgetApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectSetService projectSetExPoolService;
    private static final String BILL_CODE = "COMPANY_STATE_CODE";
    @Autowired
    private ICompanyStateService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CompanyStateVO> saveOrUpdate(@RequestBody CompanyStateVO saveOrUpdateVO) {
        CommonResponse<List<CompanyStateDetailEntity>> response;
        CompanyStateEntity entity = (CompanyStateEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CompanyStateEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (!(response = this.updateCompanyStateDetailEntity(entity)).isSuccess()) {
            return CommonResponse.error((String)response.getMsg(), null);
        }
        entity.setCompanyStateDetailList((List)response.getData());
        this.service.saveOrUpdate((Object)entity, false);
        CompanyStateVO vo = (CompanyStateVO)BeanMapper.map((Object)((Object)entity), CompanyStateVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CompanyStateVO> queryDetail(Long id) {
        CompanyStateEntity entity = (CompanyStateEntity)((Object)this.service.selectById(id));
        CommonResponse<List<CompanyStateDetailEntity>> updated = this.updateCompanyStateDetailEntity(entity);
        if (!updated.isSuccess()) {
            String msg = updated.getMsg();
            return CommonResponse.error((String)msg, null);
        }
        entity.setCompanyStateDetailList((List)updated.getData());
        CompanyStateVO vo = (CompanyStateVO)BeanMapper.map((Object)((Object)entity), CompanyStateVO.class);
        CommonResponse<List<CompanyStateDetailVO>> response = this.updateCompanyStateDetailVo(vo);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg(), (Object)vo);
        }
        List data = (List)response.getData();
        vo.setCompanyStateDetailList(data);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CompanyStateVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CompanyStateVO companyStateVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u9879\u76ee\u5217\u8868")
    @RequestMapping(value={"/queryProjects"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<CompanyStateDetailVO>> queryProjects(@RequestBody QueryParam param) {
        Parameter orgId = (Parameter)param.getParams().get("orgId");
        if (orgId == null) {
            return CommonResponse.error((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\uff01");
        }
        Object object = orgId.getValue();
        if (object == null) {
            return CommonResponse.error((String)"\u8bf7\u68c0\u67e5\u7ec4\u7ec7\u662f\u5426\u6b63\u786e\uff01");
        }
        List list = null;
        try {
            long aLong = Long.parseLong(object.toString());
            list = ((List)this.iOrgApi.findChildrenByParentId(Long.valueOf(aLong)).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        catch (NumberFormatException e) {
            return CommonResponse.error((String)"\u7ec4\u7ec7\u9009\u62e9\u5f02\u5e38");
        }
        param.getParams().put("orgId", new Parameter("in", list));
        List poolEntities = this.projectSetExPoolService.queryList(param);
        ArrayList<Long> projectIds = new ArrayList<Long>();
        if (poolEntities == null || poolEntities.isEmpty()) {
            return CommonResponse.success((String)"\u6ca1\u6709\u6570\u636e\uff01", new ArrayList());
        }
        for (ProjectSetPoolEntity en : poolEntities) {
            if (en.getId() == null) {
                return CommonResponse.error((String)"\u9879\u76eeID\u4e3a\u7a7a\u5f02\u5e38\uff01", new ArrayList());
            }
            projectIds.add(en.getId());
        }
        CommonResponse response = this.proincomeBudgetApi.productionQueryProjects(projectIds);
        HashMap productionVOMap = new HashMap();
        for (ProductionVO vo : (List)response.getData()) {
            Long projectId = vo.getProjectId();
            if (!productionVOMap.containsKey(projectId)) {
                productionVOMap.put(projectId, new ArrayList());
            }
            ((List)productionVOMap.get(projectId)).add(vo);
        }
        CommonResponse commonResponse = this.proincomeBudgetApi.QueryProjects(projectIds);
        HashMap<Long, ContractRegisterVO> contractRegisterVOMap = new HashMap<Long, ContractRegisterVO>();
        for (ContractRegisterVO datum : (List)commonResponse.getData()) {
            contractRegisterVOMap.put(datum.getProjectId(), datum);
        }
        CommonResponse built = this.iDutyApi.buildQueryProjects(projectIds);
        HashMap<Long, BuildDutyVO> dutyVOMap = new HashMap<Long, BuildDutyVO>();
        for (BuildDutyVO datum : (List)built.getData()) {
            dutyVOMap.put(datum.getProjectId(), datum);
        }
        ArrayList<CompanyStateDetailVO> ans = new ArrayList<CompanyStateDetailVO>();
        this.logger.info("\u83b7\u53d6\u5f53\u524d\u9879\u76eeID\u5bf9\u5e94\u7684\u7b56\u5212\u6210\u672c,{}", dutyVOMap);
        this.logger.info("------------------------------------------------------------");
        this.logger.info("\u83b7\u53d6\u5f53\u524d\u9879\u76eeID\u5bf9\u5e94\u7684\u5de5\u7a0b\u627f\u5305\u5408\u540c,{}", contractRegisterVOMap);
        this.logger.info("------------------------------------------------------------");
        this.logger.info("\u516c\u53f8\u5185\u90e8\u4ea7\u503c\uff08\u6708\u5ea6\uff09\u4e2d\u3010\u672c\u671f\u7d2f\u8ba1\u4ea7\u503c\u3011\u91d1\u989d\u6c47\u603b,{}", productionVOMap);
        this.logger.info("------------------------------------------------------------");
        for (ProjectSetPoolEntity en : poolEntities) {
            List vos;
            CompanyStateDetailVO vo = new CompanyStateDetailVO();
            long id = IdWorker.getId();
            vo.setId(Long.valueOf(id));
            vo.setProjectId(en.getId());
            vo.setProjectName(en.getName());
            try {
                vo.setProjectStatus(Integer.valueOf(Integer.parseInt(en.getProjectStatus())));
            }
            catch (NumberFormatException e) {
                this.logger.debug("\u9879\u76ee\u72b6\u6001\u8f6c\u6362\u5f02\u5e38");
            }
            vo.setBranch(en.getParentProjectName());
            vo.setActualCommencement(en.getActualStartDate());
            BuildDutyVO dutyVO = (BuildDutyVO)dutyVOMap.get(en.getId());
            ContractRegisterVO registerVO = (ContractRegisterVO)contractRegisterVOMap.get(en.getId());
            this.logger.info("\u83b7\u53d6\u5f53\u524d\u9879\u76eeID\u5bf9\u5e94\u7684\u7b56\u5212\u6210\u672c,{}", (Object)dutyVO);
            this.logger.info("------------------------------------------------------------");
            this.logger.info("\u83b7\u53d6\u5f53\u524d\u9879\u76eeID\u5bf9\u5e94\u7684\u5de5\u7a0b\u627f\u5305\u5408\u540c,{}", (Object)registerVO);
            this.logger.info("------------------------------------------------------------");
            if (registerVO != null) {
                vo.setContractAmount(registerVO.getContractTaxMny());
                vo.setTaxRate(registerVO.getTaxRate());
            }
            if (dutyVO != null) {
                vo.setFreeIncomeTax(dutyVO.getPlanedTotalIncomeMny());
                vo.setRevenueIncludingTax(dutyVO.getPlanedTotalIncomeTaxMny());
                vo.setCostExcludingTax(dutyVO.getPlanedTotalCostMny());
                List sumDetailList = dutyVO.getSumDetailList();
                if (sumDetailList != null && !sumDetailList.isEmpty()) {
                    sumDetailList.forEach(an -> {
                        if ("\u8d22\u52a1\u8d39\u7528".equals(an.getSumFeeName())) {
                            vo.setTotalFinancialExpenses(an.getSumPlanTotalCostMny());
                        }
                    });
                }
                vo.setCostIncludingTax(dutyVO.getPlanedTotalCostMny());
            }
            if ((vos = (List)productionVOMap.get(en.getId())) != null) {
                this.logger.info("\u516c\u53f8\u5185\u90e8\u4ea7\u503c\uff08\u6708\u5ea6\uff09\u4e2d\u3010\u672c\u671f\u7d2f\u8ba1\u4ea7\u503c\u3011\u91d1\u989d\u6c47\u603b,{}", (Object)vos.toString());
            }
            try {
                if (vos != null && !vos.isEmpty()) {
                    BigDecimal cumulativeRevenueIncludingTax = new BigDecimal(0);
                    for (ProductionVO productionVO : vos) {
                        BigDecimal taxMny = productionVO.getProductionTaxMny();
                        cumulativeRevenueIncludingTax = cumulativeRevenueIncludingTax.add(taxMny);
                    }
                } else {
                    vo.setCumulativeRevenueIncludingTax(new BigDecimal(0));
                }
            }
            catch (Exception e) {
                vo.setCumulativeRevenueIncludingTax(new BigDecimal(0));
            }
            ans.add(vo);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", ans);
    }

    @ApiOperation(value="\u5bfc\u5165")
    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return this.service.excelImport(request, response, 0);
    }

    @ApiOperation(value="\u516c\u53f8\u6f5c\u4e8f\u95e8\u6237")
    @RequestMapping(value={"/selectCompanyState"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, String>>> selectCompanyState(@RequestParam(required=false) String data, @RequestParam(required=false) String value) {
        ArrayList<Map<String, String>> ans = new ArrayList<Map<String, String>>();
        for (int i = 0; i <= 4; ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            String s = "";
            switch (i) {
                case 0: {
                    s = "\u7b2c\u4e00\u5b63\u5ea6";
                    break;
                }
                case 1: {
                    s = "\u7b2c\u4e8c\u5b63\u5ea6";
                    break;
                }
                case 2: {
                    s = "\u7b2c\u4e09\u5b63\u5ea6";
                    break;
                }
                case 3: {
                    s = "\u7b2c\u56db\u5b63\u5ea6";
                }
            }
            map.put("first", s);
            ans.add(map);
        }
        return this.service.selectCompanyState(ans, data, value);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CompanyStateVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CompanyStateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CompanyState-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCompanyStateData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CompanyStateVO>> refCompanyStateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CompanyStateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private CommonResponse<List<CompanyStateDetailEntity>> updateCompanyStateDetailEntity(CompanyStateEntity entity) {
        List<CompanyStateDetailEntity> detailList = entity.getCompanyStateDetailList();
        if (detailList == null || detailList.isEmpty()) {
            return CommonResponse.success((String)"\u5b50\u8868\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList<CompanyStateDetailEntity> ans = new ArrayList<CompanyStateDetailEntity>();
        for (CompanyStateDetailEntity detail : detailList) {
            BigDecimal outputTax = null;
            BigDecimal freeIncomeTax = detail.getFreeIncomeTax();
            if (freeIncomeTax == null) {
                return CommonResponse.error((String)("\u3010\u9884\u8ba1\u4e0d\u542b\u7a0e\u603b\u6536\u5165\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1anull\uff0c\u9519\u8bef\u6570\u636e\u9879\u76ee\u540d\u79f0\uff1a\u3010" + detail.getProjectName() + "\u3011"));
            }
            BigDecimal revenueIncludingTax = detail.getRevenueIncludingTax();
            if (revenueIncludingTax == null) {
                return CommonResponse.error((String)("\u3010\u9884\u8ba1\u542b\u7a0e\u603b\u6536\u5165\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1anull\uff0c\u9519\u8bef\u6570\u636e\u9879\u76ee\u540d\u79f0\uff1a\u3010" + detail.getProjectName() + "\u3011"));
            }
            outputTax = revenueIncludingTax.subtract(freeIncomeTax);
            detail.setTotalOutputTax(outputTax);
            BigDecimal inputTaxVatSurcharge = BigDecimal.ZERO;
            BigDecimal costExcludingTax = detail.getCostExcludingTax();
            if (costExcludingTax == null) {
                return CommonResponse.error((String)("\u3010\u9884\u8ba1\u4e0d\u542b\u7a0e\u603b\u6210\u672c\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1anull\uff0c\u9519\u8bef\u6570\u636e\u9879\u76ee\u540d\u79f0\uff1a\u3010" + detail.getProjectName() + "\u3011"));
            }
            BigDecimal costIncludingTax = detail.getCostIncludingTax();
            if (costIncludingTax == null) {
                return CommonResponse.error((String)("\u3010\u9884\u8ba1\u542b\u7a0e\u603b\u6210\u672c\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1anull\uff0c\u9519\u8bef\u6570\u636e\u9879\u76ee\u540d\u79f0\uff1a\u3010" + detail.getProjectName() + "\u3011"));
            }
            BigDecimal totalFinancialExpenses = detail.getTotalFinancialExpenses();
            if (totalFinancialExpenses == null) {
                return CommonResponse.error((String)("\u3010\u9884\u8ba1\u603b\u8d22\u52a1\u8d39\u7528\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1anull\uff0c\u9519\u8bef\u6570\u636e\u9879\u76ee\u540d\u79f0\uff1a\u3010" + detail.getProjectName() + "\u3011"));
            }
            inputTaxVatSurcharge = costIncludingTax.subtract(costExcludingTax).subtract(totalFinancialExpenses);
            detail.setInputTaxVatSurcharge(inputTaxVatSurcharge);
            BigDecimal totalProfitLoss = revenueIncludingTax.subtract(costIncludingTax);
            detail.setTotalProfitLoss(totalProfitLoss);
            BigDecimal totalProfitMargin = BigDecimal.ZERO;
            if (revenueIncludingTax.compareTo(BigDecimal.ZERO) != 0) {
                totalProfitMargin = totalProfitLoss.divide(revenueIncludingTax, 4, RoundingMode.HALF_UP);
            }
            detail.setTotalProfitMargin(totalProfitMargin);
            BigDecimal cumulativeOutputTax = BigDecimal.ZERO;
            BigDecimal cumulativeFreeIncome = detail.getCumulativeFreeIncome();
            if (cumulativeFreeIncome == null) {
                return CommonResponse.error((String)("\u3010\u7d2f\u8ba1\u9500\u9879\u7a0e\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1anull\uff0c\u9519\u8bef\u6570\u636e\u9879\u76ee\u540d\u79f0\uff1a\u3010" + detail.getProjectName() + "\u3011"));
            }
            BigDecimal cumulativeRevenueIncludingTax = detail.getCumulativeRevenueIncludingTax();
            if (cumulativeRevenueIncludingTax == null) {
                return CommonResponse.error((String)("\u3010\u7d2f\u8ba1\u542b\u7a0e\u6536\u5165\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1anull\uff0c\u9519\u8bef\u6570\u636e\u9879\u76ee\u540d\u79f0\uff1a\u3010" + detail.getProjectName() + "\u3011"));
            }
            cumulativeOutputTax = cumulativeRevenueIncludingTax.subtract(cumulativeFreeIncome);
            detail.setCumulativeOutputTax(cumulativeOutputTax);
            BigDecimal cumulativeInputTaxVatSurcharge = BigDecimal.ZERO;
            BigDecimal cumulativeFreeCost = detail.getCumulativeFreeCost();
            BigDecimal cumulativeCostIncludingTax = detail.getCumulativeCostIncludingTax();
            BigDecimal cumulativeFinancialExpenses = detail.getCumulativeFinancialExpenses();
            if (cumulativeFreeCost == null || cumulativeCostIncludingTax == null || cumulativeFinancialExpenses == null) {
                return CommonResponse.error((String)("\u3010\u7d2f\u8ba1\u8fdb\u9879\u7a0e\u3001\u589e\u503c\u7a0e\u3001\u9644\u52a0\u7a0e\u7b49\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1anull\uff0c\u9519\u8bef\u6570\u636e\u9879\u76ee\u540d\u79f0\uff1a\u3010" + detail.getProjectName() + "\u3011"));
            }
            cumulativeInputTaxVatSurcharge = cumulativeCostIncludingTax.subtract(cumulativeFreeCost).subtract(cumulativeFinancialExpenses);
            detail.setCumulativeInputTaxVatSurcharge(cumulativeInputTaxVatSurcharge);
            BigDecimal cumulativeProfitLoss = cumulativeRevenueIncludingTax.subtract(cumulativeCostIncludingTax);
            detail.setCumulativeProfitLoss(cumulativeProfitLoss);
            BigDecimal cumulativeProfitMargin = BigDecimal.ZERO;
            if (cumulativeRevenueIncludingTax.compareTo(BigDecimal.ZERO) != 0) {
                cumulativeProfitMargin = cumulativeProfitLoss.divide(cumulativeRevenueIncludingTax, 4, RoundingMode.HALF_UP);
            }
            detail.setCumulativeProfitMargin(cumulativeProfitMargin);
            BigDecimal financialProjectProfit = BigDecimal.ZERO;
            BigDecimal grossProfit = detail.getGrossProfit();
            BigDecimal taxesSurcharges = detail.getTaxesSurcharges();
            BigDecimal managementExpenses = detail.getManagementExpenses();
            BigDecimal rdExpenses = detail.getRdExpenses();
            BigDecimal financialExpenses = detail.getFinancialExpenses();
            BigDecimal assetCreditImpairmentLoss = detail.getAssetCreditImpairmentLoss();
            BigDecimal otherIncomeExpenses = detail.getOtherIncomeExpenses();
            if (grossProfit == null || taxesSurcharges == null || managementExpenses == null || rdExpenses == null || financialExpenses == null || assetCreditImpairmentLoss == null || otherIncomeExpenses == null) {
                return CommonResponse.error((String)("\u3010\u8d22\u52a1\u9879\u76ee\u51c0\u5229\u3011\u9519\u8bef\uff0c\u9519\u8bef\u6570\u636e\uff1anull\uff0c\u9519\u8bef\u6570\u636e\u9879\u76ee\u540d\u79f0\uff1a\u3010" + detail.getProjectName() + "\u3011"));
            }
            financialProjectProfit = grossProfit.subtract(taxesSurcharges).subtract(managementExpenses).subtract(rdExpenses).subtract(financialExpenses).subtract(assetCreditImpairmentLoss).subtract(otherIncomeExpenses);
            detail.setFinancialProjectProfit(financialProjectProfit);
            ans.add(detail);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", ans);
    }

    private CommonResponse<List<CompanyStateDetailVO>> updateCompanyStateDetailVo(CompanyStateVO vo) {
        List vos = vo.getCompanyStateDetailList();
        if (vos == null || vos.isEmpty()) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)vos);
        }
        ArrayList<CompanyStateDetailVO> ans = new ArrayList<CompanyStateDetailVO>();
        for (CompanyStateDetailVO detail : vos) {
            try {
                BigDecimal cumulativeProfitMargin;
                BigDecimal profitMargin;
                BigDecimal financialProjectProfit = detail.getFinancialProjectProfit() != null ? detail.getFinancialProjectProfit() : BigDecimal.ZERO;
                BigDecimal assetCreditImpairmentLoss = detail.getAssetCreditImpairmentLoss() != null ? detail.getAssetCreditImpairmentLoss() : BigDecimal.ZERO;
                BigDecimal cumulativeProfitLoss = detail.getCumulativeProfitLoss() != null ? detail.getCumulativeProfitLoss() : BigDecimal.ZERO;
                BigDecimal potentialLossAmount = cumulativeProfitLoss.subtract(financialProjectProfit.add(assetCreditImpairmentLoss));
                detail.setPotentialLossAmount(potentialLossAmount);
                if (cumulativeProfitLoss.compareTo(BigDecimal.ZERO) < 0 && cumulativeProfitLoss.compareTo(financialProjectProfit) < 0) {
                    detail.setPotentialLossType(Integer.valueOf(1));
                } else if (cumulativeProfitLoss.compareTo(BigDecimal.ZERO) >= 0 && cumulativeProfitLoss.compareTo(financialProjectProfit) < 0) {
                    detail.setPotentialLossType(Integer.valueOf(2));
                } else {
                    detail.setPotentialLossType(Integer.valueOf(3));
                }
                BigDecimal totalProfitMargin = detail.getTotalProfitMargin() != null ? detail.getTotalProfitMargin() : BigDecimal.ZERO;
                BigDecimal bigDecimal = profitMargin = detail.getProfitMargin() != null ? detail.getProfitMargin() : BigDecimal.ZERO;
                if (totalProfitMargin.compareTo(BigDecimal.ZERO) < 0) {
                    detail.setPotentialLossTypeCompletion(Integer.valueOf(1));
                } else if (totalProfitMargin.compareTo(BigDecimal.ZERO) >= 0 && totalProfitMargin.compareTo(profitMargin) < 0) {
                    detail.setPotentialLossTypeCompletion(Integer.valueOf(2));
                } else {
                    detail.setPotentialLossTypeCompletion(Integer.valueOf(3));
                }
                BigDecimal bigDecimal2 = cumulativeProfitMargin = detail.getCumulativeProfitMargin() != null ? detail.getCumulativeProfitMargin() : BigDecimal.ZERO;
                if (cumulativeProfitMargin.compareTo(BigDecimal.ZERO) < 0) {
                    detail.setPotentialLossTypeAccumulated(Integer.valueOf(1));
                } else if (cumulativeProfitMargin.compareTo(BigDecimal.ZERO) >= 0 && cumulativeProfitMargin.compareTo(profitMargin) < 0) {
                    detail.setPotentialLossTypeAccumulated(Integer.valueOf(2));
                } else {
                    detail.setPotentialLossTypeAccumulated(Integer.valueOf(3));
                }
            }
            catch (Exception e) {
                continue;
            }
            ans.add(detail);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", ans);
    }
}

