/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.PartDocDetailEntity;
import com.ejianc.foundation.share.service.IPartDocDetailService;
import com.ejianc.foundation.share.vo.PartDocDetailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"partDocDetail"})
public class PartDocDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPartDocDetailService service;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "EJCBT202504000019";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PartDocDetailVO> saveOrUpdate(@RequestBody PartDocDetailVO saveOrUpdateVO) {
        return this.service.saveOrUpdate(saveOrUpdateVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PartDocDetailVO> queryDetail(Long id) {
        PartDocDetailEntity entity = (PartDocDetailEntity)((Object)this.service.selectById(id));
        PartDocDetailVO vo = (PartDocDetailVO)BeanMapper.map((Object)((Object)entity), PartDocDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"PartDocDetail-export.xlsx", (String)"\u5206\u90e8\u5206\u9879\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PartDocDetailVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PartDocDetailVO object : vos) {
            }
        }
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        for (Long billId : ids) {
            CommonResponse res = this.billTypeApi.checkQuote(BILL_CODE, billId);
            this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
            if (res.isSuccess()) continue;
            throw new BusinessException("\u5b58\u5728\u88ab\u5f15\u7528\u7684\u6863\u6848\uff0c\u8bf7\u5904\u7406\u540e\u518d\u5220\u9664\uff01");
        }
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        if (param.getParams().containsKey("partDocId")) {
            Object obj = ((Parameter)param.getParams().get("partDocId")).getValue();
            Long partDocId = Long.parseLong((String)obj);
            param.getParams().put("partDocId", new Parameter("eq", (Object)partDocId));
        } else {
            param.getParams().put("partDocId", new Parameter("eq", (Object)999));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("name", "asc");
        param.getOrderMap().put("partDocId", "asc");
        List list = this.service.queryList(param, false);
        List resultMapList = BeanMapper.mapList((Iterable)list, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @GetMapping(value={"/queryPartTree"})
    @ResponseBody
    public List<Map<String, Object>> queryPartTree(@RequestParam String relyCondition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        if (StringUtils.isNotEmpty((CharSequence)relyCondition)) {
            String[] split = relyCondition.split("=");
            param.getParams().put("partDocId", new Parameter("eq", (Object)split[1]));
        } else {
            param.getParams().put("partDocId", new Parameter("eq", (Object)"999"));
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("name", "asc");
        param.getOrderMap().put("partDocId", "asc");
        List list = this.service.queryList(param, false);
        ArrayList resultMapList = new ArrayList();
        for (PartDocDetailEntity entity : list) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getName());
            map.put("code", entity.getCode());
            map.put("parentId", entity.getParentId());
            map.put("innerCode", entity.getInnerCode());
            resultMapList.add(map);
        }
        List result = ResultAsTree.createTreeData(resultMapList);
        return result;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PartDocDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response, Long partDocId) {
        return this.service.excelImport(request, response, partDocId);
    }

    @RequestMapping(value={"/saveImportExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<PartDocDetailVO> importVOS) {
        return CommonResponse.success((String)((String)this.service.saveImportExcel(request, importVOS)));
    }

    @RequestMapping(value={"/refPartDocDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PartDocDetailVO>> refPartDocDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PartDocDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

