package com.ejianc.foundation.share.service.impl;

import com.ejianc.foundation.share.bean.ItemDocApplyDetailEntity;
import com.ejianc.foundation.share.bean.ItemDocApplyEntity;
import com.ejianc.foundation.share.bean.LabsubItemEntity;
import com.ejianc.foundation.share.bean.ProsubItemEntity;
import com.ejianc.foundation.share.service.IItemDocApplyService;
import com.ejianc.foundation.share.service.ILabsubItemService;
import com.ejianc.foundation.share.service.IProsubItemService;
import com.ejianc.foundation.share.vo.ItemDocApplyVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("itemDocApply") 
public class ItemDocApplyBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IItemDocApplyService service;

	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IProsubItemService prosubItemService;

	@Autowired
	private ILabsubItemService labsubItemService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		ItemDocApplyEntity entity = service.selectById(billId);
		UserContext user = sessionManager.getUserContext();
		entity.setCommitDate(new Date());
		entity.setCommitUserCode(user.getUserCode());
		entity.setCommitUserName(user.getUserName());

		service.saveOrUpdate(entity, false);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		ItemDocApplyEntity entity = service.selectById(billId);
		if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(entity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(entity.getBillState())) {
			return CommonResponse.error("不支持该操作");
		}
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ItemDocApplyEntity entity = service.selectById(billId);

		if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
			UserContext user = sessionManager.getUserContext();
			entity.setCommitDate(new Date());
			entity.setCommitUserCode(user.getUserCode());
			entity.setCommitUserName(user.getUserName());
		}

		//推送档案库
		if(ItemDocApplyVO.APPLY_ITEM_TYPE_LABSUB.equals(entity.getApplyItemType())) {
			List<LabsubItemEntity> saveEntities = transferLabsubList(entity.getDetailList());
			labsubItemService.saveOrUpdateBatch(saveEntities, saveEntities.size(), false);
		} else {
			List<ProsubItemEntity> saveEntities = transferProsubList(entity.getDetailList());
			prosubItemService.saveOrUpdateBatch(saveEntities, saveEntities.size(), false);
		}

		entity.setEffectiveDate(new Date());
		service.saveOrUpdate(entity, false);
		return CommonResponse.success();
	}

	private List<ProsubItemEntity> transferProsubList(List<ItemDocApplyDetailEntity> detailList) {
		List<ProsubItemEntity> saveList = new ArrayList<>();
		ProsubItemEntity tmp = null;
		for(ItemDocApplyDetailEntity item : detailList) {
			tmp = new ProsubItemEntity();
			tmp.setTrawlingName(item.getItemName());
			tmp.setTrawlingCode(item.getItemCode());
			tmp.setCategoryId(item.getCategoryId());
			tmp.setCategoryName(item.getCategoryName());
			tmp.setJobContent(item.getJobContent());
			tmp.setPriceType(item.getPriceType());
			tmp.setDetailMeasurementRules(item.getSpec());
			tmp.setUnitName(item.getUnitName());
			tmp.setEnabled(0);
			tmp.setCreateUserCode(InvocationInfoProxy.getUsercode());
			tmp.setCreateTime(new Date());
			tmp.setTenantId(InvocationInfoProxy.getTenantid());

			tmp.setSubjectIds(item.getExtField1());
			tmp.setSubjectNames(item.getExtField2());
			tmp.setSubjectRelations(item.getExtField3());

			saveList.add(tmp);
		}
		return saveList;
	}

	private List<LabsubItemEntity> transferLabsubList(List<ItemDocApplyDetailEntity> detailList) {
		List<LabsubItemEntity> saveList = new ArrayList<>();
		LabsubItemEntity tmp = null;
		for(ItemDocApplyDetailEntity item : detailList) {
			tmp = new LabsubItemEntity();
			tmp.setTrawlingName(item.getItemName());
			tmp.setTrawlingCode(item.getItemCode());
			tmp.setCategoryId(item.getCategoryId());
			tmp.setCategoryName(item.getCategoryName());
			tmp.setJobContent(item.getJobContent());
			tmp.setPriceType(item.getPriceType());
			tmp.setDetailMeasurementRules(item.getSpec());
			tmp.setUnitName(item.getUnitName());
			tmp.setEnabled(0);
			tmp.setCreateUserCode(InvocationInfoProxy.getUsercode());
			tmp.setCreateTime(new Date());
			tmp.setTenantId(InvocationInfoProxy.getTenantid());

			tmp.setSubjectIds(item.getExtField1());
			tmp.setSubjectNames(item.getExtField2());
			tmp.setSubjectRelations(item.getExtField3());

			saveList.add(tmp);
		}

		return saveList;
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ItemDocApplyEntity entity = service.selectById(billId);
		if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(entity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(entity.getBillState())) {
			return CommonResponse.error("不支持该操作");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
