package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.ProjectWbsTemplateEntity;
import com.ejianc.foundation.share.service.IProjectWbsTemplateService;
import com.ejianc.foundation.share.vo.ProjectWbsTemplateVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 项目WBS模板主表
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("projectWbsTemplate")
public class ProjectWbsTemplateController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IProjectWbsTemplateService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectWbsTemplateVO> saveOrUpdate(@RequestBody ProjectWbsTemplateVO saveOrUpdateVO) {
        ProjectWbsTemplateVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！", service.queryDetail(vo.getId(), true));
    }


    @PostMapping(value = "/updateEnabled")
    @ResponseBody
    public CommonResponse<String> updateEnabled(@RequestBody ProjectWbsTemplateVO saveOrUpdateVO) {
        ProjectWbsTemplateEntity entity = service.selectById(saveOrUpdateVO.getId());
        entity.setEnabled(saveOrUpdateVO.getEnabled());
        service.saveOrUpdate(entity, false);
        return CommonResponse.success("操作成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectWbsTemplateVO> queryDetail(Long id) {
        ProjectWbsTemplateVO vo = service.queryDetail(id, true);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectWbsTemplateVO> vos) {
        service.removeByIds(vos.stream().map(ProjectWbsTemplateVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectWbsTemplateVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billName");
        fuzzyFields.add("projectTypeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<ProjectWbsTemplateEntity> page = service.queryPage(param,false);
        IPage<ProjectWbsTemplateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectWbsTemplateVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billName");
        fuzzyFields.add("projectTypeName");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<ProjectWbsTemplateEntity> list = service.queryList(param);
        List<ProjectWbsTemplateVO> vos = BeanMapper.mapList(list, ProjectWbsTemplateVO.class);
        vos.stream().forEach(v -> {
            v.setBillStateStr(BillStateEnum.getEnumByStateCode(v.getBillState()).getDescription());
        });
        Map<String, Object> beans = new HashMap<>();

        beans.put("records", vos);
        ExcelExport.getInstance().export("ProjectWbsTemplate-export.xlsx", beans, response);
    }

    /**
     * @description: ProjectWbsTemplateController
     * @author: 39630
     * @create: 2025/8/20 14:56
     * @Version 1.0
     **/
    @RequestMapping(value = "/refProjectWbsTemplateData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectWbsTemplateVO>> refProjectWbsTemplateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("billName");
        param.getFuzzyFields().add("projectTypeName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", Parameter.getInInstance(Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode())));

        if(StringUtils.isNotEmpty(condition)){
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProjectWbsTemplateEntity> page = service.queryPage(param,false);
        IPage<ProjectWbsTemplateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectWbsTemplateVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
