package com.ejianc.foundation.company.controller;

import java.io.Serializable;

import com.ejianc.foundation.company.bean.FillUploadEntity;
import com.ejianc.foundation.company.service.IFillUploadService;
import com.ejianc.foundation.company.vo.LedgerDetailVo;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.company.bean.FillUploadDetailEntity;
import com.ejianc.foundation.company.service.IFillUploadDetailService;
import com.ejianc.foundation.company.vo.FillUploadDetailVO;

/**
 * 资料上传子表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("fillUploadDetail")
public class FillUploadDetailController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IFillUploadDetailService service;
    @Autowired
    private IFillUploadService fillUploadService;

    @Autowired
    private SessionManager sessionManager;
    /*@ApiOperation("商务资料盒台账")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FillUploadDetailVO>> queryList(){
        return null;
    }*/

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FillUploadDetailVO> saveOrUpdate(@RequestBody FillUploadDetailVO saveOrUpdateVO) {
    	FillUploadDetailEntity entity = BeanMapper.map(saveOrUpdateVO, FillUploadDetailEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                /*entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行*/
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	FillUploadDetailVO vo = BeanMapper.map(entity, FillUploadDetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FillUploadDetailVO> queryDetail(Long id) {
    	FillUploadDetailEntity entity = service.selectById(id);
    	FillUploadDetailVO vo = BeanMapper.map(entity, FillUploadDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FillUploadDetailVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (FillUploadDetailVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
            }
        }
        service.removeByIds(vos.stream().map(FillUploadDetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LedgerDetailVo>> queryList(@RequestBody QueryParam param) {
        //1.检查查询得为
        Parameter parameter = param.getParams().get("choseAorB");
        param.getParams().remove("choseAorB");
        if(parameter == null){
            return CommonResponse.error("请选择查询类型！");
        }
        Object value = parameter.getValue();
        if("A".equals(value)){
            //商务资料台账
            List<FillUploadEntity> list = fillUploadService.queryList(param);
            List<Long> ids = list.stream().map(FillUploadEntity::getId).collect(Collectors.toList());
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("fillId",new Parameter(QueryParam.IN, ids));
            IPage<FillUploadDetailEntity> page = service.queryPage(queryParam);
            IPage<LedgerDetailVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            //添加项目名称
            Map<Long,FillUploadEntity > map = new HashMap<>();
            for (FillUploadEntity entity : list) {
                map.put(entity.getId(),entity);
            }
            List<LedgerDetailVo> listData = new ArrayList<>();
            for (FillUploadDetailEntity vo : page.getRecords()) {
                LedgerDetailVo detailVo = BeanMapper.map(vo, LedgerDetailVo.class);
                detailVo.setProjectName(map.get(vo.getFillId()).getProjectName());
                detailVo.setProjectId(map.get(vo.getFillId()).getProjectId());
                listData.add(detailVo);
            }
            pageData.setRecords(listData);
            return CommonResponse.success("查询列表数据成功！",pageData);
        }else if("B".equals(value)){
            //商务资料盒台账
            IPage<FillUploadDetailEntity> page = service.queryPage(param);
            IPage<LedgerDetailVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            //获取主表ID，查询项目名称
            List<FillUploadDetailEntity> records = page.getRecords();
            List<Long> ids = records.stream().map(FillUploadDetailEntity::getFillId).collect(Collectors.toList());
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id",new Parameter(QueryParam.IN, ids));
            List<FillUploadEntity> fillUploadEntities = fillUploadService.queryList(queryParam);
            //添加项目名称
            Map<Long,FillUploadEntity > map = new HashMap<>();
            for (FillUploadEntity entity : fillUploadEntities) {
                map.put(entity.getId(),entity);
            }
            List<LedgerDetailVo> listData = new ArrayList<>();
            for (FillUploadDetailEntity vo : records) {
                LedgerDetailVo detailVo = BeanMapper.map(vo, LedgerDetailVo.class);
                detailVo.setProjectName(map.get(vo.getFillId()).getProjectName());
                detailVo.setProjectId(map.get(vo.getFillId()).getProjectId());
                listData.add(detailVo);
            }
            pageData.setRecords(listData);
            return CommonResponse.success("查询列表数据成功！",pageData);
        }else {
            return CommonResponse.error("请选择查询类型！");
        }
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<FillUploadDetailEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FillUploadDetail-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refFillUploadDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FillUploadDetailVO>> refFillUploadDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<FillUploadDetailEntity> page = service.queryPage(param,false);
        IPage<FillUploadDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FillUploadDetailVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
/** 模糊搜索配置字段示例 */
/*List<String> fuzzyFields = param.getFuzzyFields();
 *//** 租户隔离 *//*
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        *//** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        /*
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            *//** 要求主表有orgId字段，保存单据所属组织 *//*
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            *//** 要求主表有projectDepartmentId字段，保存单据所属项目部 *//*
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }*/
/** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
