package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.share.bean.AdmixTureEntity;
import com.ejianc.foundation.share.mapper.AdmixTureMapper;
import com.ejianc.foundation.share.service.IAdmixTureService;
import com.ejianc.foundation.share.vo.AdmixTureVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 外加剂档案
 * 
 * @author generator
 * 
 */
@Service("admixTureService")
public class AdmixTureServiceImpl extends BaseServiceImpl<AdmixTureMapper, AdmixTureEntity> implements IAdmixTureService{

    @Autowired
    private IAdmixTureService iAdmixTureService;


    @Override
    public CommonResponse<AdmixTureVO> saveOrUpdate(AdmixTureVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        AdmixTureEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            //修改  校验外加剂编号是否重复
            LambdaQueryWrapper<AdmixTureEntity> lambda = Wrappers.<AdmixTureEntity>lambdaQuery();
            lambda.eq(AdmixTureEntity::getAdmixtureCode, saveorUpdateVO.getAdmixtureCode());
            lambda.eq(AdmixTureEntity::getTenantId, tenantId);
            lambda.ne(AdmixTureEntity::getId, saveorUpdateVO.getId());
            List<AdmixTureEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                return CommonResponse.error("存在相同编号，不允许保存!");
            }
            entity = BeanMapper.map(saveorUpdateVO, AdmixTureEntity.class);
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("修改成功！");
        } else {//新增
            //校验合同编号是否重复
            LambdaQueryWrapper<AdmixTureEntity> lambda = Wrappers.<AdmixTureEntity>lambdaQuery();
            lambda.eq(AdmixTureEntity::getTenantId, tenantId);
            lambda.eq(AdmixTureEntity::getAdmixtureCode, saveorUpdateVO.getAdmixtureCode());
            List<AdmixTureEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                return CommonResponse.error("存在相同编号，不允许保存!");
            }
            entity = BeanMapper.map(saveorUpdateVO, AdmixTureEntity.class);
            entity.setId(IdWorker.getId());
            entity.setOrgId(InvocationInfoProxy.getOrgId());
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("保存成功！");
        }
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();
        Map<String,AdmixTureVO> map = new HashMap<>();
        if (isFailed) {
            return CommonResponse.error("文件格式不合法！");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                List<AdmixTureVO> admixTureVOList = new ArrayList<>();
                //查询所有
                QueryParam queryParam = new QueryParam();
                List<String> codeList = new ArrayList<>();
                List<AdmixTureEntity> oldList = queryList(queryParam);

                for(AdmixTureEntity admixTureEntity : oldList){
                    codeList.add(admixTureEntity.getAdmixtureCode());
                }
                for(int i=1;i<result.size();i++) {
                    List<String> datas = result.get(i);
                    AdmixTureVO admixTureVO = new AdmixTureVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    if(StringUtils.isEmpty(datas.get(0))) {
                        admixTureVO.setAdmixtureCode(null);
                        warnType = warnType+"编号为空,";
                        flag = true;
                        parentWarn = true;
                    }else{
                        //编码重复
                        if(codeList.contains(datas.get(0))){
                            admixTureVO.setAdmixtureCode(datas.get(0));
                            warnType = warnType+"编号重复,";
                            flag = true;
                            parentWarn = true;
                        }else{
                            //外加剂编号
                            String admixTureCode = datas.get(0);
                            admixTureVO.setAdmixtureCode(admixTureCode);
                        }
                    }
                    //外加剂名称
                    String admixtureName = datas.get(1);
                    if(StringUtils.isEmpty(admixtureName)){
                        admixTureVO.setAdmixtureName(null);
                        warnType = warnType+"名称为空,";
                        flag = true;
                        parentWarn = true;
                    }else{
                        admixTureVO.setAdmixtureName(admixtureName);
                    }
                    //规格型号
                    String specModels = datas.get(2);
                    if(StringUtils.isEmpty(specModels)){
                        admixTureVO.setSpecModels(null);
                        warnType = warnType+"规格型号为空,";
                        flag = true;
                        parentWarn = true;
                    }else{
                        admixTureVO.setSpecModels(specModels);
                    }
                    //备注
                    String memo = datas.get(3);
                    admixTureVO.setMemo(memo);

                    // true=可以导入，false=不可导入
                    admixTureVO.setImportFlag(!flag);
                    //错误类型
                    admixTureVO.setWarnType(warnType);
                    admixTureVO.setRowState("add");
                    //导入数据默认状态1
                    admixTureVO.setEnabled(0);
                    admixTureVO.setOrgId(InvocationInfoProxy.getOrgId());
                    admixTureVO.setId(IdWorker.getId());
                    admixTureVOList.add(admixTureVO);
                }
                // 处理成功列表和失败列表
                List<AdmixTureVO> successList = new ArrayList<>();
                List<AdmixTureVO> errorList = new ArrayList<>();
                if(CollectionUtils.isNotEmpty(admixTureVOList)){
                    admixTureVOList.forEach(vo ->{
                        if(StringUtils.isEmpty(vo.getWarnType())){
                            successList.add(vo);
                        } else {
                            errorList.add(vo);
                        }
                    });
                }
                resp.put("successList", successList);
                resp.put("errorList", errorList);
                resp.put("successNum", successList.size());
                resp.put("errorNum", errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<AdmixTureVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("导入的数据为空！");
        }
        List<AdmixTureEntity> saveOrUpldates = BeanMapper.mapList(importVOS, AdmixTureEntity.class);
        saveOrUpdateBatch(saveOrUpldates, saveOrUpldates.size(), false);
        return "保存成功！";
    }

}
