package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.*;
import com.ejianc.foundation.share.service.*;
import com.ejianc.foundation.share.vo.*;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.foundation.share.mapper.ItemDocApplyDetailMapper;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 清单档案入库申请-子表
 * 
 * @author generator
 * 
 */
@Service("itemDocApplyDetailService")
public class ItemDocApplyDetailServiceImpl extends BaseServiceImpl<ItemDocApplyDetailMapper, ItemDocApplyDetailEntity> implements IItemDocApplyDetailService{

    @Autowired
    private ILabsubCategoryService labsubCategoryService;

    @Autowired
    private ILabsubItemService labsubItemService;
    @Autowired
    private IProsubCategoryService prosubCategoryService;

    @Autowired
    private IProsubItemService prosubItemService;

    @Autowired
    private IUnitService unitService;




    @Override
    public CommonResponse<JSONObject> excelItemDocImport(HttpServletRequest request) {
        String itemDocType = request.getParameter("itemDocType");
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<ItemDocApplyDetailVO> successList = new ArrayList<>();
        List<ItemDocApplyDetailVO> processList = new ArrayList<>();
        List<ItemDocApplyDetailVO> errorList = new ArrayList<>();
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        }

        List<List<String>> result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error("导入清单超过10000条，请分批上传！");
            }
            Map<String, List<LabsubCategoryEntity>> caListMap = new HashMap<>();
            Map<String, ProsubItemVO> materialMap = new HashMap<>();
            Map<String, ProsubItemVO> materialBeanMap = new HashMap<>();
            List<String> categoryCodes = new ArrayList<>();
            List<String> itemCodes = new ArrayList<>();
            List<String> unitNames = new ArrayList<>();
            for (int i = 0; i < result.size(); i++) {
                List<String> datas = result.get(i);
                ItemDocApplyDetailVO importVo = new ItemDocApplyDetailVO();
                importVo.setId(IdWorker.getId());
                importVo.setCategoryCode(datas.get(0));
                importVo.setItemCode(datas.get(1));
                importVo.setItemName(datas.get(2));
                importVo.setPriceType(datas.get(3));
                importVo.setUnitName(datas.get(4));
                importVo.setJobContent(datas.get(5));
                importVo.setSpec(datas.get(6));
                if (StringUtils.isBlank(datas.get(0))) {
                    importVo.setErrMsg("【所属分类编码】为空！");
                    errorList.add(importVo);
                    continue;
                }
                if(!categoryCodes.contains(datas.get(0))) {
                    categoryCodes.add(datas.get(0));
                }
                if(StringUtils.isBlank(importVo.getItemCode())) {
                    importVo.setErrMsg("【清单编码】为空！");
                    errorList.add(importVo);
                    continue;
                }
                if (StringUtils.isNotBlank(datas.get(1))) {
                    if(itemCodes.contains(datas.get(1))) {
                        importVo.setErrMsg("【清单编码】重复！");
                        errorList.add(importVo);
                        continue;
                    }
                    itemCodes.add(datas.get(1));
                }
                if (StringUtils.isBlank(datas.get(2))) {
                    importVo.setErrMsg("【清单名称】为空！");
                    errorList.add(importVo);
                    continue;
                }
                if (StringUtils.isBlank(importVo.getJobContent())) {
                    importVo.setErrMsg("【计量规则】为空！");
                    errorList.add(importVo);
                    continue;
                }
                if (StringUtils.isBlank(importVo.getSpec())) {
                    importVo.setErrMsg("【规格型号/项目特征】为空！");
                    errorList.add(importVo);
                    continue;
                }
                if (!"固定单价".equals(importVo.getPriceType()) && !"固定总价".equals((importVo.getPriceType()))) {
                    importVo.setErrMsg("【价格类型】值错误！");
                    errorList.add(importVo);
                    continue;
                }

                if(StringUtils.isNotBlank(importVo.getUnitName()) && !unitNames.contains(importVo.getUnitName())) {
                    unitNames.add(importVo.getUnitName());
                }

                importVo.setDetailType(itemDocType);
                processList.add(importVo);
            }

            if(CollectionUtils.isNotEmpty(processList)) {
                //分类信息验证
                if(ItemDocApplyVO.APPLY_ITEM_TYPE_LABSUB.equals(itemDocType)) {
                    checkLabSubCategory(unitNames, itemCodes, categoryCodes, processList, successList, errorList);
                } else {
                    checkProSubCategory(unitNames, itemCodes, categoryCodes, processList, successList, errorList);
                }
            }
        }

        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success(json);
    }

    @Override
    public String validateLabSubItem(List<ItemDocApplyDetailEntity> detailList) {
        List<String> codeList = new ArrayList<>();
        for(ItemDocApplyDetailEntity detail : detailList) {
            if("del".equals(detail.getRowState())) {
                continue;
            }
            if(codeList.contains(detail.getItemCode())) {
                return "操作失败，清单编码【"+detail.getItemCode()+"】重复";
            }
            codeList.add(detail.getItemCode());

            //查询档案库
            QueryWrapper<LabsubItemEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("trawling_name", detail.getItemName());
            if(StringUtils.isNotBlank(detail.getPriceType())) {
                queryWrapper.eq("price_type",detail.getPriceType());
            }
            queryWrapper.eq("unit_name",detail.getUnitName());
            if(StringUtils.isBlank(detail.getJobContent())) {
                queryWrapper.isNull("job_content");
            } else {
                queryWrapper.eq("job_content",detail.getJobContent());
            }
            if(StringUtils.isBlank(detail.getSpec())) {
                queryWrapper.isNull("detail_measurement_rules");
            } else {
                queryWrapper.eq("detail_measurement_rules",detail.getSpec());
            }

            queryWrapper.eq("category_id", detail.getCategoryId());
            List<LabsubItemEntity> list = labsubItemService.list(queryWrapper);
            if(CollectionUtils.isNotEmpty(list)) {
                return "清单-名称：【"+detail.getItemName()+"】，编码：【"+detail.getItemCode()+"】，规格型号/项目特征【"+detail.getSpec()+"】已入库，请勿重复申请！";
            }

            //查询入库申请记录
            QueryWrapper<ItemDocApplyDetailEntity> applyQueryWrapper = new QueryWrapper<>();
            applyQueryWrapper.eq("item_name", detail.getItemName());
            if(StringUtils.isNotBlank(detail.getPriceType())) {
                applyQueryWrapper.eq("price_type",detail.getPriceType());
            }
            applyQueryWrapper.eq("unit_name",detail.getUnitName());
            if(StringUtils.isBlank(detail.getJobContent())) {
                applyQueryWrapper.isNull("job_content");
            } else {
                applyQueryWrapper.eq("job_content",detail.getJobContent());
            }
            if(StringUtils.isBlank(detail.getSpec())) {
                applyQueryWrapper.isNull("spec");
            } else {
                applyQueryWrapper.eq("spec",detail.getSpec());
            }
            applyQueryWrapper.eq("category_id", detail.getCategoryId());
            applyQueryWrapper.eq("detail_type", ItemDocApplyVO.APPLY_ITEM_TYPE_LABSUB);

            List<ItemDocApplyDetailEntity> dbList= super.list(applyQueryWrapper);
            if(CollectionUtils.isNotEmpty(dbList)) {
                return "清单-名称：【"+detail.getItemName()+"】，编码：【"+detail.getItemCode()+"】，规格型号/项目特征【"+detail.getSpec()+"】已存在入库记录，请勿重复申请！";
            }
        }

        //根据编码查询已在库档案 和 准入申请记录
        Set<String> existsCodes = new HashSet<>();
        if(CollectionUtils.isNotEmpty(codeList)) {
            List<LabsubItemVO> labsubItems =  labsubItemService.queryAllByCodes(codeList);
            if(CollectionUtils.isNotEmpty(labsubItems)) {
                existsCodes.addAll(labsubItems.stream().map(LabsubItemVO::getTrawlingCode).distinct().collect(Collectors.toList()));
            }

            List<ItemDocApplyDetailVO> applyVos = this.queryAllByCodeAndType(codeList, ItemDocApplyVO.APPLY_ITEM_TYPE_LABSUB);
            if(CollectionUtils.isNotEmpty(applyVos)) {
                existsCodes.addAll(applyVos.stream().map(ItemDocApplyDetailVO::getItemCode).distinct().collect(Collectors.toList()));
            }
        }

//        if(CollectionUtils.isNotEmpty(existsCodes)) {
//            return "操作失败，编码【"+StringUtils.join(existsCodes, ",")+"】重复!";
//        }

        return null;
    }

    @Override
    public void generateCodeBatch(List<ItemDocApplyDetailEntity> empCodeList) {
        Map<Long, ItemDocApplyDetailEntity> eMap = new HashMap<>();
        for(ItemDocApplyDetailEntity e : empCodeList) {
            if(null == e.getId()) {
                e.setId(IdWorker.getId());
            }
            eMap.put(e.getId(), e);
        }
        List<ItemDocApplyDetailVO> vos = BeanMapper.mapList(empCodeList, ItemDocApplyDetailVO.class);
        labsubItemService.generateCodeBatch(vos);
        for(ItemDocApplyDetailVO v : vos) {
            eMap.get(v.getId()).setItemCode(v.getItemCode());
        }
    }

    private void checkProSubCategory(List<String> unitNames, List<String> itemCodes, List<String> categoryCode, List<ItemDocApplyDetailVO> processList,
                                     List<ItemDocApplyDetailVO> sucList, List<ItemDocApplyDetailVO> errList) {
        //待生成编码列表
        List<ItemDocApplyDetailVO> empCodeList = new ArrayList<>();

        //清单重复验证列表
        List<String> itemBeanMap = new ArrayList<>();

//        Map<String, UnitVO> unitMap = new HashMap<>();
//        if(CollectionUtils.isNotEmpty(unitNames)) {
//            List<UnitVO> unitVOS = unitService.getAllByNames(unitNames);
//            unitMap.putAll(unitVOS.stream().collect(Collectors.toMap(UnitVO::getUnitName, Function.identity(), (v1,v2) -> v1)));
//        }

        //查询劳务清单分类
        List<ProsubCategoryVO> categoryVOS = prosubCategoryService.queryAllByCodes(categoryCode);
        Map<String, ProsubCategoryVO> categoryVOMap = categoryVOS.stream().collect(Collectors.toMap(ProsubCategoryVO::getCategoryCode, Function.identity()));

        //根据编码查询已在库档案 和 准入申请记录
        List<String> existsCodes = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(itemCodes)) {
            List<ProsubItemVO> labsubItems =  prosubItemService.queryAllByCodes(itemCodes);
            if(CollectionUtils.isNotEmpty(labsubItems)) {
                existsCodes.addAll(labsubItems.stream().map(ProsubItemVO::getTrawlingCode).collect(Collectors.toList()));
            }

            List<ItemDocApplyDetailVO> applyVos = this.queryAllByCodeAndType(itemCodes, ItemDocApplyVO.APPLY_ITEM_TYPE_LABSUB);
            if(CollectionUtils.isNotEmpty(applyVos)) {
                existsCodes.addAll(applyVos.stream().map(ItemDocApplyDetailVO::getItemCode).collect(Collectors.toList()));
            }
        }

        ProsubCategoryVO materialCategoryVo = null;
        for(ItemDocApplyDetailVO importVo : processList) {
            //通过档案分类Code获取档案分类ID
            materialCategoryVo = categoryVOMap.get(importVo.getCategoryCode());
            if(null == materialCategoryVo) {
                importVo.setErrMsg("档案分类编号不存在！");
                errList.add(importVo);
                continue;
            }
//            if(StringUtils.isNotBlank(importVo.getUnitName()) && unitMap.containsKey(importVo.getUnitName())) {
//                importVo.setUnitId(unitMap.get(importVo.getUnitName()).getId());
//            }


            //设置分类及成本科目信息
            importVo.setCategoryId(materialCategoryVo.getId());
            importVo.setCategoryName(materialCategoryVo.getCategoryName());
            importVo.setExtField1(materialCategoryVo.getSubjectIds());
            importVo.setExtField2(materialCategoryVo.getSubjectNames());
            importVo.setExtField3(materialCategoryVo.getSubjectRelations());

            if(StringUtils.isNotBlank(importVo.getItemCode())) {
                if(existsCodes.contains(importVo.getItemCode())) {
                    importVo.setErrMsg("档案编码重复！");
                    errList.add(importVo);
                    continue;
                }
            } else {
                empCodeList.add(importVo);
            }

            //查询是否存在重复物料
            if(itemBeanMap.contains(importVo.getItemName()
                    + importVo.getPriceType()
                    + importVo.getUnitName() + importVo.getCategoryId()
                    + (StringUtils.isNotBlank(importVo.getJobContent()) ? importVo.getJobContent() : "")
                    + (StringUtils.isNotBlank(importVo.getSpec()) ? importVo.getSpec() : ""))) {
                importVo.setErrMsg("该清单已入库或已存在入库申请记录！");
                errList.add(importVo);
                continue;
            }
            //查询档案库
            QueryWrapper<ProsubItemEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("trawling_name", importVo.getItemName());
            if(StringUtils.isNotBlank(importVo.getPriceType())) {
                queryWrapper.eq("price_type",importVo.getPriceType());
            }
            queryWrapper.eq("unit_name",importVo.getUnitName());
            if(StringUtils.isBlank(importVo.getJobContent())) {
                queryWrapper.isNull("job_content");
            } else {
                queryWrapper.eq("job_content",importVo.getJobContent());
            }
            if(StringUtils.isBlank(importVo.getSpec())) {
                queryWrapper.isNull("detail_measurement_rules");
            } else {
                queryWrapper.eq("detail_measurement_rules",importVo.getSpec());
            }

            queryWrapper.eq("category_id", importVo.getCategoryId());
            List<ProsubItemEntity> list = prosubItemService.list(queryWrapper);
            if(CollectionUtils.isNotEmpty(list)) {
                importVo.setErrMsg("该清单已入库！");
                errList.add(importVo);
                continue;
            }
            //查询入库申请记录
            QueryWrapper<ItemDocApplyDetailEntity> applyQueryWrapper = new QueryWrapper<>();
            applyQueryWrapper.eq("item_name", importVo.getItemName());
            if(StringUtils.isNotBlank(importVo.getPriceType())) {
                applyQueryWrapper.eq("price_type",importVo.getPriceType());
            }
            applyQueryWrapper.eq("unit_name",importVo.getUnitName());
            if(StringUtils.isBlank(importVo.getJobContent())) {
                applyQueryWrapper.isNull("job_content");
            } else {
                applyQueryWrapper.eq("job_content",importVo.getJobContent());
            }
            if(StringUtils.isBlank(importVo.getSpec())) {
                applyQueryWrapper.isNull("spec");
            } else {
                applyQueryWrapper.eq("spec",importVo.getSpec());
            }
            applyQueryWrapper.eq("category_id", importVo.getCategoryId());
            applyQueryWrapper.eq("detail_type", ItemDocApplyVO.APPLY_ITEM_TYPE_PROSUB);

            List<ItemDocApplyDetailEntity> dbList= super.list(applyQueryWrapper);
            if(CollectionUtils.isNotEmpty(dbList)) {
                importVo.setErrMsg("该清单已存在入库申请记录！");
                errList.add(importVo);
                continue;
            }

            itemBeanMap.add(importVo.getItemName()
                    + importVo.getPriceType()
                    + importVo.getUnitName() + importVo.getCategoryId()
                    + (StringUtils.isNotBlank(importVo.getJobContent()) ? importVo.getJobContent() : "")
                    + (StringUtils.isNotBlank(importVo.getSpec()) ? importVo.getSpec() : ""));

            sucList.add(importVo);
        }

        //编码生成
//        if(CollectionUtils.isNotEmpty(empCodeList)) {
//            labsubItemService.generateCodeBatch(empCodeList);
//        }
    }

    private void checkLabSubCategory(List<String> unitNames, List<String> itemCodes, List<String> categoryCode, List<ItemDocApplyDetailVO> processList, List<ItemDocApplyDetailVO> sucList, List<ItemDocApplyDetailVO> errList) {
        //待生成编码列表
        List<ItemDocApplyDetailVO> empCodeList = new ArrayList<>();

        //清单重复验证列表
        List<String> itemBeanMap = new ArrayList<>();

//        Map<String, UnitVO> unitMap = new HashMap<>();
//        if(CollectionUtils.isNotEmpty(unitNames)) {
//            List<UnitVO> unitVOS = unitService.getAllByNames(unitNames);
//            unitMap.putAll(unitVOS.stream().collect(Collectors.toMap(UnitVO::getUnitName, Function.identity(), (v1,v2) -> v1)));
//        }

        //查询劳务清单分类
        List<LabsubCategoryVO> categoryVOS = labsubCategoryService.queryAllByCodes(categoryCode);
        Map<String, LabsubCategoryVO> categoryVOMap = categoryVOS.stream().collect(Collectors.toMap(LabsubCategoryVO::getCategoryCode, Function.identity()));

        //根据编码查询已在库档案 和 准入申请记录
        List<String> existsCodes = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(itemCodes)) {
            List<LabsubItemVO> labsubItems =  labsubItemService.queryAllByCodes(itemCodes);
            if(CollectionUtils.isNotEmpty(labsubItems)) {
                existsCodes.addAll(labsubItems.stream().map(LabsubItemVO::getTrawlingCode).collect(Collectors.toList()));
            }

            List<ItemDocApplyDetailVO> applyVos = this.queryAllByCodeAndType(itemCodes, ItemDocApplyVO.APPLY_ITEM_TYPE_LABSUB);
            if(CollectionUtils.isNotEmpty(applyVos)) {
                existsCodes.addAll(applyVos.stream().map(ItemDocApplyDetailVO::getItemCode).collect(Collectors.toList()));
            }
        }

        LabsubCategoryVO materialCategoryVo = null;
        for(ItemDocApplyDetailVO importVo : processList) {
            //通过档案分类Code获取档案分类ID
            materialCategoryVo = categoryVOMap.get(importVo.getCategoryCode());
            if(null == materialCategoryVo) {
                importVo.setErrMsg("档案分类编号不存在！");
                errList.add(importVo);
                continue;
            }

//            if(StringUtils.isNotBlank(importVo.getUnitName()) && unitMap.containsKey(importVo.getUnitName())) {
//                importVo.setUnitId(unitMap.get(importVo.getUnitName()).getId());
//            }

            //设置分类及成本科目信息
            importVo.setCategoryId(materialCategoryVo.getId());
            importVo.setCategoryName(materialCategoryVo.getCategoryName());
            importVo.setExtField1(materialCategoryVo.getSubjectIds());
            importVo.setExtField2(materialCategoryVo.getSubjectNames());
            importVo.setExtField3(materialCategoryVo.getSubjectRelations());

            if(StringUtils.isNotBlank(importVo.getItemCode())) {
                if(existsCodes.contains(importVo.getItemCode())) {
                    importVo.setErrMsg("档案编码重复！");
                    errList.add(importVo);
                    continue;
                }
            } else {
                empCodeList.add(importVo);
            }

            //查询是否存在重复物料
            if(itemBeanMap.contains(importVo.getItemName()
                    + importVo.getPriceType()
                    + importVo.getUnitName() + importVo.getCategoryId()
                    + (StringUtils.isNotBlank(importVo.getJobContent()) ? importVo.getJobContent() : "")
                    + (StringUtils.isNotBlank(importVo.getSpec()) ? importVo.getSpec() : ""))) {
                importVo.setErrMsg("该清单已入库或已存在入库申请记录！");
                errList.add(importVo);
                continue;
            }
            //查询档案库
            QueryWrapper<LabsubItemEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("trawling_name", importVo.getItemName());
            if(StringUtils.isNotBlank(importVo.getPriceType())) {
                queryWrapper.eq("price_type",importVo.getPriceType());
            }
            queryWrapper.eq("unit_name",importVo.getUnitName());
            if(StringUtils.isBlank(importVo.getJobContent())) {
                queryWrapper.isNull("job_content");
            } else {
                queryWrapper.eq("job_content",importVo.getJobContent());
            }
            if(StringUtils.isBlank(importVo.getSpec())) {
                queryWrapper.isNull("detail_measurement_rules");
            } else {
                queryWrapper.eq("detail_measurement_rules",importVo.getSpec());
            }

            queryWrapper.eq("category_id", importVo.getCategoryId());
            LabsubItemEntity one = null;
            List<LabsubItemEntity> list = labsubItemService.list(queryWrapper);
            if(CollectionUtils.isNotEmpty(list)) {
                importVo.setErrMsg("该清单已入库！");
                errList.add(importVo);
                continue;
            }
            //查询入库申请记录
            QueryWrapper<ItemDocApplyDetailEntity> applyQueryWrapper = new QueryWrapper<>();
            applyQueryWrapper.eq("item_name", importVo.getItemName());
            if(StringUtils.isNotBlank(importVo.getPriceType())) {
                applyQueryWrapper.eq("price_type",importVo.getPriceType());
            }
            applyQueryWrapper.eq("unit_name",importVo.getUnitName());
            if(StringUtils.isBlank(importVo.getJobContent())) {
                applyQueryWrapper.isNull("job_content");
            } else {
                applyQueryWrapper.eq("job_content",importVo.getJobContent());
            }
            if(StringUtils.isBlank(importVo.getSpec())) {
                applyQueryWrapper.isNull("spec");
            } else {
                applyQueryWrapper.eq("spec",importVo.getSpec());
            }
            applyQueryWrapper.eq("category_id", importVo.getCategoryId());
            applyQueryWrapper.eq("detail_type", ItemDocApplyVO.APPLY_ITEM_TYPE_LABSUB);

            List<ItemDocApplyDetailEntity> dbList= super.list(applyQueryWrapper);
            if(CollectionUtils.isNotEmpty(dbList)) {
                importVo.setErrMsg("该清单已存在入库申请记录！");
                errList.add(importVo);
                continue;
            }

            itemBeanMap.add(importVo.getItemName()
                    + importVo.getPriceType()
                    + importVo.getUnitName() + importVo.getCategoryId()
                    + (StringUtils.isNotBlank(importVo.getJobContent()) ? importVo.getJobContent() : "")
                    + (StringUtils.isNotBlank(importVo.getSpec()) ? importVo.getSpec() : ""));

            sucList.add(importVo);
        }

        //编码生成
//        if(CollectionUtils.isNotEmpty(empCodeList)) {
//            labsubItemService.generateCodeBatch(empCodeList);
//        }
    }

    private List<ItemDocApplyDetailVO> queryAllByCodeAndType(List<String> itemCodes, String itemType) {
        List<ItemDocApplyDetailVO> resp = new ArrayList<>();

        QueryWrapper<ItemDocApplyDetailEntity> query = new QueryWrapper<>();
        query.in("item_code", itemCodes);
        query.in("detail_type", itemType);
        List<ItemDocApplyDetailEntity> dbList = super.list(query);
        if(CollectionUtils.isNotEmpty(dbList)) {
            return BeanMapper.mapList(dbList, ItemDocApplyDetailVO.class);
        }

        return resp;
    }


    @Override
    public String validateProSubItem(List<ItemDocApplyDetailEntity> detailList) {
        List<String> codeList = new ArrayList<>();
        for(ItemDocApplyDetailEntity detail : detailList) {
            if(codeList.contains(detail.getItemCode())) {
                return "操作失败，编码【"+detail.getItemCode()+"】重复";
            }
            codeList.add(detail.getItemCode());

            //查询档案库
            QueryWrapper<ProsubItemEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("trawling_name", detail.getItemName());
            if(StringUtils.isNotBlank(detail.getPriceType())) {
                queryWrapper.eq("price_type",detail.getPriceType());
            }
            queryWrapper.eq("unit_name",detail.getUnitName());
            if(StringUtils.isBlank(detail.getJobContent())) {
                queryWrapper.isNull("job_content");
            } else {
                queryWrapper.eq("job_content",detail.getJobContent());
            }
            if(StringUtils.isBlank(detail.getSpec())) {
                queryWrapper.isNull("detail_measurement_rules");
            } else {
                queryWrapper.eq("detail_measurement_rules",detail.getSpec());
            }

            queryWrapper.eq("category_id", detail.getCategoryId());
            List<ProsubItemEntity> list = prosubItemService.list(queryWrapper);
            if(CollectionUtils.isNotEmpty(list)) {
                return "清单-名称：【"+detail.getItemName()+"】，编码：【"+detail.getItemCode()+"】，规格型号/项目特征【"+detail.getSpec()+"】已入库，请勿重复申请！";
            }

            //查询入库申请记录
            QueryWrapper<ItemDocApplyDetailEntity> applyQueryWrapper = new QueryWrapper<>();
            applyQueryWrapper.eq("item_name", detail.getItemName());
            if(StringUtils.isNotBlank(detail.getPriceType())) {
                applyQueryWrapper.eq("price_type",detail.getPriceType());
            }
            applyQueryWrapper.eq("unit_name",detail.getUnitName());
            if(StringUtils.isBlank(detail.getJobContent())) {
                applyQueryWrapper.isNull("job_content");
            } else {
                applyQueryWrapper.eq("job_content",detail.getJobContent());
            }
            if(StringUtils.isBlank(detail.getSpec())) {
                applyQueryWrapper.isNull("spec");
            } else {
                applyQueryWrapper.eq("spec",detail.getSpec());
            }
            applyQueryWrapper.eq("category_id", detail.getCategoryId());
            applyQueryWrapper.eq("detail_type", ItemDocApplyVO.APPLY_ITEM_TYPE_PROSUB);

            List<ItemDocApplyDetailEntity> dbList= super.list(applyQueryWrapper);
            if(CollectionUtils.isNotEmpty(dbList)) {
                return "清单-名称：【"+detail.getItemName()+"】，编码：【"+detail.getItemCode()+"】，规格型号/项目特征【"+detail.getSpec()+"】已存在入库记录，请勿重复申请！";
            }
        }

        //根据编码查询已在库档案 和 准入申请记录
        Set<String> existsCodes = new HashSet<>();
        if(CollectionUtils.isNotEmpty(codeList)) {
            List<ProsubItemVO> labsubItems =  prosubItemService.queryAllByCodes(codeList);
            if(CollectionUtils.isNotEmpty(labsubItems)) {
                existsCodes.addAll(labsubItems.stream().map(ProsubItemVO::getTrawlingCode).distinct().collect(Collectors.toList()));
            }

            List<ItemDocApplyDetailVO> applyVos = this.queryAllByCodeAndType(codeList, ItemDocApplyVO.APPLY_ITEM_TYPE_LABSUB);
            if(CollectionUtils.isNotEmpty(applyVos)) {
                existsCodes.addAll(applyVos.stream().map(ItemDocApplyDetailVO::getItemCode).distinct().collect(Collectors.toList()));
            }
        }

        if(CollectionUtils.isNotEmpty(existsCodes)) {
            return "操作失败，编码【"+StringUtils.join(existsCodes, ",")+"】重复!";
        }

        return null;
    }

}
