package com.ejianc.foundation.share.service.impl;

import com.ejianc.foundation.share.bean.ProjectWbsTemplateDetailEntity;
import com.ejianc.foundation.share.bean.ProjectWbsTemplateEntity;
import com.ejianc.foundation.share.mapper.ProjectWbsTemplateMapper;
import com.ejianc.foundation.share.service.IProjectWbsTemplateDetailService;
import com.ejianc.foundation.share.service.IProjectWbsTemplateService;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.vo.ProjectWbsTemplateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 项目WBS模板主表
 * 
 * @author generator
 * 
 */
@Service("projectWbsTemplateService")
public class ProjectWbsTemplateServiceImpl extends BaseServiceImpl<ProjectWbsTemplateMapper, ProjectWbsTemplateEntity> implements IProjectWbsTemplateService{

    private static final String BILL_CODE = "PROJECT_WBS_TMPL";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IProjectWbsTemplateDetailService detailService;

    @Override
    public ProjectWbsTemplateVO saveOrUpdate(ProjectWbsTemplateVO saveOrUpdateVO) {
        ProjectWbsTemplateEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectWbsTemplateEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            entity.setEnabled("1"); //默认启用
        }

        super.saveOrUpdate(entity, false);

        List<ProjectWbsTemplateDetailEntity> detailList = entity.getDetailList();
        if(CollectionUtils.isNotEmpty(detailList)) {
            //明细编码对应主键
            Map<String, Long> map = new HashMap<>();
            for (ProjectWbsTemplateDetailEntity detail : detailList) {
                map.put(detail.getShadowId(), detail.getId());
            }

            //设置子节点parentId
            for (ProjectWbsTemplateDetailEntity detail : detailList) {
                detail.setParentId(map.get(detail.getTpid()));
            }

            // 生成内码
            List<Map> resultMapList = BeanMapper.mapList(detailList, Map.class);
            List<Map<String, Object>> treeData = ResultAsTree.createTreeData(resultMapList);
            List<Map<String, Object>> ListCodeDate = creatCode(treeData, null);
            List<ProjectWbsTemplateDetailEntity> entities = new ArrayList<>();
            treeToList(ListCodeDate, entities);
            detailService.saveOrUpdateBatch(entities);
        }

        return BeanMapper.map(entity, ProjectWbsTemplateVO.class);
    }

    @Override
    public ProjectWbsTemplateVO queryDetail(Long id,boolean hasChildren) {
        ProjectWbsTemplateEntity entity = selectById(id);

        ProjectWbsTemplateVO resp = BeanMapper.map(entity, ProjectWbsTemplateVO.class);

        //实现排序
        Collections.sort(resp.getDetailList(), (o1, o2) -> {
            String[] parts1 = o1.getTreeIndex().split("\\.");
            String[] parts2 = o2.getTreeIndex().split("\\.");

            int minLength = Math.min(parts1.length, parts2.length);
            for (int i = 0; i < minLength; i++) {
                int part1 = Integer.parseInt(parts1[i]);
                int part2 = Integer.parseInt(parts2[i]);

                if (part1 < part2) {
                    return -1;
                } else if (part1 > part2) {
                    return 1;
                }
            }
            // 如果前面的部分都相等，比较版本号长度
            return Integer.compare(parts1.length, parts2.length);
        });

        if(hasChildren){
            resp.setDetailList(TreeNodeBUtil.buildTree(resp.getDetailList()));
        }

        return resp;
    }

    private void treeToList(List<Map<String, Object>> list, List<ProjectWbsTemplateDetailEntity> entities){
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                treeToList((List) ypd.get("children"), entities);
            }
            entities.add(BeanMapper.map(ypd, ProjectWbsTemplateDetailEntity.class));
        }
    }

    private List<Map<String, Object>> creatCode(List<Map<String, Object>> list, String innerCode) {
        for (Map<String, Object> ypd : list) {
            // 生成内码
            if (StringUtils.isNotEmpty(innerCode)) {
                ypd.put("innerCode", innerCode + "|" + ypd.get("id"));
            } else {
                ypd.put("innerCode", ypd.get("id"));
            }

            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = creatCode((List) ypd.get("children"),
                        ypd.get("innerCode").toString());
                ypd.put("children", child);
            }
        }
        return list;
    }
}
