package com.ejianc.foundation.supplierChange.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.bean.CertsEntity;
import com.ejianc.foundation.share.bean.SubleadersEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.supplierChange.bean.CertsChangeEntity;
import com.ejianc.foundation.supplierChange.bean.SubleadersChangeEntity;
import com.ejianc.foundation.supplierChange.bean.SupplierChangeEntity;
import com.ejianc.foundation.supplierChange.enums.SupplierBillTypeEnum;
import com.ejianc.foundation.supplierChange.mapper.SupplierChangeMapper;
import com.ejianc.foundation.supplierChange.service.ISupplierChangeService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 供应商变更主实体
 * 
 * @author generator
 * 
 */
@Service("supplierChangeService")
public class SupplierChangeServiceImpl extends BaseServiceImpl<SupplierChangeMapper, SupplierChangeEntity> implements ISupplierChangeService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISupplierService supplierService;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void takeEffect(Long billId) {
        SupplierChangeEntity changeEntity = super.selectById(billId);
        SupplierEntity supplierEntity = supplierService.selectById(changeEntity.getSourceSupplierId());
        SupplierEntity updateEntity = BeanMapper.map(changeEntity, SupplierEntity.class);
        if(CollectionUtils.isNotEmpty(supplierEntity.getCerts())) {
            Map<String, CertsEntity> sourceCerts = supplierEntity.getCerts().stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item));
            List<CertsEntity> updateCerntList = new ArrayList<>();
            CertsEntity sourceCert = null, updateCert = null;
            for(CertsChangeEntity cert : changeEntity.getCerts()) {
                sourceCert = sourceCerts.get(cert.getSourceSupplierCertId().toString());
                updateCert = BeanMapper.map(cert, CertsEntity.class);
                updateCert.setId(sourceCert.getId());
                updateCert.setCreateTime(sourceCert.getCreateTime());
                updateCert.setCreateUserCode(sourceCert.getCreateUserCode());
                updateCert.setPid(sourceCert.getPid());

                //附件替换
                CommonResponse<List<AttachmentVO>> subFileCopyResp = attachmentApi.copyFiles(cert.getId().toString(), null, null, sourceCert.getId().toString(), null, null, true);
                if(!subFileCopyResp.isSuccess()) {
                    throw new BusinessException("供应商信息更新失败，企业证件复制失败！");
                }

                updateCerntList.add(updateCert);
            }
            updateEntity.setCerts(updateCerntList);

        } else {
            updateEntity.setCerts(new ArrayList<>());
        }
        if(CollectionUtils.isNotEmpty(supplierEntity.getSubLeaders())) {
            Map<String, SubleadersEntity> sourceLeaders = supplierEntity.getSubLeaders().stream().collect(Collectors.toMap(item -> item.getId().toString(), item -> item));
            List<SubleadersEntity> updaetLeaderList = new ArrayList<>();
            SubleadersEntity sourceSubleader = null, updateSubleadersEntity = null;
            for(SubleadersChangeEntity leaderChange : changeEntity.getSubLeaders()) {
                sourceSubleader = sourceLeaders.get(leaderChange.getSourceSupplierSubLeaderId().toString());
                updateSubleadersEntity = BeanMapper.map(leaderChange, SubleadersEntity.class);

                updateSubleadersEntity.setId(sourceSubleader.getId());
                updateSubleadersEntity.setCreateTime(sourceSubleader.getCreateTime());
                updateSubleadersEntity.setCreateUserCode(sourceSubleader.getCreateUserCode());
                updateSubleadersEntity.setPid(sourceSubleader.getPid());

                //附件替换
                CommonResponse<List<AttachmentVO>> subFileCopyResp = attachmentApi.copyFiles(leaderChange.getId().toString(), null, null, sourceSubleader.getId().toString(), null, null, true);
                if(!subFileCopyResp.isSuccess()) {
                    throw new BusinessException("供应商信息更新失败，分包负责人附件复制失败！");
                }

                updaetLeaderList.add(updateSubleadersEntity);
            }

            updateEntity.setSubLeaders(updaetLeaderList);
        } else {
            updateEntity.setSubLeaders(new ArrayList<>());
        }
        updateEntity.setId(supplierEntity.getId());
        updateEntity.setCreateTime(supplierEntity.getCreateTime());
        updateEntity.setCreateUserCode(supplierEntity.getCreateUserCode());
        updateEntity.setLabors(supplierEntity.getLabors());
        updateEntity.setHistory(supplierEntity.getHistory());
        updateEntity.setCode(supplierEntity.getCode());
        updateEntity.setVersion(supplierEntity.getVersion());

        //将变更单著单据附件更新到源供应商主单据中
        CommonResponse<List<AttachmentVO>> subFileCopyResp = attachmentApi.copyFiles(changeEntity.getId().toString(), null, null, supplierEntity.getId().toString(), null, null, true);
        if(!subFileCopyResp.isSuccess()) {
            throw new BusinessException("供应商信息更新失败，主单据附件复制失败！");
        }

        logger.info("本次变更单生效更新内容：{}", JSONObject.toJSONString(updateEntity));
        boolean rs = supplierService.saveOrUpdate(updateEntity);
        if(!rs) {
            throw new RuntimeException("供应商信息变更更新失败！");
        }
    }
}
