package com.ejianc.foundation.share.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.share.bean.UnitEntity;
import com.ejianc.foundation.share.mapper.UnitMapper;
import com.ejianc.foundation.share.service.IUnitService;
import com.ejianc.foundation.share.vo.UnitVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 计量单位实体
 * 
 * @author generator
 * 
 */
@Service("unitService")
public class UnitServiceImpl extends BaseServiceImpl<UnitMapper, UnitEntity> implements IUnitService{

    @Autowired
    private IUnitService unitService;

    @Autowired
    private UnitMapper unitMapper;

    @Autowired
    private EquipmentServiceImpl equipmentService;

    @Override
    public CommonResponse<UnitVO> saveOrUpdate(UnitVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        UnitEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0){
            List<Long> ids = new ArrayList<>();
            ids.add(saveorUpdateVO.getId());
            //修改  校验编号是否重复
            LambdaQueryWrapper<UnitEntity> lambda = Wrappers.<UnitEntity>lambdaQuery();
            lambda.eq(UnitEntity::getUnitCode, saveorUpdateVO.getUnitCode());
            lambda.eq(UnitEntity::getTenantId, tenantId);
            lambda.ne(UnitEntity::getId, saveorUpdateVO.getId());
            List<UnitEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                return CommonResponse.error("存在相同编码，不允许保存!");
            }
            //校验名称是否重复
            LambdaQueryWrapper<UnitEntity> nameLambda = Wrappers.<UnitEntity>lambdaQuery();
            nameLambda.eq(UnitEntity::getTenantId, tenantId);
            nameLambda.eq(UnitEntity::getUnitName, saveorUpdateVO.getUnitName());
            nameLambda.ne(UnitEntity::getId, saveorUpdateVO.getId());
            List<UnitEntity> nameEntities = super.list(nameLambda);
            if (nameEntities != null && nameEntities.size() > 0) {
                return CommonResponse.error("存在相同名称，不允许保存!");
            }
            entity = BeanMapper.map(saveorUpdateVO, UnitEntity.class);
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("修改成功！");
        } else {
            //新增
            //校验编号是否重复
            LambdaQueryWrapper<UnitEntity> codeLambda = Wrappers.<UnitEntity>lambdaQuery();
            codeLambda.eq(UnitEntity::getTenantId, tenantId);
            codeLambda.eq(UnitEntity::getUnitCode, saveorUpdateVO.getUnitCode());
            List<UnitEntity> codeEntities = super.list(codeLambda);
            if (codeEntities != null && codeEntities.size() > 0) {
                return CommonResponse.error("存在相同编码，不允许保存!");
            }
            //校验名称是否重复
            LambdaQueryWrapper<UnitEntity> nameLambda = Wrappers.<UnitEntity>lambdaQuery();
            nameLambda.eq(UnitEntity::getTenantId, tenantId);
            nameLambda.eq(UnitEntity::getUnitName, saveorUpdateVO.getUnitName());
            List<UnitEntity> nameEntities = super.list(nameLambda);
            if (nameEntities != null && nameEntities.size() > 0) {
                return CommonResponse.error("存在相同名称，不允许保存!");
            }
            entity = BeanMapper.map(saveorUpdateVO, UnitEntity.class);
            entity.setId(IdWorker.getId());
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("保存成功！");
        }
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                List<UnitVO> unitVOList = new ArrayList<>();
                for (int i = 1; i < result.size(); i++) {
                    //查询所有计量单位
                    QueryParam queryParam = new QueryParam();
                    List<String> codeList = new ArrayList<>();
                    List<String> nameList = new ArrayList<>();
                    List<UnitEntity> oldList = unitService.queryList(queryParam);
                    for(UnitEntity unitEntity : oldList){
                        codeList.add(unitEntity.getUnitCode());
                        nameList.add(unitEntity.getUnitName());
                    }

                    List<String> datas = result.get(i);
                    UnitVO vo = new UnitVO();
                    boolean flag = false;
                    String warnType = "";

                    //编号
                    String unitCode = datas.get(0);
                    vo.setUnitCode(unitCode);
                    //导入数据校验
                    //编码非空
                    if(StringUtils.isEmpty(unitCode)){
                        vo.setUnitCode(null);
                        warnType = warnType+"编码为空,";
                        flag = true;
                    }else{
                        //编码重复
                        if(codeList.contains(unitCode)){
                            vo.setUnitCode(unitCode);
                            warnType = warnType+"编码重复,";
                            flag = true;
                        }
                        vo.setUnitCode(unitCode);
                    }
                    // 名称校验
                    String unitName = datas.get(1);
                    vo.setUnitName(unitName);
                    if(StringUtils.isEmpty(unitName)){
                        vo.setUnitName(null);
                        warnType = warnType+"名称为空,";
                        flag = true;
                    }else{
                        //编码重复
                        if(codeList.contains(unitName)){
                            vo.setUnitName(unitName);
                            warnType = warnType+"名称重复,";
                            flag = true;
                        }
                        vo.setUnitName(unitName);
                    }
                    vo.setEnabled(1);
                    // true=可以导入，false=不可导入
                    vo.setImportFlag(!flag);
                    if(flag){
                        warnType = warnType.substring(0,warnType.length()-1);
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    unitVOList.add(vo);
                }
                // 处理成功列表和失败列表
                List<UnitVO> successList = new ArrayList<>();
                List<UnitVO> errorList = new ArrayList<>();
                if (CollectionUtils.isNotEmpty(unitVOList)) {
                    unitVOList.forEach(vo -> {
                        if (StringUtils.isEmpty(vo.getWarnType())) {
                            successList.add(vo);
                        } else {
                            errorList.add(vo);
                        }
                    });
                }
                resp.put("successList",successList);
                resp.put("errorList",errorList);
                resp.put("successNum",result.size() - errorList.size());
                resp.put("errorNum",errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }

    }

    @Override
    public Object saveImportExcel(HttpServletRequest request, List<UnitVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("导入的数据为空！");
        }
        List<UnitEntity> list = new ArrayList<>();
        for (UnitVO importVO : importVOS) {
            UnitEntity unit = BeanMapper.map(importVO, UnitEntity.class);
            unit.setEnabled(1);//默认给是否启用赋值为1：启用
            list.add(unit);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            super.saveOrUpdateBatch(list);
        }
        return "保存成功！";
    }

    @Override
    public List<UnitVO> getAllByNames(List<String> unitNames) {
        List<UnitVO> resp = new ArrayList<>();
        QueryWrapper<UnitEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("unit_name", unitNames);

        List<UnitEntity> dbEntities = super.list(query);
        if(CollectionUtils.isNotEmpty(dbEntities)) {
            return BeanMapper.mapList(dbEntities, UnitVO.class);
        }

        return resp;
    }
}
