package com.ejianc.foundation.share.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 项目WBS模板主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_share_project_wbs_template")
public class ProjectWbsTemplateEntity extends BaseEntity {

    private static final long serialVersionUID = 8297894909842985262L;
    @TableField(value = "bill_code")
    private String billCode;//单据编码

    @TableField(value = "bill_name")
    private String billName;
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期
    @TableField(value="project_type_id")
    private Long projectTypeId; // 项目类型id
    @TableField(value="project_type_name")
    private String projectTypeName; // 项目类型名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人主键
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="enabled")
    private String enabled; // 模板启停用：0-停用，1-启用

    @TableField(exist=false)
    @SubEntity(serviceName="projectWbsTemplateDetailService", pidName = "templateId")
    private List<ProjectWbsTemplateDetailEntity> detailList = new ArrayList<>(); // 项目WBS模板子表

    public String getBillName() {
        return billName;
    }

    public void setBillName(String billName) {
        this.billName = billName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Long getProjectTypeId() {
        return projectTypeId;
    }

    public void setProjectTypeId(Long projectTypeId) {
        this.projectTypeId = projectTypeId;
    }
    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getEnabled() {
        return enabled;
    }

    public void setEnabled(String enabled) {
        this.enabled = enabled;
    }

    public List<ProjectWbsTemplateDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ProjectWbsTemplateDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
