/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.company.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.company.bean.FillUploadDetailEntity;
import com.ejianc.foundation.company.bean.FillUploadEntity;
import com.ejianc.foundation.company.service.IFillUploadDetailService;
import com.ejianc.foundation.company.service.IFillUploadService;
import com.ejianc.foundation.company.vo.FillUploadDetailVO;
import com.ejianc.foundation.company.vo.LedgerDetailVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"fillUploadDetail"})
public class FillUploadDetailController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IFillUploadDetailService service;
    @Autowired
    private IFillUploadService fillUploadService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FillUploadDetailVO> saveOrUpdate(@RequestBody FillUploadDetailVO saveOrUpdateVO) {
        BillCodeParam billCodeParam;
        CommonResponse billCode;
        FillUploadDetailEntity entity = (FillUploadDetailEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, FillUploadDetailEntity.class));
        if (!(entity.getId() != null && entity.getId() != 0L || (billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess())) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.service.saveOrUpdate((Object)entity, false);
        FillUploadDetailVO vo = (FillUploadDetailVO)BeanMapper.map((Object)((Object)entity), FillUploadDetailVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FillUploadDetailVO> queryDetail(Long id) {
        FillUploadDetailEntity entity = (FillUploadDetailEntity)((Object)this.service.selectById(id));
        FillUploadDetailVO vo = (FillUploadDetailVO)BeanMapper.map((Object)((Object)entity), FillUploadDetailVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FillUploadDetailVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (FillUploadDetailVO fillUploadDetailVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<LedgerDetailVo>> queryList(@RequestBody QueryParam param) {
        Parameter parameter = (Parameter)param.getParams().get("choseAorB");
        param.getParams().remove("choseAorB");
        if (parameter == null) {
            return CommonResponse.error((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u7c7b\u578b\uff01");
        }
        Object value = parameter.getValue();
        if ("A".equals(value)) {
            List list = this.fillUploadService.queryList(param);
            List ids = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            QueryParam queryParam = new QueryParam();
            if (!ids.isEmpty()) {
                queryParam.getParams().put("fillId", new Parameter("in", ids));
            }
            IPage page = this.service.queryPage(queryParam);
            Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            HashMap<Long, FillUploadEntity> map = new HashMap<Long, FillUploadEntity>();
            for (Object entity : list) {
                map.put(entity.getId(), (FillUploadEntity)((Object)entity));
            }
            ArrayList<LedgerDetailVo> listData = new ArrayList<LedgerDetailVo>();
            for (FillUploadDetailEntity vo : page.getRecords()) {
                LedgerDetailVo detailVo = (LedgerDetailVo)BeanMapper.map((Object)((Object)vo), LedgerDetailVo.class);
                detailVo.setProjectName(((FillUploadEntity)((Object)map.get(vo.getFillId()))).getProjectName());
                detailVo.setProjectId(((FillUploadEntity)((Object)map.get(vo.getFillId()))).getProjectId());
                switch (vo.getWhetherHandOver()) {
                    case 1: {
                        detailVo.setWhetherHandOverStr("\u662f");
                        break;
                    }
                    case 2: {
                        detailVo.setWhetherHandOverStr("\u5426");
                    }
                }
                listData.add(detailVo);
            }
            pageData.setRecords(listData);
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        if ("B".equals(value)) {
            IPage page = this.service.queryPage(param);
            Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            List records = page.getRecords();
            List ids = records.stream().map(FillUploadDetailEntity::getFillId).collect(Collectors.toList());
            QueryParam queryParam = new QueryParam();
            if (!ids.isEmpty()) {
                queryParam.getParams().put("id", new Parameter("in", ids));
            }
            List fillUploadEntities = this.fillUploadService.queryList(queryParam);
            HashMap<Long, FillUploadEntity> map = new HashMap<Long, FillUploadEntity>();
            for (FillUploadEntity entity : fillUploadEntities) {
                map.put(entity.getId(), entity);
            }
            ArrayList<LedgerDetailVo> listData = new ArrayList<LedgerDetailVo>();
            for (FillUploadDetailEntity vo : records) {
                LedgerDetailVo detailVo = (LedgerDetailVo)BeanMapper.map((Object)((Object)vo), LedgerDetailVo.class);
                detailVo.setProjectName(((FillUploadEntity)((Object)map.get(vo.getFillId()))).getProjectName());
                detailVo.setProjectId(((FillUploadEntity)((Object)map.get(vo.getFillId()))).getProjectId());
                listData.add(detailVo);
            }
            pageData.setRecords(listData);
            return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
        }
        return CommonResponse.error((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u7c7b\u578b\uff01");
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List entityList = this.service.queryList(param);
        List detailVos = BeanMapper.mapList((Iterable)entityList, LedgerDetailVo.class);
        for (LedgerDetailVo detailVo : detailVos) {
            switch (detailVo.getWhetherHandOver()) {
                case 1: {
                    detailVo.setWhetherHandOverStr("\u662f");
                    break;
                }
                case 2: {
                    detailVo.setWhetherHandOverStr("\u5426");
                }
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", detailVos);
        ExcelExport.getInstance().export("FillUpload-Detail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refFillUploadDetailData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FillUploadDetailVO>> refFillUploadDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FillUploadDetailVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

