package com.ejianc.foundation.company.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.foundation.company.bean.FillUploadDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 *
 * 资料下载
 * @author generator
 * 
 */
 @TableName("ejc_share_fill_upload")
public class FillUploadEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="manager_id")
    private Long managerId; // 经办人
    @TableField(value="manager_name")
    private String managerName; // 经办人名称
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="secondary_units")
    private String secondaryUnits; // 二级单位
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_id")
    private Long projectId; // 项目名称ID
    @TableField(value="bill_name")
    private String billName; // 单据名称
    @TableField(value="bill_data")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billData; // 单据日期
    @TableField(value="ledger_administrator")
    private String ledgerAdministrator; // 台账管理员
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="fillUploadDetailService",pidName = "fillId")
    private List<FillUploadDetailEntity> fillUploadDetailList = new ArrayList<>(); // 资料上传子表

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getManagerId() {
        return managerId;
    }

    public void setManagerId(Long managerId) {
        this.managerId = managerId;
    }
    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getSecondaryUnits() {
        return secondaryUnits;
    }

    public void setSecondaryUnits(String secondaryUnits) {
        this.secondaryUnits = secondaryUnits;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getBillName() {
        return billName;
    }

    public void setBillName(String billName) {
        this.billName = billName;
    }
    public Date getBillData() {
        return billData;
    }

    public void setBillData(Date billData) {
        this.billData = billData;
    }
    public String getLedgerAdministrator() {
        return ledgerAdministrator;
    }

    public void setLedgerAdministrator(String ledgerAdministrator) {
        this.ledgerAdministrator = ledgerAdministrator;
    }
    

    public List<FillUploadDetailEntity> getFillUploadDetailList() {
        return fillUploadDetailList;
    }

    public void setFillUploadDetailList(List<FillUploadDetailEntity> fillUploadDetailList) {
        this.fillUploadDetailList = fillUploadDetailList;
    }
}
