package com.ejianc.foundation.company.mapper;

import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.foundation.company.bean.CompanyStateDetailEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 公司潜亏情况子表
 * 
 * @author generator
 * 
 */
@Mapper
public interface CompanyStateDetailMapper extends BaseCrudMapper<CompanyStateDetailEntity> {
    /**
     * 潜亏类别（与财务账面利润对比）统计
     * 返回格式：List<Map<String, Object>>
     * Map包含：year, quarter, one, two, three
     */
    List<Map<String, Object>> countByFinancialProfitType();

    /**
     * 潜亏类别-完工预计经营情况统计（按季度统计）
     * 返回格式：List<Map<String, Object>>
     * Map包含：year, quarter, one, two, three
     */
    List<Map<String, Object>> countByCompletionEstimateType();

    /**
     * 潜亏类别-开累经营情况统计（按季度统计）
     * 返回格式：List<Map<String, Object>>
     * Map包含：year, quarter, one, two, three
     */
    List<Map<String, Object>> countByCumulativeOperationType();
}
