/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.share.bean.EquipmentCategoryEntity;
import com.ejianc.foundation.share.service.IEquipmentCategoryService;
import com.ejianc.foundation.share.service.IEquipmentService;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.share.vo.MaterialCategoryImportVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/equipment/category/"})
public class EquipmentCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String EQUIPMENT_CATEGORY_BILL_CODE = "SUPPORT_EQUIPMENT_CATEGORY";
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IEquipmentCategoryService equipmentCategoryService;
    @Autowired
    private IEquipmentService equipmentService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<EquipmentCategoryVO> saveOrUpdate(@RequestBody EquipmentCategoryVO equipmentCategoryVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (equipmentCategoryVo.getId() != null && equipmentCategoryVo.getId() > 0L) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{equipmentCategoryVo.getCode()})) {
                List<EquipmentCategoryEntity> codeData = this.equipmentCategoryService.queryByCode(equipmentCategoryVo.getCode());
                if (codeData != null && codeData.size() > 0 && !equipmentCategoryVo.getId().equals(codeData.get(0).getId())) {
                    throw new BusinessException("\u5206\u7c7b\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u586b\u5199");
                }
            } else {
                throw new BusinessException("\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            EquipmentCategoryVO uniqueBean = this.equipmentCategoryService.queryDetail(equipmentCategoryVo.getId());
            uniqueBean.setCode(equipmentCategoryVo.getCode());
            uniqueBean.setName(equipmentCategoryVo.getName());
            uniqueBean.setDescription(equipmentCategoryVo.getDescription());
            uniqueBean.setSequence(equipmentCategoryVo.getSequence());
            uniqueBean.setUpdateUserCode(InvocationInfoProxy.getUsercode());
            uniqueBean.setUpdateTime(equipmentCategoryVo.getUpdateTime());
            uniqueBean.setSubjectId(equipmentCategoryVo.getSubjectId());
            uniqueBean.setSubjectName(equipmentCategoryVo.getSubjectName());
            uniqueBean.setSubjectIds(equipmentCategoryVo.getSubjectIds());
            uniqueBean.setSubjectNames(equipmentCategoryVo.getSubjectNames());
            uniqueBean.setSubjectRelations(equipmentCategoryVo.getSubjectRelations());
            EquipmentCategoryEntity entity = (EquipmentCategoryEntity)BeanMapper.map((Object)uniqueBean, EquipmentCategoryEntity.class);
            this.equipmentCategoryService.update(entity);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f", (Object)BeanMapper.map((Object)entity, EquipmentCategoryVO.class));
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{equipmentCategoryVo.getCode()})) {
            List<EquipmentCategoryEntity> codeData = this.equipmentCategoryService.queryByCode(equipmentCategoryVo.getCode());
            if (codeData != null && codeData.size() > 0) {
                throw new BusinessException("\u5206\u7c7b\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u586b\u5199");
            }
        } else {
            CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(EQUIPMENT_CATEGORY_BILL_CODE, tenantId);
            if (codeBatchByRuleCode.isSuccess()) {
                equipmentCategoryVo.setCode((String)codeBatchByRuleCode.getData());
            }
        }
        EquipmentCategoryEntity entity = (EquipmentCategoryEntity)BeanMapper.map((Object)equipmentCategoryVo, EquipmentCategoryEntity.class);
        entity.setId(IdWorker.getId());
        if (entity.getParentId() != null && entity.getParentId() > 0L) {
            EquipmentCategoryVO uniqueBean = this.equipmentCategoryService.queryDetail(entity.getParentId());
            entity.setInnerCode(uniqueBean.getInnerCode() + "|" + entity.getId());
        } else {
            entity.setInnerCode(entity.getId().toString());
        }
        entity.setEnabled(1);
        entity.setCreateUserCode(InvocationInfoProxy.getUsercode());
        entity.setCreateTime(new Date());
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        this.equipmentCategoryService.save(entity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f", (Object)BeanMapper.map((Object)entity, EquipmentCategoryVO.class));
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
        List<EquipmentCategoryEntity> dataList = this.equipmentCategoryService.queryList(queryParam);
        List resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l -> {
            if (l.get("leaf").equals(false)) {
                l.put("children", new ArrayList());
            }
        });
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/queryListData"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryListData(@RequestBody QueryParam queryParam) {
        List<EquipmentCategoryEntity> dataList = this.equipmentCategoryService.queryList(queryParam);
        List resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l -> {
            if (l.get("leaf").equals(false)) {
                l.put("children", new ArrayList());
            }
        });
        List treeData = ResultAsTree.createTreeData((List)resultMapList);
        return CommonResponse.success((Object)treeData);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<EquipmentCategoryVO> queryDetail(@RequestParam Long id) {
        EquipmentCategoryVO equipmentCategoryVo = this.equipmentCategoryService.queryDetail(id);
        return CommonResponse.success((Object)equipmentCategoryVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                EquipmentCategoryVO equipmentCategoryVO = this.equipmentCategoryService.queryDetail(id);
                List<EquipmentVO> equipmentList = this.equipmentService.queryListByCategoryId(id);
                if (equipmentList != null && equipmentList.size() > 0) {
                    return CommonResponse.error((String)("\u5206\u7c7b\u3010" + equipmentCategoryVO.getName() + "\u3011\u4e0b\u6709\u8bbe\u5907\u4e86\uff0c\u4e0d\u5141\u8bb8\u5220\u9664"));
                }
                List<EquipmentCategoryVO> children = this.equipmentCategoryService.queryListByPid(id);
                if (children == null || children.size() <= 0) continue;
                for (EquipmentCategoryVO child : children) {
                    if (ids.contains(child.getId())) continue;
                    return CommonResponse.error((String)("\u5206\u7c7b\u3010" + equipmentCategoryVO.getName() + "\u3011\u4e0b\u6709\u5b50\u5206\u7c7b\u4e0d\u5141\u8bb8\u5220\u9664"));
                }
            }
        } else {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        this.equipmentCategoryService.delete(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/enabled/update"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateEnabled(@RequestBody EquipmentCategoryVO equipmentCategoryVo) {
        EquipmentCategoryVO condition = this.equipmentCategoryService.queryDetail(equipmentCategoryVo.getId());
        this.equipmentCategoryService.updateEnabled(equipmentCategoryVo.getEnabled(), condition.getTenantId(), condition.getInnerCode());
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @RequestMapping(value={"/sync"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> syncEquipmentCategoryList() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (this.OMS_TENANT.equals(tenantId.toString())) {
            return CommonResponse.error((String)"\u5e73\u53f0\u8fd0\u8425\u4eba\u5458\u4e0d\u80fd\u64cd\u4f5c\u6b64\u529f\u80fd");
        }
        this.equipmentCategoryService.insertCategoryListFromPlatform();
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f");
    }

    @RequestMapping(value={"/queryEquipmentRefTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> queryEquipmentRefTree(@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        List<EquipmentCategoryVO> dataList = null;
        try {
            JSONObject _conJson;
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                params.put("searchText", searchText);
            }
            params.put("tenantId", InvocationInfoProxy.getTenantid());
            if (StringUtils.isNotBlank((CharSequence)condition) && (_conJson = JSONObject.parseObject((String)condition)).containsKey((Object)"categoryId")) {
                params.put("ids", Arrays.asList(_conJson.getString("categoryId").split(",")));
            }
            dataList = this.equipmentCategoryService.queryListTree(params);
            List map = BeanMapper.mapList(dataList, Map.class);
            return ResultAsTree.createTreeData((List)map);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    @RequestMapping(value={"/lazyEquipmentCategoryTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> lazyEquipmentCategoryTree(@RequestParam(required=false) String condition, @RequestParam(required=false) Long pid, @RequestParam(required=false) String searchText) {
        List<EquipmentCategoryVO> dataList = null;
        try {
            JSONObject con;
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                Object categoryIdObj;
                params.put("searchText", searchText);
                params.put("tenantId", InvocationInfoProxy.getTenantid());
                if (StringUtils.isNotBlank((CharSequence)condition) && null != (categoryIdObj = (con = JSONObject.parseObject((String)condition)).get((Object)"categoryId"))) {
                    List<Long> asList = new ArrayList<Long>();
                    String categoryId = (String)categoryIdObj;
                    if (categoryId.indexOf(",") > 0) {
                        String[] strings = categoryId.split(",");
                        for (String str : strings) {
                            asList.add(Long.valueOf(str));
                        }
                    } else {
                        asList.add(Long.valueOf(categoryId));
                    }
                    ArrayList<EquipmentCategoryVO> categoryList = new ArrayList<EquipmentCategoryVO>();
                    for (Long parentId : asList) {
                        categoryList.addAll(this.equipmentCategoryService.queryListByPid(parentId));
                    }
                    asList = categoryList.stream().map(EquipmentCategoryVO::getId).collect(Collectors.toList());
                    params.put("ids", asList);
                }
                dataList = this.equipmentCategoryService.queryListTree(params);
            } else {
                Object categoryIdObj;
                dataList = this.equipmentCategoryService.queryListByPid(pid);
                if (StringUtils.isNotBlank((CharSequence)condition) && pid == null && null != (categoryIdObj = (con = JSONObject.parseObject((String)condition)).get((Object)"categoryId"))) {
                    ArrayList<Long> asList = new ArrayList<Long>();
                    String categoryId = (String)categoryIdObj;
                    if (categoryId.indexOf(",") > 0) {
                        String[] strings;
                        for (String str : strings = categoryId.split(",")) {
                            asList.add(Long.valueOf(str));
                        }
                    } else {
                        asList.add(Long.valueOf(categoryId));
                    }
                    dataList = this.equipmentCategoryService.queryCategoryListByIds(asList);
                }
            }
            List map = BeanMapper.mapList(dataList, Map.class);
            return ResultAsTree.createTreeData((List)map);
        }
        catch (Exception e) {
            return null;
        }
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"material-category-import.xlsx", (String)"\u8bbe\u5907\u5206\u7c7b\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList successList = new ArrayList();
        ArrayList<MaterialCategoryImportVO> processList = new ArrayList<MaterialCategoryImportVO>();
        ArrayList<MaterialCategoryImportVO> errorList = new ArrayList<MaterialCategoryImportVO>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5206\u7c7b\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap<String, ArrayList<MaterialCategoryImportVO>> mapChildren = new HashMap<String, ArrayList<MaterialCategoryImportVO>>();
            HashMap<String, MaterialCategoryImportVO> codeToData = new HashMap<String, MaterialCategoryImportVO>();
            HashMap codeNotExistData = new HashMap();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                MaterialCategoryImportVO materialVo = new MaterialCategoryImportVO();
                materialVo.setId(Long.valueOf(IdWorker.getId()));
                materialVo.setCode((String)datas.get(0));
                materialVo.setParentCode((String)datas.get(1));
                materialVo.setName((String)datas.get(2));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    materialVo.setDescription("\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a\uff01");
                    errorList.add(materialVo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    materialVo.setDescription("\u5206\u7c7b\u540d\u79f0\u4e3a\u7a7a\uff01");
                    errorList.add(materialVo);
                    continue;
                }
                List<EquipmentCategoryEntity> list = this.equipmentCategoryService.queryByCode(String.valueOf(datas.get(0)));
                if (ListUtil.isEmpty(list)) {
                    List<Object> list1;
                    list = this.equipmentCategoryService.queryByName(String.valueOf(datas.get(2)));
                    if (ListUtil.isNotEmpty(list)) {
                        materialVo.setDescription("\u5206\u7c7b\u540d\u79f0\u91cd\u590d\uff01");
                        errorList.add(materialVo);
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                        materialVo.setInnerCode(materialVo.getId().toString());
                    }
                    materialVo.setEnabled(Integer.valueOf(1));
                    materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    materialVo.setCreateTime(new Date());
                    materialVo.setTenantId(InvocationInfoProxy.getTenantid());
                    processList.add(materialVo);
                    codeToData.put(materialVo.getCode(), materialVo);
                    if (StringUtils.isBlank((CharSequence)materialVo.getParentCode())) {
                        list1 = (ArrayList<MaterialCategoryImportVO>)mapChildren.get("null");
                        if (ListUtil.isEmpty((List)list1)) {
                            list1 = new ArrayList<MaterialCategoryImportVO>();
                            mapChildren.put("null", (ArrayList<MaterialCategoryImportVO>)list1);
                        }
                        list1.add(materialVo);
                        continue;
                    }
                    list1 = (List)mapChildren.get(materialVo.getParentCode());
                    if (ListUtil.isEmpty((List)list1)) {
                        list1 = new ArrayList();
                        mapChildren.put(materialVo.getParentCode(), (ArrayList<MaterialCategoryImportVO>)list1);
                    }
                    list1.add(materialVo);
                    continue;
                }
                materialVo.setDescription("\u5206\u7c7b\u7f16\u7801\u91cd\u590d\uff01");
                errorList.add(materialVo);
            }
            if (ListUtil.isNotEmpty(processList)) {
                processList.forEach(p -> {
                    if (StringUtils.isNotEmpty((CharSequence)p.getParentCode())) {
                        MaterialCategoryImportVO parentVo = (MaterialCategoryImportVO)codeToData.get(p.getParentCode());
                        if (parentVo == null) {
                            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)codeNotExistData.get(p.getParentCode())))) {
                                p.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                                errorList.add((MaterialCategoryImportVO)p);
                            } else {
                                List<EquipmentCategoryEntity> list = this.equipmentCategoryService.queryByCode(p.getParentCode());
                                if (ListUtil.isEmpty(list)) {
                                    codeNotExistData.put(p.getParentCode(), p.getParentCode());
                                    p.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                                    errorList.add((MaterialCategoryImportVO)p);
                                } else {
                                    p.setInnerCode(list.get(0).getInnerCode() + "|" + p.getId());
                                    p.setParentId(list.get(0).getId());
                                    successList.add(p);
                                }
                            }
                        } else if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
                            this.setInnerCodeAndParentId(parentVo, codeToData, codeNotExistData);
                            if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
                                p.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                                errorList.add((MaterialCategoryImportVO)p);
                            } else {
                                p.setInnerCode(parentVo.getInnerCode() + "|" + p.getId());
                                p.setParentId(parentVo.getId());
                                successList.add(p);
                            }
                        } else {
                            p.setInnerCode(parentVo.getInnerCode() + "|" + p.getId());
                            p.setParentId(parentVo.getId());
                            successList.add(p);
                        }
                    } else {
                        successList.add(p);
                    }
                });
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    private void setInnerCodeAndParentId(MaterialCategoryImportVO vo, Map<String, MaterialCategoryImportVO> codeToData, Map<String, String> codeNotExistData) {
        MaterialCategoryImportVO parentVo = codeToData.get(vo.getParentCode());
        if (parentVo == null) {
            if (StringUtils.isNotEmpty((CharSequence)codeNotExistData.get(vo.getParentCode()))) {
                vo.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
            } else {
                List<EquipmentCategoryEntity> list = this.equipmentCategoryService.queryByCode(vo.getParentCode());
                if (ListUtil.isEmpty(list)) {
                    codeNotExistData.put(vo.getParentCode(), vo.getParentCode());
                    vo.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                } else {
                    vo.setInnerCode(list.get(0).getInnerCode() + "|" + vo.getId());
                    vo.setParentId(list.get(0).getId());
                }
            }
        } else if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
            this.setInnerCodeAndParentId(parentVo, codeToData, codeNotExistData);
            if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
                vo.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
            } else {
                vo.setInnerCode(parentVo.getInnerCode() + "|" + vo.getId());
                vo.setParentId(parentVo.getId());
            }
        } else {
            vo.setInnerCode(parentVo.getInnerCode() + "|" + vo.getId());
            vo.setParentId(parentVo.getId());
        }
    }

    @RequestMapping(value={"/saveImportExcelEquipmentCategory"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcelEquipmentCategory(@RequestBody List<MaterialCategoryImportVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList<EquipmentCategoryEntity> toSave = new ArrayList<EquipmentCategoryEntity>();
        importVOS.forEach(importVO -> toSave.add((EquipmentCategoryEntity)BeanMapper.map((Object)importVO, EquipmentCategoryEntity.class)));
        this.equipmentCategoryService.insertBatch(toSave);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }
}

