package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.ProjectSetExPoolEntity;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.service.IProjectSetExPoolService;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.vo.ProjectDesktopSubParentVO;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目WBS
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectSetPool")
public class ProjectSetPoolController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IProjectSetService projectSetService;

    /** 郑州一建专用  */
    @Autowired
    private IProjectSetExPoolService projectSetExPoolService;

    @Autowired
    private SessionManager sessionManager;

    private static String RANGE_ALL="all";

    @Autowired
    private IDefdocApi defdocApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectPoolSetVO> saveOrUpdate(@RequestBody ProjectPoolSetVO saveOrUpdateVO) {
        ProjectSetPoolEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectSetPoolEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> codeBatchByRuleCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(codeBatchByRuleCode.isSuccess()){
                saveOrUpdateVO.setCode(codeBatchByRuleCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            ProjectSetPoolEntity dbEntity =projectSetService.selectById(entity.getId());
            if(null != dbEntity && !StringUtils.equals(dbEntity.getName(), saveOrUpdateVO.getName()) || !StringUtils.equals(dbEntity.getShortName(), saveOrUpdateVO.getShortName())) {
                // 更新组织名称
                CommonResponse<OrgVO> orgResp = iOrgApi.getOneById(dbEntity.getOrgId());
                if(!orgResp.isSuccess()) {
                    logger.error("根据项目部id-{} 查询项目部信息失败，项目信息保存失败，{}", dbEntity.getOrgId(), JSONObject.toJSONString(orgResp));
                    throw new BusinessException("获取项目所属项目部信息失败， 请稍后再试");
                }
                OrgVO org = orgResp.getData();
                org.setName(saveOrUpdateVO.getName());
                org.setShortName(saveOrUpdateVO.getShortName());
                logger.info("项目id-{} 名称-{},简称-{} 调整，同步更新对应项目部id-{}", dbEntity.getId(),
                        saveOrUpdateVO.getName(), saveOrUpdateVO.getShortName(), saveOrUpdateVO.getOrgId());
                CommonResponse<OrgVO> updateOrgResp = iOrgApi.saveOrgInfo(org);
                if(!updateOrgResp.isSuccess()) {
                    logger.error("更新项目id-{} 对应项目部id-{} 全称、简称失败，项目信息保存失败，{}", dbEntity.getOrgId(), JSONObject.toJSONString(updateOrgResp));
                    throw new BusinessException("更新项目所属项目部名称失败，请稍后再试");
                }
            }
        }

        if((null != entity.getMeasureType()) && StringUtils.isNotBlank(entity.getMeasureValue())) {
            CommonResponse<DefdocDetailVO> docResp =defdocApi.getDefDocById(entity.getMeasureType());
            if(!docResp.isSuccess() || null == docResp.getData()) {
                logger.error("根据Id-{}查询工程度量方式失败：{}", entity.getMeasureType(), JSONObject.toJSONString(docResp));
                return CommonResponse.error("查询度量方式档案信息失败！");
            }
            String measureUnitName = docResp.getData().getName();
            if(measureUnitName.contains("（")) {
                //替换中文括号
                measureUnitName = measureUnitName.replace("（", "(");
                measureUnitName = measureUnitName.replace("）", ")");
            }
            if(measureUnitName.contains("(")) {
                //提取括号中的内容
                measureUnitName = (measureUnitName.split("\\(")[1]).split("\\)")[0];
            }
            entity.setMeasure(entity.getMeasureValue()+measureUnitName);
        }

        projectSetService.saveOrUpdate(entity, false);
        ProjectPoolSetVO vo = BeanMapper.map(entity, ProjectPoolSetVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectPoolSetVO> queryDetail(Long id) {
        ProjectSetPoolEntity entity = projectSetService.selectById(id);
        ProjectPoolSetVO vo = BeanMapper.map(entity, ProjectPoolSetVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectPoolSetVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ProjectPoolSetVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        projectSetService.removeByIds(vos.stream().map(ProjectPoolSetVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectPoolSetVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("shortName");
        param.getFuzzyFields().add("buildUnitName");
        param.getFuzzyFields().add("orgName");
        param.getFuzzyFields().add("projectDepartmentName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /**
         * 2022年8月18日
         * 不要树形结构
         *
         * */

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        /** 要求主表有orgId字段，保存单据所属组织 */
        if(commonOrgIds.size() != 0) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }else if(departmentIds.size() != 0){
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }else {
            return CommonResponse.success("查询列表数据成功！",new Page<>(1, param.getPageSize(), 0));
        }

        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ProjectSetPoolEntity> page = projectSetService.queryPage(param,false);
        IPage<ProjectPoolSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectPoolSetVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getFuzzyFields().add("orgName");
        param.getFuzzyFields().add("buildUnitName");
        param.getFuzzyFields().add("projectDepartmentName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProjectSetPoolEntity> list = projectSetService.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectWbs-export.xlsx", beans, response);
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "projectWbs-export.xlsx", "合同清单导入模板");
    }

    /**
     * @Description 参照  执行项目
     *
     * @Return void
     */
    @RequestMapping(value = "/refProjectSetData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectPoolSetVO>> refProjectSetData(@RequestParam(defaultValue = "1") int pageNumber,
                                                                     @RequestParam(defaultValue = "10") int pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        /** 模糊搜索配置字段示例 */
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getFuzzyFields().add("orgName");
        param.getFuzzyFields().add("buildUnitName");
        param.getFuzzyFields().add("projectDepartmentName");
        param.getOrderMap().put("createTime", "desc");
        Long orgId = InvocationInfoProxy.getOrgId();

        /**
         * 根据需求 修改为
         * 查询 “执行项目”
         * 2022-7-27
         * */
        param.getParams().put("attribute",new Parameter(QueryParam.EQ,2));

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotBlank(condition)){
            JSONObject _con = JSONObject.parseObject(condition);

            String parentProjectId = _con.getString("parentProjectId");
            if(StringUtils.isNotBlank(parentProjectId)){
                param.getParams().put("parentProjectId",new Parameter(QueryParam.EQ,parentProjectId));
            }
            if(StringUtils.isNotBlank(_con.getString("orgId"))){
                orgId = _con.getLong("orgId");
            }
            //调入项目不要组织过滤
            String rangeType = _con.getString("range");
            if (StringUtils.isNotEmpty(rangeType)){
                if (RANGE_ALL.equals(rangeType)){
                    IPage<ProjectSetPoolEntity> page = projectSetService.queryPage(param, false);
                    IPage<ProjectPoolSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
                    pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectPoolSetVO.class));
                    List<ProjectPoolSetVO> records = pageData.getRecords();
                    if(ListUtil.isNotEmpty(records))
                    records.forEach(projectSetVO -> {

                        QueryParam queryParam = new QueryParam();
                        queryParam.getParams().put("parentProjectId", new Parameter(QueryParam.EQ, projectSetVO.getId()));
                        List<ProjectSetPoolEntity> entityList = projectSetService.queryList(queryParam, false);

                        if(ListUtil.isNotEmpty(entityList)) {
                            List<ProjectPoolSetVO> projectSetVOS = new ArrayList<>();
                            for (int i = 0; i < entityList.size(); i++) {
                                ProjectPoolSetVO setVO = BeanMapper.map(entityList.get(i), ProjectPoolSetVO.class);
                                projectSetVOS.add(setVO);
                            }
                            projectSetVO.setChildren(projectSetVOS);
                        }
                    });
                    return CommonResponse.success("查询参照数据成功！",pageData);
                }
            }

            //过滤指定资金管控状态状态的项目 modify by cj 2022年9月9日14:37:54
            if(StringUtils.isNotBlank(_con.getString("excludeCapitalStatus"))){
                param.getParams().put("capitalStatus", new Parameter(QueryParam.NOT_IN, _con.getString("excludeCapitalStatus")));
            }
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }else {
            return CommonResponse.success("查询参照数据成功！",new Page<>(0, 0, 0));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ProjectSetPoolEntity> page = projectSetService.queryPage(param, false);
        IPage<ProjectPoolSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectPoolSetVO.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 大企业进度管理专用项目参照
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refProjectSetProgressData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectVO>> refProjectSetProgressData(@RequestParam(defaultValue = "1") int pageNumber,
                                                                      @RequestParam(defaultValue = "10") int pageSize,
                                                                      String condition,
                                                                      String searchObject,
                                                                      String searchText) {
        /** 模糊搜索配置字段示例 */
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getFuzzyFields().add("orgName");
        param.getFuzzyFields().add("buildUnitName");
        param.getFuzzyFields().add("projectDepartmentName");
        param.getOrderMap().put("createTime", "desc");
        Long orgId = InvocationInfoProxy.getOrgId();

        /**
         * 根据需求 修改为
         * 查询 “执行项目”
         * 2022-7-27
         * */
        param.getParams().put("attribute",new Parameter(QueryParam.EQ,2));

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotBlank(condition)){
            JSONObject _con = JSONObject.parseObject(condition);

            String parentProjectId = _con.getString("parentProjectId");
            if(StringUtils.isNotBlank(parentProjectId)){
                param.getParams().put("parentProjectId",new Parameter(QueryParam.EQ,parentProjectId));
            }
            if(StringUtils.isNotBlank(_con.getString("orgId"))){
                orgId = _con.getLong("orgId");
            }
            //调入项目不要组织过滤
            String rangeType = _con.getString("range");
            if (StringUtils.isNotEmpty(rangeType)){
                if (RANGE_ALL.equals(rangeType)){
                    IPage<ProjectSetPoolEntity> page = projectSetService.queryPage(param, false);
                    IPage<ProjectPoolSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
                    pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectPoolSetVO.class));
                    List<ProjectPoolSetVO> records = pageData.getRecords();
                    IPage<ProjectVO> progressPageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
                    List<ProjectVO> progressProject = new ArrayList<>();
                    if(ListUtil.isNotEmpty(records)){
                        for (ProjectPoolSetVO projectSetVO : records){
                            QueryParam queryParam = new QueryParam();
                            queryParam.getParams().put("parentProjectId", new Parameter(QueryParam.EQ, projectSetVO.getId()));
                            List<ProjectSetPoolEntity> entityList = projectSetService.queryList(queryParam, false);

                            if(ListUtil.isNotEmpty(entityList)) {
                                List<ProjectPoolSetVO> projectSetVOS = new ArrayList<>();
                                for (int i = 0; i < entityList.size(); i++) {
                                    ProjectPoolSetVO setVO = BeanMapper.map(entityList.get(i), ProjectPoolSetVO.class);
                                    projectSetVOS.add(setVO);
                                }
                                projectSetVO.setChildren(projectSetVOS);
                            }

                            ProjectVO map = BeanMapper.map(projectSetVO, ProjectVO.class);
                            map.setProjectName(projectSetVO.getName());
                            map.setBillCode(projectSetVO.getCode());
                            map.setLeader(projectSetVO.getProjectManagementId());
                            map.setStartDate(projectSetVO.getPlanStartDate());
                            map.setEndDate(projectSetVO.getPlanEndDate());
                            progressProject.add(map);
                        }
                    }
                    progressPageData.setRecords(progressProject);
                    return CommonResponse.success("查询参照数据成功！",progressPageData);
                }
            }
        }
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }else {
            return CommonResponse.success("查询参照数据成功！",new Page<>(0, 0, 0));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ProjectSetPoolEntity> page = projectSetService.queryPage(param, false);
        IPage<ProjectPoolSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ProjectPoolSetVO> projectPoolSetVOS = BeanMapper.mapList(page.getRecords(), ProjectPoolSetVO.class);
        pageData.setRecords(projectPoolSetVOS);

        IPage<ProjectVO> progressPageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<ProjectVO> progressProject = new ArrayList<>();
        for (ProjectPoolSetVO projectSetVO : projectPoolSetVOS){
            ProjectVO map = BeanMapper.map(projectSetVO, ProjectVO.class);
            map.setProjectName(projectSetVO.getName());
            map.setBillCode(projectSetVO.getCode());
            map.setLeader(projectSetVO.getProjectManagementId());
            map.setStartDate(projectSetVO.getPlanStartDate());
            map.setEndDate(projectSetVO.getPlanEndDate());
            progressProject.add(map);
        }
        progressPageData.setRecords(progressProject);
        return CommonResponse.success("查询参照数据成功！",progressPageData);
    }



    /**
     * @Description 父子项目参照
     *
     * @Return void
     */
    @RequestMapping(value = "/refProjectParentData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectPoolSetVO>> refProjectParentData(@RequestParam(defaultValue = "1") int pageNumber,
                                                                     @RequestParam(defaultValue = "10") int pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        /** 模糊搜索配置字段示例 */
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        param.getFuzzyFields().add("orgName");
        fuzzyFields.add("code");
        param.getFuzzyFields().add("buildUnitName");
        param.getFuzzyFields().add("projectDepartmentName");
        param.getOrderMap().put("createTime", "desc");
        Long orgId = InvocationInfoProxy.getOrgId();
        /** 租户隔离 */

        /**
         * 2022年8月18日
         * 不要树形结构
         *
         * */



        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotBlank(condition)){
            JSONObject _con = JSONObject.parseObject(condition);

            String parentProjectId = _con.getString("parentProjectId");
            if(StringUtils.isNotBlank(parentProjectId)){
                param.getParams().put("parentProjectId",new Parameter(QueryParam.EQ,parentProjectId));
            }
            if(StringUtils.isNotBlank(_con.getString("orgId"))){
                orgId = _con.getLong("orgId");
            }
        }

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }else {
            return CommonResponse.success("查询参照数据成功！",new Page<>(0, 0, 0));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ProjectSetPoolEntity> page = projectSetService.queryPage(param, false);
        IPage<ProjectPoolSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectPoolSetVO.class));
        List<ProjectPoolSetVO> records = pageData.getRecords();
        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 父项目参照
     *
     * @Return void
     */
    @RequestMapping(value = "/refParent", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectPoolSetVO>> refParent(@RequestParam(defaultValue = "1") int pageNumber,
                                                                     @RequestParam(defaultValue = "10") int pageSize,
                                                                     String condition,
                                                                     String searchObject,
                                                                     String searchText) {
        /** 模糊搜索配置字段示例 */
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setPageIndex(pageNumber);
        param.setPageSize(pageSize);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");
        param.getFuzzyFields().add("buildUnitName");
        param.getFuzzyFields().add("projectDepartmentName");
        param.getOrderMap().put("createTime", "desc");
        Long orgId = InvocationInfoProxy.getOrgId();
        /** 租户隔离 */
        if(StringUtils.isNotBlank(condition)){
            JSONObject _con = JSONObject.parseObject(condition);
            if(StringUtils.isNotBlank(_con.getString("orgId"))){
                orgId = _con.getLong("orgId");
            }
        }
        /** 父项目 */
        param.getParams().put("attribute",new Parameter(QueryParam.EQ,1));

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }else {
            return CommonResponse.success("查询参照数据成功！",new Page<>(0, 0, 0));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ProjectSetPoolEntity> page = projectSetService.queryPage(param, false);
        IPage<ProjectPoolSetVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectPoolSetVO.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Author mrsir_wxp
     * @Date 2022/3/21 根据项目部id查询项目信息
     * @Description queryProjectByProjectDepartmentId
     * @Param [sourceId]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.market.vo.ProjectRegisterVO>
     */
    @GetMapping("queryProjectByProjectDepartmentId")
    @ResponseBody
    public CommonResponse<ProjectPoolSetVO> queryProjectByProjectDepartmentId(@RequestParam(value = "projectDepartmentId") Long projectDepartmentId) {
        ProjectSetPoolEntity entity = projectSetService.selectById(projectDepartmentId);
        if(entity == null){
            QueryParam param = new QueryParam();
            param.getParams().put("project_department_id",new Parameter(QueryParam.EQ,projectDepartmentId));
            List<ProjectSetPoolEntity> list = projectSetService.queryList(param,false);
            if(ListUtil.isNotEmpty(list)){
                entity = list.get(0);
            }
        }
        ProjectPoolSetVO vo = null;
        if(entity!=null){
            vo = BeanMapper.map(entity,ProjectPoolSetVO.class);
        }
        return CommonResponse.success("查询成功！", vo);
    }


    /**
     * 郑州一建  将项目池数据同步到项目扩展表
     * @return
     */
    @GetMapping("syncZZYJProject")
    @ResponseBody
    public CommonResponse<String> syncZZYJProject() {
        QueryParam param = new QueryParam();
        boolean has = true;
        int pageNum = 1;
        param.setPageSize(100);
        while (has){
            IPage<ProjectSetPoolEntity> page = projectSetService.queryPage(param,false);
            List<ProjectSetPoolEntity> rec = page.getRecords();
            if(ListUtil.isNotEmpty(rec)){
                for (ProjectSetPoolEntity poolEntity : rec) {
                    ProjectSetExPoolEntity exPoolEntity = projectSetExPoolService.selectById(poolEntity.getId());
                    if(exPoolEntity!=null){
                        int version = exPoolEntity.getVersion();
                        exPoolEntity = BeanMapper.map(poolEntity,ProjectSetExPoolEntity.class);
                        exPoolEntity.setVersion(version);
                    }else {
                        exPoolEntity = BeanMapper.map(poolEntity,ProjectSetExPoolEntity.class);
                    }
                    projectSetExPoolService.saveOrUpdateNoES(exPoolEntity);
                }
                /** 查询下一页 */
                pageNum++;
                param.setPageIndex(pageNum);
            }else {
                has = false;
            }
        }
        return CommonResponse.success();
    }


    @RequestMapping(value = "/getTotalInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> getTotalInfo(@RequestBody QueryParam param) {
        JSONObject res = new JSONObject();


        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("code");
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("buildUnitName");
        param.getFuzzyFields().add("projectDepartmentName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        /** 要求主表有orgId字段，保存单据所属组织 */
        if(commonOrgIds.size() != 0) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }else if(departmentIds.size() != 0){
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }else {
            res.put("total",0);
            res.put("fatherTotal",0);
            res.put("eTotal",0);
            return CommonResponse.success(res);
        }

        //郑州一建 项目池列表总数取值  根据父子项目过滤
        List<ProjectSetPoolEntity> setEntities = projectSetService.queryList(param,false);
        if(CollectionUtils.isNotEmpty(setEntities)){
            List<ProjectDesktopSubParentVO> projectDesktopSubVOS = BeanMapper.mapList(setEntities,ProjectDesktopSubParentVO.class);
            List<ProjectDesktopSubParentVO> projectDesktopSubVOSParent = TreeNodeBUtil.buildTree(projectDesktopSubVOS);// 主子项目的返回数据
            res.put("total",projectDesktopSubVOSParent.size());
        }else{
            res.put("total",0);
        }

//        res.put("total",setEntities.size());
        if(param.getParams().get("attribute")!=null){
            Parameter parameter = param.getParams().get("attribute");
            if("1".equals(parameter.getValue())){
                res.put("fatherTotal",setEntities.size());
                res.put("eTotal",0);
            }else {
                res.put("fatherTotal",0);
                res.put("eTotal",setEntities.size());
            }
        }else {
            param.getParams().put("attribute",new Parameter(QueryParam.EQ,1));
            setEntities = projectSetService.queryList(param,false);
            res.put("fatherTotal",setEntities.size());
            param.getParams().put("attribute",new Parameter(QueryParam.EQ,2));
            setEntities = projectSetService.queryList(param,false);
            res.put("eTotal",setEntities.size());
        }
        return CommonResponse.success(res);
    }


    /**
     * 根据当前组织，如果当前组织是项目，则部查询其对应的项目
     *
     * @return
     */
    @GetMapping("getProjectByCurrentOrg")
    public CommonResponse<ProjectPoolSetVO> getProjectByCurrentOrg(){
        QueryParam param = new QueryParam();
        param.getParams().put("projectDepartmentId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getOrgId()));
        List<ProjectSetPoolEntity> entities = projectSetService.queryList(param,false);
        if(ListUtil.isNotEmpty(entities)){
            return CommonResponse.success(BeanMapper.map(entities.get(0),ProjectPoolSetVO.class));
        }
        return CommonResponse.error("没有查到项目");
    }

}

