package com.ejianc.foundation.share.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.vo.ItemDocApplyDetailVO;
import com.ejianc.foundation.share.vo.LabsubItemVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.foundation.share.bean.LabsubItemEntity;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 劳务分包档案
 *
 * @author generator
 *
 */
public interface ILabsubItemService extends IBaseService<LabsubItemEntity> {
    /**
     * 根据分类ID更改其下物料成本科目
     *
     * @param categoryId
     * @return
     */
    CommonResponse updateByCategoryId(Long categoryId, String subjectIds,
                                      String subjectNames, String subjectRelations);

    CommonResponse<JSONObject> excelProsubImport(HttpServletRequest request);

    CommonResponse<LabsubItemVO> saveOrUpdateLabsubItem(LabsubItemVO saveorUpdateVO);

    List<LabsubItemVO> queryLabsubItemList(Page<LabsubItemVO> page, QueryWrapper wrapper);

    void updateSubject(String subjectIds, String subjectNames, List<Long> ids, String subjectRelations);

    CommonResponse<List<Map<String, Object>>> queryWholeTreeItemsById(String idStr, String type);

    List<LabsubItemVO> queryAllByCategoryIds(List<Long> allCategoryIds, Long tenantId, Integer detailEnabled);

    void getDefaultSubject(List<LabsubItemVO> resp, Long projectId);

    List<LabsubItemVO> queryAllByCodes(List<String> itemCodes);

    void generateCodeBatch(List<ItemDocApplyDetailVO> empCodeList);
}
