package com.ejianc.foundation.share.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.PartDocDetailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.share.bean.PartDocDetailEntity;
import com.ejianc.foundation.share.service.IPartDocDetailService;

/**
 * 分部分项档案-子表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("partDocDetail")
public class PartDocDetailController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IPartDocDetailService service;

    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "EJCBT202504000019";


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PartDocDetailVO> saveOrUpdate(@RequestBody PartDocDetailVO saveOrUpdateVO) {
        return service.saveOrUpdate(saveOrUpdateVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PartDocDetailVO> queryDetail(Long id) {
    	PartDocDetailEntity entity = service.selectById(id);
    	PartDocDetailVO vo = BeanMapper.map(entity, PartDocDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * 导出的模板 的下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "PartDocDetail-export.xlsx", "分部分项导入模板");
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PartDocDetailVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PartDocDetailVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        List<Long> ids = vos.stream().map(PartDocDetailVO::getId).collect(Collectors.toList());
        for(Long billId:ids){
            //是否被其他单据引用
            CommonResponse<String>  res = billTypeApi.checkQuote(BILL_CODE,billId);
            logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
            if(!res.isSuccess()) {//单据被下游单据引用
                throw new BusinessException("存在被引用的档案，请处理后再删除！");
            }
        }
        service.removeByIds(ids,true);

        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询分类树
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @SuppressWarnings("rawtypes")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");

        if(param.getParams().containsKey("partDocId")){
            Object obj = param.getParams().get("partDocId").getValue();
            /** 处理condition */
            Long partDocId = Long.parseLong((String) obj);
            param.getParams().put("partDocId", new Parameter(QueryParam.EQ, partDocId));
        }else {
            param.getParams().put("partDocId", new Parameter(QueryParam.EQ, 999));
        }


        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("name", "asc");
        param.getOrderMap().put("partDocId", "asc");
        List<PartDocDetailEntity> list = service.queryList(param, false);
        List<Map> resultMapList = BeanMapper.mapList(list, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }
//    /**
//     * @param param
//     * @Description queryList 查询分类树
//     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
//     */
//    @SuppressWarnings("rawtypes")
//    @RequestMapping(value = "/queryPartTree", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<JSONObject> queryPartTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
//                                                    String condition,
//                                                    String searchObject,
//                                                    String searchText) {
//
//        QueryParam param = new QueryParam();
//        param.setPageSize(pageSize);
//        param.setPageIndex(pageNumber);
//        param.setSearchText(searchText);
//        param.setSearchObject(searchObject);
//        /** 租户隔离 */
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//
//
//        List<String> fuzzyFields = param.getFuzzyFields();
//        fuzzyFields.add("code");
//        fuzzyFields.add("name");
//        /** 租户隔离 */
//
//        if(StringUtils.isNotEmpty(param.getRelyCondition())){
//            /** 处理condition */
//            JSONObject _con = JSONObject.parseObject(param.getRelyCondition());
//            if(_con.containsKey("partDocId")){
//                param.getParams().put("partDocId", new Parameter(QueryParam.EQ, _con.getLong("partDocId")));
//            }
//        }
//
//
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        param.getOrderMap().put("name", "asc");
//        param.getOrderMap().put("partDocId", "asc");
//        List<PartDocDetailEntity> list = service.queryList(param, false);
//        List<Map> resultMapList = BeanMapper.mapList(list, Map.class);
//        JSONObject jsonObject = new JSONObject();
//        jsonObject.put("records", ResultAsTree.createTreeData(resultMapList));
//        return CommonResponse.success("查询列表数据成功！", jsonObject);
//    }


    /**
     * 查询租户下所有的模块树
     *
     * @return
     */
    @GetMapping("/queryPartTree")
    @ResponseBody
    public List<Map<String, Object>> queryPartTree(
                                                   @RequestParam String relyCondition,
                                                   String searchObject,
                                                   String searchText) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        /** 租户隔离 */

        if(StringUtils.isNotEmpty(relyCondition)){
            String[] split = relyCondition.split("=");
            /** 处理condition */
            param.getParams().put("partDocId", new Parameter(QueryParam.EQ, split[1]));
        }else{
            param.getParams().put("partDocId", new Parameter(QueryParam.EQ, "999"));
        }


        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("name", "asc");
        param.getOrderMap().put("partDocId", "asc");
        List<PartDocDetailEntity> list = service.queryList(param, false);
        List<Map> resultMapList = new ArrayList<Map>();

        for(PartDocDetailEntity entity:list) {
            Map map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getName());
            map.put("code", entity.getCode());
            map.put("parentId", entity.getParentId());
            map.put("innerCode", entity.getInnerCode());
            resultMapList.add(map);
        }

        List<Map<String, Object>> result =  ResultAsTree.createTreeData(resultMapList);
        return result;
    }



    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PartDocDetailEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PartDocDetail-export.xlsx", beans, response);
    }

    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response,Long partDocId) {
        return service.excelImport(request,response, partDocId);
    }

    @RequestMapping(value = "/saveImportExcel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<PartDocDetailVO> importVOS) {
        return CommonResponse.success((String) service.saveImportExcel(request, importVOS));
    }






    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPartDocDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PartDocDetailVO>> refPartDocDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PartDocDetailEntity> page = service.queryPage(param,false);
        IPage<PartDocDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PartDocDetailVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


//    @GetMapping(value = "/partDocTree")
//    public List<Map<String, Object>> lazyCategoryTree(@RequestParam(required = false) String condition,
//                                                      @RequestParam(required = false) Long pid,
//                                                      @RequestParam(required = false) String searchText) {
//
//        Map<String,Object> params = new HashMap<>();
//        params.put("tenantId", InvocationInfoProxy.getTenantid());
//        if(StringUtils.isNotBlank(searchText)) {
//            params.put("searchText", searchText);
//        }
//        if(null != pid) {
//            params.put("parentId", pid);
//        }
//        LambdaQueryWrapper<PartDocDetailEntity> lambda = Wrappers.<PartDocDetailEntity>lambdaQuery();
//        List<PartDocDetailEntity> dataList = service.list(params);
//        List<Long> parentIds = dataList.stream().map(SceneQualityCheckCategoryVO::getId).collect(Collectors.toList());
//        List<Map> map = BeanMapper.mapList(dataList, Map.class);
//        map.forEach(l-> {
//            if(l.get("leafFlag").equals(false)){
//                l.put("children", new ArrayList<>());
//            } else {
//                l.put("children", null);
//            }
//        });
//        if (null != pid && parentIds.size()>0){
//            params.remove("parentId");
//            params.put("parentIds", parentIds);
//            List<SceneQualityCheckCategoryVO> dataLists = service.queryList(params);
//            List<Map> map2 = BeanMapper.mapList(dataLists, Map.class);
//            map.addAll(map2);
//        }
//        return ResultAsTree.createTreeData(map);
//    }

}
