package com.ejianc.foundation.share.controller.param;

import com.alibaba.fastjson.JSONObject;

public class YnsbjMaterialAndEquipParam extends YnsbjBaseParam {

	private static final long serialVersionUID = 1L;

	private String categoryName;

	private String categoryCode;

	private String materialAndEquipId;

	private String materialAndEquipName;

	private String materialAndEquipCode;

	private String materialAndEquipModel;

	private String unitName;

	public String getCategoryName() {
		return categoryName;
	}

	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}

	public String getCategoryCode() {
		return categoryCode;
	}

	public void setCategoryCode(String categoryCode) {
		this.categoryCode = categoryCode;
	}

	public String getMaterialAndEquipId() {
		return materialAndEquipId;
	}

	public void setMaterialAndEquipId(String materialAndEquipId) {
		this.materialAndEquipId = materialAndEquipId;
	}

	public String getMaterialAndEquipName() {
		return materialAndEquipName;
	}

	public void setMaterialAndEquipName(String materialAndEquipName) {
		this.materialAndEquipName = materialAndEquipName;
	}

	public String getMaterialAndEquipCode() {
		return materialAndEquipCode;
	}

	public void setMaterialAndEquipCode(String materialAndEquipCode) {
		this.materialAndEquipCode = materialAndEquipCode;
	}

	public String getMaterialAndEquipModel() {
		return materialAndEquipModel;
	}

	public void setMaterialAndEquipModel(String materialAndEquipModel) {
		this.materialAndEquipModel = materialAndEquipModel;
	}

	public String getUnitName() {
		return unitName;
	}

	public void setUnitName(String unitName) {
		this.unitName = unitName;
	}

	public YnsbjMaterialAndEquipParam() {
	}

	public YnsbjMaterialAndEquipParam(String categoryName, String categoryCode, String materialAndEquipId,
			String materialAndEquipName, String materialAndEquipCode, String materialAndEquipModel, String unitName) {
		super();
		this.categoryName = categoryName;
		this.categoryCode = categoryCode;
		this.materialAndEquipId = materialAndEquipId;
		this.materialAndEquipName = materialAndEquipName;
		this.materialAndEquipCode = materialAndEquipCode;
		this.materialAndEquipModel = materialAndEquipModel;
		this.unitName = unitName;
	}

	public static YnsbjMaterialAndEquipParam packageYnsbjMaterialAndEquipParam(JSONObject jsonObject) {
		String CODE = jsonObject.getString("CODE");  //MDM唯一标识
		String UUID = jsonObject.getString("UUID");
		String categoryName = jsonObject.getString("CATEGORYNAME"); //材料分类名称
		String categoryCode = jsonObject.getString("CATEGORYCODE"); //材料分类编码
		JSONObject SPECIALITYCODES = jsonObject.getJSONObject("SPECIALITYCODES");

		String materialAndEquipId = SPECIALITYCODES.getString("A01@A01009"); //材料主键ID
		String materialAndEquipName = SPECIALITYCODES.getString("A01@A01010"); //材料名称
		String materialAndEquipCode = SPECIALITYCODES.getString("A01@A01011"); //材料编码
		String materialAndEquipModel = SPECIALITYCODES.getString("A01@A01012"); //材料规格型号
		String unitName = SPECIALITYCODES.getString("A01@A01013"); //计量单位
		
		YnsbjMaterialAndEquipParam materialAndEquipParam = new YnsbjMaterialAndEquipParam(categoryName, categoryCode, materialAndEquipId, materialAndEquipName, 
				materialAndEquipCode, materialAndEquipModel, unitName);
		materialAndEquipParam.setMasterDataCode(CODE);
		materialAndEquipParam.setUuid(UUID);
		return materialAndEquipParam;
	}
	
}
