/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.ejianc.foundation.share.bean.ProjectWbsTemplateDetailEntity;
import com.ejianc.foundation.share.bean.ProjectWbsTemplateEntity;
import com.ejianc.foundation.share.mapper.ProjectWbsTemplateMapper;
import com.ejianc.foundation.share.service.IProjectWbsTemplateDetailService;
import com.ejianc.foundation.share.service.IProjectWbsTemplateService;
import com.ejianc.foundation.share.utils.TreeNodeBUtil;
import com.ejianc.foundation.share.vo.ProjectWbsTemplateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectWbsTemplateService")
public class ProjectWbsTemplateServiceImpl
extends BaseServiceImpl<ProjectWbsTemplateMapper, ProjectWbsTemplateEntity>
implements IProjectWbsTemplateService {
    private static final String BILL_CODE = "PROJECT_WBS_TMPL";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProjectWbsTemplateDetailService detailService;

    @Override
    public ProjectWbsTemplateVO saveOrUpdate(ProjectWbsTemplateVO saveOrUpdateVO) {
        ProjectWbsTemplateEntity entity = (ProjectWbsTemplateEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProjectWbsTemplateEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setEnabled("1");
        }
        super.saveOrUpdate((Object)entity, false);
        List<ProjectWbsTemplateDetailEntity> detailList = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            for (ProjectWbsTemplateDetailEntity detail : detailList) {
                map.put(detail.getShadowId(), detail.getId());
            }
            for (ProjectWbsTemplateDetailEntity detail : detailList) {
                detail.setParentId((Long)map.get(detail.getTpid()));
            }
            List resultMapList = BeanMapper.mapList(detailList, Map.class);
            List treeData = ResultAsTree.createTreeData((List)resultMapList);
            List<Map<String, Object>> ListCodeDate = this.creatCode(treeData, null);
            ArrayList<ProjectWbsTemplateDetailEntity> entities = new ArrayList<ProjectWbsTemplateDetailEntity>();
            this.treeToList(ListCodeDate, entities);
            this.detailService.saveOrUpdateBatch(entities);
        }
        return (ProjectWbsTemplateVO)BeanMapper.map((Object)((Object)entity), ProjectWbsTemplateVO.class);
    }

    @Override
    public ProjectWbsTemplateVO queryDetail(Long id, boolean hasChildren) {
        ProjectWbsTemplateEntity entity = (ProjectWbsTemplateEntity)((Object)this.selectById(id));
        ProjectWbsTemplateVO resp = (ProjectWbsTemplateVO)BeanMapper.map((Object)((Object)entity), ProjectWbsTemplateVO.class);
        Collections.sort(resp.getDetailList(), (o1, o2) -> {
            String[] parts1 = o1.getTreeIndex().split("\\.");
            String[] parts2 = o2.getTreeIndex().split("\\.");
            int minLength = Math.min(parts1.length, parts2.length);
            for (int i = 0; i < minLength; ++i) {
                int part2;
                int part1 = Integer.parseInt(parts1[i]);
                if (part1 < (part2 = Integer.parseInt(parts2[i]))) {
                    return -1;
                }
                if (part1 <= part2) continue;
                return 1;
            }
            return Integer.compare(parts1.length, parts2.length);
        });
        if (hasChildren) {
            resp.setDetailList(TreeNodeBUtil.buildTree((List)resp.getDetailList()));
        }
        return resp;
    }

    private void treeToList(List<Map<String, Object>> list, List<ProjectWbsTemplateDetailEntity> entities) {
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                this.treeToList((List)ypd.get("children"), entities);
            }
            entities.add((ProjectWbsTemplateDetailEntity)((Object)BeanMapper.map(ypd, ProjectWbsTemplateDetailEntity.class)));
        }
    }

    private List<Map<String, Object>> creatCode(List<Map<String, Object>> list, String innerCode) {
        for (Map<String, Object> ypd : list) {
            if (StringUtils.isNotEmpty((CharSequence)innerCode)) {
                ypd.put("innerCode", innerCode + "|" + ypd.get("id"));
            } else {
                ypd.put("innerCode", ypd.get("id"));
            }
            if (ypd.get("children") == null) continue;
            List<Map<String, Object>> child = this.creatCode((List)ypd.get("children"), ypd.get("innerCode").toString());
            ypd.put("children", child);
        }
        return list;
    }
}

