package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.ProsubCategoryEntity;
import com.ejianc.foundation.share.bean.ProsubItemEntity;
import com.ejianc.foundation.share.service.IProsubCategoryService;
import com.ejianc.foundation.share.service.IProsubItemService;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.share.vo.RefProsubCategoryVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 专业分包分类
 *
 * @author generator
 */
@Controller
@RequestMapping("/majorSub/category")
public class ProsubCategoryController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProsubCategoryService service;
    @Autowired
    private IProsubItemService prosubItemService;
    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProsubCategoryVO> saveOrUpdate(@RequestBody ProsubCategoryVO saveorUpdateVO) {
        CommonResponse<ProsubCategoryVO> response = service.saveOrUpdateProsubCategory(saveorUpdateVO);
        return response;
    }
    /**
     * 绑定科目
     *
     * @param map
     * @return
     */
    @RequestMapping(value = "/bandSubject", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> bandSubject(@RequestBody Map map) {
        List<Long> ids = (List<Long>) map.get("ids");
        String subjectIds =  map.get("subjectIds").toString();
        String subjectNames =  map.get("subjectNames").toString();
        String subjectRelations = map.get("subjectRelations").toString();
        service.updateSubject(subjectIds,subjectNames,ids,subjectRelations);
        return CommonResponse.success("绑定成功!");
    }
    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProsubCategoryVO> queryDetail(Long id) {
        ProsubCategoryEntity entity = service.selectById(id);
        ProsubCategoryVO vo = BeanMapper.map(entity, ProsubCategoryVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProsubCategoryVO> vos) {
        CommonResponse<String> msg = service.deleteById(vos);
        return msg;
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        List<ProsubCategoryVO> dataList = service.queryProsubCategoryList(param);
        List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l-> {
            if(l.get("isLeaf").equals(false)){
                l.put("children", new ArrayList<>());
            }
        });
        List<Map<String, Object>> treeData = ResultAsTree.createTreeData(resultMapList);
        return CommonResponse.success(treeData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ProsubCategoryEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>(list.size());
        beans.put("records", list);
        ExcelExport.getInstance().export("ProsubCategory-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 专业分包分类树
     * @Return void
     */
    @RequestMapping(value = "/refProsubCategoryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> refProsubCategoryData( Integer pageNumber, Integer pageSize,
                                                                            String condition,
                                                                            String searchObject,
                                                                            String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().add("detail_name");
        param.getFuzzyFields().add("detail_code");
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
        }
        try {
            QueryWrapper wrapper = changeToQueryWrapper(param);
            List<Map> list = service.queryMajorSubList(wrapper);
            if (StringUtils.isNotEmpty(searchText) && CollectionUtils.isNotEmpty(list)){
                Set<Long> parentIds = new HashSet<>();
                ArrayList<Long> ids = new ArrayList<>();
                List<String> innerCodeList = list.stream().map(map -> String.valueOf(map.get("inner_code"))).collect(Collectors.toList());
                innerCodeList.forEach(innerCode->{
                    String[] innerCodeArr = innerCode.split("\\|");
                    List<String> innerCodeSplit = Arrays.asList(innerCodeArr);
                    if(innerCodeSplit.size() > 1){
                        innerCodeSplit.forEach(t->{
                            parentIds.add(Long.valueOf(t));
                        });
                        ids.add(Long.valueOf(innerCodeSplit.get(innerCodeSplit.size()-1)));
                    } else {
                        Long pIdOrId = Long.valueOf(innerCodeSplit.get(0));
                        parentIds.add(pIdOrId);
                        ids.add(pIdOrId);
                    }
                });
                QueryWrapper searchWrapper =  new QueryWrapper();
                //查询本上
                searchWrapper.in("id", parentIds);
                if(CollectionUtils.isNotEmpty(ids)){
                    ids.forEach(
                            id->{
                                searchWrapper.or();
                                //查询下级
                                searchWrapper.like("inner_code", id + "|" );
                            }
                    );
                    list = service.queryMajorSubList(searchWrapper);
                }
            }
            List<Map> listMap=new ArrayList<>();
            for (Map map : list) {
                Map map1 = new HashMap<>();
                map1.put("detailName",map.get("detail_name"));
                map1.put("detailCode",map.get("detail_code"));
                map1.put("unitName",map.get("unit_name"));
                map1.put("jobContent",map.get("job_content"));
                map1.put("priceType",map.get("price_type"));
                map1.put("id",map.get("id"));
                map1.put("remarks",map.get("remarks"));
                map1.put("parentId",map.get("parentId"));
                map1.put("flag",map.get("flag"));
                listMap.add(map1);
            }
            List<Map<String, Object>> treeData = ResultAsTree.createTreeData(listMap);
            return  CommonResponse.success("查询参照数据成功！",treeData);
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * @param
     * @Description 专业分包分类树
     * @Return void
     */
    @RequestMapping(value = "/refProsubCategoryTreeData", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> refProsubCategoryTreeData( Integer pageNumber,  Integer pageSize,
                                                                String condition,
                                                                String searchObject,
                                                                String searchText) {
        CommonResponse<List<Map<String, Object>>> listCommonResponse = refProsubCategoryData(pageNumber, pageSize, condition, searchObject, searchText);
        return null == listCommonResponse ? null : listCommonResponse.getData();
    }

    /**
     * 参照异步（懒加载）树----专业分包分类树
     *
     * @param condition
     * @param searchText lazyProsubCategoryTree
     * @return
     */
    @RequestMapping(value = "/lazyProSubCategoryTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> lazyProsubCategoryTree(@RequestParam(required = false) Integer pageNumber, @RequestParam(required = false) Integer pageSize,
                                                            String condition,
                                                            String searchObject,
                                                            String searchText,
                                                            Long pid
    ) {
        QueryParam param = new QueryParam();
        if (pageSize != null) {
            param.setPageSize(pageSize);
        }
        if (pageNumber != null) {
            param.setPageIndex(pageNumber);
        }
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.setFuzzyFields(Arrays.asList("categoryCode", "categoryName", "remarks"));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (pid != null) {
            param.getParams().put("parent_id", new Parameter(QueryParam.EQ, pid));
        }else if(StringUtils.isNotBlank(condition) && null == pid){
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
            Object categoryIdObj = con.get("categoryId");
            if (null != categoryIdObj) {
                List<Long> asList = new ArrayList<>();
                String categoryId = ((String) categoryIdObj);
                if (categoryId.indexOf(",") > 0) {
                    String[] strings = categoryId.split(",");
                    for(String str : strings){
                        asList.add(Long.valueOf(str));
                    }
                } else {
                    asList.add(Long.valueOf(categoryId));
                }
                if(StringUtils.isNotBlank(searchText)){
                    List<ProsubCategoryEntity> categoryVOS = service.queryListByPids(asList);
                    asList = categoryVOS.stream().map(ProsubCategoryEntity::getId).collect(Collectors.toList());
                }
                param.getParams().put("id", new Parameter(QueryParam.IN, asList));
            }
        }
        List<ProsubCategoryEntity> prosubCategoryEntities = service.queryList(param, false);
        List<RefProsubCategoryVO> prosubCategoryVOS = BeanMapper.mapList(prosubCategoryEntities, RefProsubCategoryVO.class);
        List<Map> map = BeanMapper.mapList(prosubCategoryVOS, Map.class);
        List<Map<String, Object>> treeData = ResultAsTree.createTreeData(map);
        if (CollectionUtils.isNotEmpty(treeData)) {
            map.forEach(item -> {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("parent_id", new Parameter(QueryParam.EQ, item.get("id")));
                List<ProsubCategoryEntity> prosubCategoryEntities1 = service.queryList(queryParam);
                if (CollectionUtils.isNotEmpty(prosubCategoryEntities1)) {
                    item.put("isLeaf", false);
                } else {
                    item.put("isLeaf", true);
                }
            });
        }
        return treeData;
    }


    /**
     * @Author wangyouchun
     * @Date 2021/12/8 专业分包分类导入模板下载
     * @Description download
     * @Param [request, response]
     * @Return void
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "prosub-category-import.xlsx", "专业分包分类导入模板");
    }


    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        CommonResponse<JSONObject> response = service.excelImport(request);
        return response;
    }

    @RequestMapping(value = "/saveImportExcelProsubCategory", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcelProsubCategory(@RequestBody List<ProsubCategoryEntity> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error("导入的数据为空！");
        }
        List<ProsubCategoryEntity> toSave = new ArrayList<>();
        importVos.forEach(importVO -> {
            ProsubCategoryEntity entity = BeanMapper.map(importVO, ProsubCategoryEntity.class);
            entity.setOrgId(sessionManager.getUserContext().getOrgId());
            entity.setOrgName(sessionManager.getUserContext().getOrgName());
            toSave.add(entity);
        });
        service.saveBatch(toSave, toSave.size());
        return CommonResponse.success("保存成功！");
    }
}
