package com.ejianc.foundation.support.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.controller.SupplierController;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.share.vo.SupplyBankVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 银行账户实体
 *
 * @author generator
 */
@RestController
@RequestMapping("bankAccount")
public class BankAccountController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillTypeApi billTypeApi;


    private static final String BILL_TYPE_CODE = "BT211028000000001";

    @Autowired
    private IBankAccountService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BankAccountVO> saveOrUpdate(@RequestBody BankAccountVO saveorUpdateVO) {
        if (saveorUpdateVO.getId() != null) {
            CommonResponse<String> res = billTypeApi.checkQuote(BILL_TYPE_CODE, saveorUpdateVO.getId());
            logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
            if (!res.isSuccess()) {
                throw new BusinessException("编辑失败！银行账户【" + saveorUpdateVO.getBankCode() + "】已使用，不允许修改！");
            }
        }
        BankAccountVO vo = service.insertOrUpdate(saveorUpdateVO);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BankAccountVO> queryDetail(Long id) {
        BankAccountEntity entity = service.selectById(id);
        BankAccountVO vo = BeanMapper.map(entity, BankAccountVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BankAccountVO> vos) {
        List<Long> ids = vos.stream().map(BankAccountVO::getId).collect(Collectors.toList());
        return CommonResponse.success(service.delete(ids));
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BankAccountVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("bankCode");
        fuzzyFields.add("bankAccount");
        fuzzyFields.add("bankNum");
        fuzzyFields.add("bankName");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("supplierName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<BankAccountEntity> page = service.queryPage(param, false);
        IPage<BankAccountVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BankAccountVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {



        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("bankCode");
        fuzzyFields.add("bankAccount");
        fuzzyFields.add("bankNum");
        fuzzyFields.add("bankName");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("supplierName");

        Map<String, Parameter> params = param.getParams();
        params.put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<BankAccountEntity> dataList = service.queryList(param);
        List<BankAccountVO> list = BeanMapper.mapList(dataList, BankAccountVO.class);
        list.forEach(vo -> {
            vo.setEnabledName(NumberUtils.INTEGER_ONE.equals(vo.getEnabled()) ? "已启用" : "已停用");
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);


        if (params.containsKey("supplierFlag") && params.get("supplierFlag").getValue().equals("1,3")) {
            ExcelExport.getInstance().export("bank-account-supplier-export.xlsx", beans, response);
        } else if (params.containsKey("supplierFlag") && params.get("supplierFlag").getValue().equals("2,3")) {
            ExcelExport.getInstance().export("bank-account-customer-export.xlsx", beans, response);
        } else {
            ExcelExport.getInstance().export("bank-account-inside-export.xlsx", beans, response);
        }
    }

    /**
     * @param condition
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refBankAccountData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BankAccountVO>> refBankAccountData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                   String condition,
                                                                   String searchObject,
                                                                   String searchText) {
        QueryParam param = new QueryParam();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("bankCode");
        fuzzyFields.add("bankAccount");
        fuzzyFields.add("bankName");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("memo");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //enabled 启用
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));

        //supplierFlag 1供应商2客户3客商
        // insideState; // 是否内部单位银行账户 1-是 0-否
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("accType")) {
                if (_con.get("accType").toString().contains("gys")) {
                    param.getParams().put("supplierFlag", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
                    param.getParams().put("insideState", new Parameter(QueryParam.EQ, 0));
                } else if (_con.get("accType").toString().contains("kh")) {
                    param.getParams().put("supplierFlag", new Parameter(QueryParam.IN, Arrays.asList(2, 3)));
                    param.getParams().put("insideState", new Parameter(QueryParam.EQ, 0));
                } else {
                    //内部单位
                    param.getParams().put("insideState", new Parameter(QueryParam.EQ, 1));
                }
            }
            if (_con.containsKey("supplierId") && _con.get("supplierId") != null) {
                param.getParams().put("supplierId", new Parameter(QueryParam.EQ, Long.valueOf(_con.get("supplierId").toString())));
            }

        }

        IPage<BankAccountEntity> page = service.queryPage(param, false);
        IPage<BankAccountVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BankAccountVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 批量启用/停用
     *
     * @param vos
     * @return
     */
    @PostMapping("/enabled")
    public CommonResponse<String> enabled(@RequestBody List<BankAccountVO> vos) {
        return CommonResponse.success(service.enabled(vos));
    }

    /**
     * 修改默认
     *
     * @param vo
     * @return
     */
    @PostMapping("/defaultFlag")
    public CommonResponse<String> defaultFlag(@RequestBody BankAccountVO vo) {
        return CommonResponse.success(service.defaultFlag(vo));
    }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "bank-account-import.xlsx", "银行账户导入模板");
    }

    /**
     * 导入模板下载---客户
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/customerDownload")
    @ResponseBody
    public void customerDownload(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "bank-account-customer-import.xlsx", "客户银行账户导入模板");
    }

    /**
     * 导入模板下载---供应商
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/supplierDownload")
    @ResponseBody
    public void supplierDownload(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "bank-account-supplier-import.xlsx", "供应商银行账户导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImport(request, response);
    }


    @RequestMapping(value = "/saveImportExcel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<BankAccountVO> importVOS) {
        return CommonResponse.success(service.saveImportExcel(request, importVOS));
    }


    /**
     * @param id      id
     * @param accType 账户类型 gys/kh/nbdw
     * @description: 根据供应商id/客户id/内部单位id查询账户
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.foundation.support.vo.BankAccountVO>
     * @author songlx
     * @date: 2022/3/28
     */
    @RequestMapping(value = "/getBankAccountByAccTypeAndId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BankAccountVO> getBankAccountByAccTypeAndId(Long id, String accType) {
        if (id == null || StringUtils.isEmpty(accType)) {
            return CommonResponse.error("供应商/客户/内部单位id或者账户类型参数不能为空！");
        }
        QueryWrapper<BankAccountEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("supplier_id", id);
        wrapper.eq("enabled", 1);
        wrapper.orderByDesc("default_flag");
        List<BankAccountEntity> list = service.list(wrapper);
        if (CollectionUtils.isEmpty(list)) {
            return CommonResponse.success("未查询到银行账户信息！");
        }
        BankAccountVO vo = BeanMapper.map(list.get(0), BankAccountVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * 修改、新增银行账号
     *
     * @param supplierVo
     * @return
     */
    @Autowired
    private SupplierController supplierController;

    @RequestMapping(value = "/saveOrUpdateBankInfo", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SupplierVO> saveOrUpdateBankInfo(@RequestBody SupplierVO supplierVo) {
        List<BankAccountVO> banks = supplierVo.getBanks();
        if (banks.size() > 0){
            for (BankAccountVO bankAccountVO : banks){
                if (bankAccountVO.getEnabled() == 1) {
                    //转换为SupplyBankVO类型，使用已有接口修改或新增
                    SupplyBankVO supplyBankVO = new SupplyBankVO();
                    supplyBankVO.setId(bankAccountVO.getOrgId());//子表的id值传不过来？？所以使用OrgId字段暂存id
                    supplyBankVO.setPid(bankAccountVO.getSupplierId());
                    supplyBankVO.setDefaultable(bankAccountVO.getDefaultFlag());
                    supplyBankVO.setBankId(bankAccountVO.getBankId());
                    supplyBankVO.setBankName(bankAccountVO.getBankName());
                    supplyBankVO.setBankCode(bankAccountVO.getBankCode());
                    supplyBankVO.setBankAccount(bankAccountVO.getBankAccount());
                    supplyBankVO.setBankNum(bankAccountVO.getBankNum());
                    supplyBankVO.setAddress(bankAccountVO.getBankAddress());
                    supplyBankVO.setCategoryId(bankAccountVO.getCategoryId());
                    supplyBankVO.setCategoryName(bankAccountVO.getCategoryName());
                    supplierController.saveOrUpdateBank(supplyBankVO);
                }
            }
        }
        return CommonResponse.success("修改银行账户信息成功！",supplierVo);
    }

    /**
     * @Description delete 批量删除银行信息，不再考虑是否默认问题，如需要考虑默认问题，
     *                   则修改：service.removeByIds(ids,true) -->  service.delete(ids);
     * @Param [ids]
     */
    @RequestMapping(value = "/deleteByIds", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> deleteByIds(@RequestBody List<Long> ids) {
        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }
}
