/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.service.impl;

import com.ejianc.foundation.share.bean.EquipmentCategoryEntity;
import com.ejianc.foundation.share.bean.MaterialCategoryEntity;
import com.ejianc.foundation.share.mapper.EquipmentCategoryMapper;
import com.ejianc.foundation.share.mapper.MaterialCategoryMapper;
import com.ejianc.foundation.share.service.IEquipmentCategoryService;
import com.ejianc.foundation.share.service.IMaterialService;
import com.ejianc.foundation.share.vo.EquipmentCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EquipmentCategoryServiceImpl
implements IEquipmentCategoryService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private EquipmentCategoryMapper equipmentCategoryMapper;
    @Autowired
    private MaterialCategoryMapper materialCategoryMapper;
    @Autowired
    private IMaterialService materialService;

    @Override
    public List<EquipmentCategoryEntity> queryList(QueryParam queryParam) {
        Map paramMap = queryParam.getParams();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        for (Map.Entry entry : paramMap.entrySet()) {
            condition.put((String)entry.getKey(), ((Parameter)entry.getValue()).getValue());
        }
        condition.put("tenantId", InvocationInfoProxy.getTenantid());
        List<EquipmentCategoryEntity> resultList = this.equipmentCategoryMapper.queryList(condition);
        return resultList;
    }

    @Override
    public EquipmentCategoryVO queryDetail(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        EquipmentCategoryEntity entity = this.equipmentCategoryMapper.queryDetail(tenantId, id);
        if (entity != null) {
            return (EquipmentCategoryVO)BeanMapper.map((Object)entity, EquipmentCategoryVO.class);
        }
        return null;
    }

    @Override
    public void update(EquipmentCategoryEntity entity) {
        this.equipmentCategoryMapper.update(entity);
        Long tenantId = InvocationInfoProxy.getTenantid();
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(entity.getId());
        List<MaterialCategoryEntity> materialCategoryEntities = this.materialCategoryMapper.queryByInnerCodes(tenantId, ids);
        ids.clear();
        materialCategoryEntities.forEach(item -> {
            ids.add(item.getId());
            this.materialService.updateByCategoryId(item.getId(), entity.getSubjectIds(), entity.getSubjectNames(), entity.getSubjectRelations());
        });
        this.materialCategoryMapper.updateSubject(tenantId, entity.getSubjectIds(), entity.getSubjectNames(), ids, entity.getSubjectRelations());
    }

    @Override
    public void save(EquipmentCategoryEntity entity) {
        this.equipmentCategoryMapper.insert(entity);
    }

    @Override
    public void insertBatch(List<EquipmentCategoryEntity> categoryEntityList) {
        if (ListUtil.isNotEmpty(categoryEntityList)) {
            ArrayList<EquipmentCategoryEntity> toInsert = new ArrayList<EquipmentCategoryEntity>();
            for (EquipmentCategoryEntity entity : categoryEntityList) {
                if (toInsert.size() > 0 && toInsert.size() % 1000 == 0) {
                    this.equipmentCategoryMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
                    toInsert = new ArrayList();
                }
                toInsert.add(entity);
            }
            if (toInsert.size() > 0) {
                this.equipmentCategoryMapper.insertBatch(InvocationInfoProxy.getTenantid(), toInsert);
            }
        }
    }

    @Override
    public List<EquipmentCategoryVO> queryListByPid(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<EquipmentCategoryEntity> EquipmentCategoryList = this.equipmentCategoryMapper.queryListByPid(tenantId, id);
        if (EquipmentCategoryList != null && EquipmentCategoryList.size() > 0) {
            return BeanMapper.mapList(EquipmentCategoryList, EquipmentCategoryVO.class);
        }
        return null;
    }

    @Override
    public void delete(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.equipmentCategoryMapper.delete(tenantId, id);
    }

    @Override
    public void updateEnabled(Integer enabled, Long tenantId, String innerCode) {
        this.equipmentCategoryMapper.updateEnabled(enabled, tenantId, innerCode);
    }

    @Override
    public List<EquipmentCategoryEntity> queryByCode(String code) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<EquipmentCategoryEntity> EquipmentCategoryVo = this.equipmentCategoryMapper.queryByCode(tenantId, code);
        return EquipmentCategoryVo;
    }

    @Override
    public List<EquipmentCategoryEntity> queryByName(String name) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        return this.equipmentCategoryMapper.queryByName(tenantId, name);
    }

    @Override
    public void insertCategoryListFromPlatform() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        this.equipmentCategoryMapper.insertCategoryListFromPlatform(tenantId);
    }

    @Override
    public List<EquipmentCategoryVO> queryListTree(Map<String, Object> params) {
        List<EquipmentCategoryEntity> dataList = this.equipmentCategoryMapper.queryListTree(params);
        if (dataList != null && dataList.size() > 0) {
            return BeanMapper.mapList(dataList, EquipmentCategoryVO.class);
        }
        return null;
    }

    @Override
    public List<EquipmentCategoryVO> queryCategoryListByIds(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<EquipmentCategoryEntity> EquipmentCategoryList = this.equipmentCategoryMapper.queryCategoryListByIds(tenantId, ids);
        if (EquipmentCategoryList != null && EquipmentCategoryList.size() > 0) {
            return BeanMapper.mapList(EquipmentCategoryList, EquipmentCategoryVO.class);
        }
        return null;
    }

    @Override
    public void delete(List<Long> ids) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        for (Long id : ids) {
            this.equipmentCategoryMapper.delete(tenantId, id);
        }
    }
}

