package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.ProjectSetPoolEntity;
import com.ejianc.foundation.share.bean.SubjectOrgCategoryEntity;
import com.ejianc.foundation.share.bean.SubjectOrgEntity;
import com.ejianc.foundation.share.service.IProjectSetService;
import com.ejianc.foundation.share.service.ISubjectOrgCategoryService;
import com.ejianc.foundation.share.service.ISubjectOrgService;
import com.ejianc.foundation.share.service.ISubjectProjectService;
import com.ejianc.foundation.share.vo.SubjectOrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 集团成本科目实体
 *
 * @author generator
 */
@Controller
@RequestMapping("subjectOrg")
public class SubjectOrgController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IBillTypeApi billTypeApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISubjectOrgService service;
    @Autowired
    private ISubjectProjectService subjectProjectService;
    @Autowired
    private ISubjectOrgCategoryService categoryService;

    @Autowired
    private IProjectSetService projectSetService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubjectOrgVO> saveOrUpdate(@RequestBody SubjectOrgVO saveorUpdateVO) {
        return service.saveOrUpdate(saveorUpdateVO);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubjectOrgVO> queryDetail(Long id) {
        SubjectOrgEntity entity = service.selectById(id);
        SubjectOrgVO vo = BeanMapper.map(entity, SubjectOrgVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @GetMapping(value = "/queryByCodeAndName")
    @ResponseBody
    public CommonResponse<SubjectOrgVO> queryByCodeAndName(@RequestParam(value = "code") String code,
                                                           @RequestParam(value = "name") String name) {
        QueryWrapper<SubjectOrgEntity> query = new QueryWrapper<>();
        query.eq("subject_code", code);
        query.eq("subject_name", name);
        SubjectOrgEntity entity = service.getOne(query);

        if(null != entity) {
            return CommonResponse.success("查询成功！", BeanMapper.map(entity, SubjectOrgVO.class));
        }

        return CommonResponse.error("配找到匹配的集团成本科目信息！");
    }


    /**
     * @Description saveOrUpdate 修改状态
     */
    @RequestMapping(value = "/updateEn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubjectOrgVO> updateEn(@RequestBody SubjectOrgVO saveorUpdateVO) {
        return service.updateEn(saveorUpdateVO);
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody SubjectOrgVO vo) {
        List<Long> ids = vo.getIds();
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                CommonResponse<String> resp = billTypeApi.checkQuote("EJCBT202206000016", id);
                if (!resp.isSuccess()) {
                    return CommonResponse.error("删除失败！" + resp.getMsg());
                }
            }
            service.removeByIds(ids);
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询分类树
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @SuppressWarnings("rawtypes")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("subjectName");
        fuzzyFields.add("subjectCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("subjectCode", "asc");
        List<SubjectOrgEntity> list = service.queryList(param, false);
        List<Map> resultMapList = BeanMapper.mapList(list, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", ResultAsTree.createTreeData(resultMapList));
        return CommonResponse.success("查询列表数据成功！", jsonObject);
    }

    /**
     * 导出的模板 的下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "subjectOrg-export.xlsx", "集团成本科目导出模板");
    }

    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(@RequestParam Long categoryId, HttpServletRequest request, HttpServletResponse response) {
        return service.excelImport(categoryId, request,response);
    }


    @RequestMapping(value = "/saveImportExcel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<SubjectOrgVO> importVOS) {
        return CommonResponse.success((String) service.saveImportExcel(request, importVOS));
    }

    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SubjectOrgEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SubjectOrg-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSubjectOrgData", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> refSubjectOrgData(@RequestParam(value = "searchText", required = false) String searchText,
                                                       @RequestParam(value = "condition", required = false) String condition,
                                                       @RequestParam(value = "relyCondition", required = false) String relyCondition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getFuzzyFields().add("subjectName");
        param.getFuzzyFields().add("subjectCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("enabled", new Parameter(QueryParam.EQ, 1));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("innerCode")) {
                param.getParams().put("innerCode", new Parameter(QueryParam.LIKE, _con.get("innerCode")));
            }
            if (_con.containsKey("categoryId")) {
                param.getParams().put("categoryId", new Parameter(QueryParam.EQ, _con.get("categoryId")));
            }

            if(null != _con.getString("projectId")) {
                //查询项目专业类型
                ProjectSetPoolEntity project = projectSetService.selectById(Long.valueOf(_con.getString("projectId")));
                if(null == project) {
                    throw new BusinessException("查询失败，未查询到当前项目信息！");
                }
                if(null == project.getSubjectOrgCategoryId()) {
                    throw new BusinessException("查询失败，当前项目未设置成本专业类型！");
                }
                if(null != project.getSubjectOrgCategoryId()) {
                    param.getParams().put("categoryId", new Parameter(QueryParam.EQ, project.getSubjectOrgCategoryId()));
                }
            }

        }

        if (StringUtils.isNotBlank(relyCondition)) {
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("categoryId", new Parameter(QueryParam.EQ, categoryId));
        }

        param.getOrderMap().put("subjectCode", "asc");

        List<SubjectOrgEntity> list = service.queryList(param, false);
        List<Long> categoryIds = new ArrayList<>(list.stream().map(SubjectOrgEntity::getCategoryId).collect(Collectors.toSet()));
        List<SubjectOrgCategoryEntity> categoryList = (List<SubjectOrgCategoryEntity>) categoryService.listByIds(categoryIds);
        Map<Long, SubjectOrgCategoryEntity> categoryMap = categoryList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        List<Map> resultMapList = new ArrayList<Map>();
        Map map = null;
        for(SubjectOrgEntity entity:list) {
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getSubjectName());
            map.put("code", entity.getSubjectCode());
            map.put("parentId", entity.getParentId());
            map.put("memo", entity.getMemo());
            map.put("innerCode", entity.getInnerCode());
            map.put("categoryId", entity.getCategoryId());
            if(categoryMap.containsKey(entity.getCategoryId())) {
                map.put("categoryName", categoryMap.get(entity.getCategoryId()).getName());
            }
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }


}
