package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.share.bean.ProjectWbsTemplateDetailEntity;
import com.ejianc.foundation.share.service.IProjectWbsTemplateDetailService;
import com.ejianc.foundation.share.vo.ProjectWbsTemplateDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 项目WBS模板子表
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("projectWbsTemplateDetail")
public class ProjectWbsTemplateDetailController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IProjectWbsTemplateDetailService service;

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @description: ProjectWbsTemplateDetailController
     * @author: 39630
     * @create: 2025/8/20 14:28
     * @Version 1.0
     **/
    @RequestMapping(value = "/refProjectWbsTemplateDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectWbsTemplateDetailVO>> refProjectWbsTemplateDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProjectWbsTemplateDetailEntity> page = service.queryPage(param,false);
        IPage<ProjectWbsTemplateDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectWbsTemplateDetailVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
