package com.ejianc.foundation.company.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.foundation.company.bean.CompanyStateDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 公司潜亏情况主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_share_company_state")
public class CompanyStateEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="choose_organization")
    private String chooseOrganization; // 选择组织
    @TableField(value="year")
    @JsonFormat(pattern = "yyyy", timezone = "GMT+8")
    private Date year; // 年份
    @TableField(value="quarter")
    private Integer quarter; // 季度
    @TableField(value="edition")
    private Integer edition; // 版本1-A,2-B,3-C,4-D,5-E,6-G
    @TableField(value="operator")
    private String operator; // 经办人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="companyStateDetailService")
    private List<CompanyStateDetailEntity> companyStateDetailList = new ArrayList<>(); // 公司潜亏情况子表
    

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getChooseOrganization() {
        return chooseOrganization;
    }

    public void setChooseOrganization(String chooseOrganization) {
        this.chooseOrganization = chooseOrganization;
    }
    public Date getYear() {
        return year;
    }

    public void setYear(Date year) {
        this.year = year;
    }
    public Integer getQuarter() {
        return quarter;
    }

    public void setQuarter(Integer quarter) {
        this.quarter = quarter;
    }
    public Integer getEdition() {
        return edition;
    }

    public void setEdition(Integer edition) {
        this.edition = edition;
    }
    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    

    public List<CompanyStateDetailEntity> getCompanyStateDetailList() {
        return companyStateDetailList;
    }

    public void setCompanyStateDetailList(List<CompanyStateDetailEntity> companyStateDetailList) {
        this.companyStateDetailList = companyStateDetailList;
    }
}
