package com.ejianc.foundation.share.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.bean.PartDocDetailEntity;
import com.ejianc.foundation.share.service.IPartDocDetailService;
import com.ejianc.foundation.share.vo.PartDocVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.foundation.share.bean.PartDocEntity;
import com.ejianc.foundation.share.service.IPartDocService;

/**
 * 分部分项档案-主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("partDoc")
public class PartDocController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IPartDocService service;
    @Autowired
    private IPartDocDetailService partDocDetailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PartDocVO> saveOrUpdate(@RequestBody PartDocVO saveOrUpdateVO) {
    	PartDocEntity entity = BeanMapper.map(saveOrUpdateVO, PartDocEntity.class);
        //校验编码重复
        LambdaQueryWrapper<PartDocEntity> lambda = Wrappers.<PartDocEntity>lambdaQuery();
        lambda.ne(saveOrUpdateVO.getId() != null,PartDocEntity::getId, saveOrUpdateVO.getId());
        lambda.eq(PartDocEntity::getCode, saveOrUpdateVO.getCode());
        List<PartDocEntity> partDocEntities = service.list(lambda);
        if (CollectionUtils.isNotEmpty(partDocEntities) && partDocEntities.size() > 0){
            throw new BusinessException("编码重复");
        }

        service.saveOrUpdate(entity, false);
    	PartDocVO vo = BeanMapper.map(entity, PartDocVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PartDocVO> queryDetail(Long id) {
    	PartDocEntity entity = service.selectById(id);
    	PartDocVO vo = BeanMapper.map(entity, PartDocVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PartDocVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PartDocVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }

        //有下级的数据不能删除
        LambdaQueryWrapper<PartDocDetailEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        List<Long> ids = vos.stream().map(PartDocVO::getId).collect(Collectors.toList());
        lambdaQueryWrapper.in(PartDocDetailEntity::getPartDocId, ids);
        List<PartDocDetailEntity> list = partDocDetailService.list(lambdaQueryWrapper);
        if (list != null && list.size() > 0){
            return CommonResponse.error("要删除的档案下有档案项，不允许删除");
        }

        service.removeByIds(vos.stream().map(PartDocVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PartDocVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();


        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("code", "asc");
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        IPage<PartDocEntity> page = service.queryPage(param,false);
        IPage<PartDocVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PartDocVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPartDocData", method = RequestMethod.GET)
    @ResponseBody
    public List<PartDocVO> refPartDocData(@RequestParam(required = false) String searchText,
                                                    @RequestParam(required = false) String condition) {
        /** 模糊搜索配置字段示例 */
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("name");
        param.setPageIndex(1);
        param.setPageSize(-1);

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        IPage<PartDocEntity> page = service.queryPage(param,false);
        List<PartDocVO> partDocVOS = BeanMapper.mapList(page.getRecords(), PartDocVO.class);

        return partDocVOS;
    }



    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PartDocEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PartDoc-export.xlsx", beans, response);
    }



    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPartData", method = RequestMethod.GET)
    @ResponseBody
    public JSONArray refBusinessScopeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                          String condition,
                                          String searchObject,
                                          String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("code");

        List<PartDocEntity> list = service.queryList(param,false);
        //转换为树形结构数据
        String jsonArray = JSONArray.toJSONString(list);

        return JSONArray.parseArray(jsonArray);
    }

    /**
     * 查询租户下所有的模块树
     *
     * @return
     */
    @GetMapping("/partTreeRefer")
    @ResponseBody
    public List<Map<String, Object>> moduleTreeRefer() {
        QueryParam queryParam = new QueryParam();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("code", "asc");
        queryParam.setOrderMap(orderMap);
        List<PartDocEntity> dataList = service.queryList(queryParam, false);
        List<Map> resultMapList = new ArrayList<Map>();
//        Map map = null;

        for(PartDocEntity entity:dataList) {
            Map map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getName());
            map.put("code", entity.getCode());
            map.put("parentId", null);
            resultMapList.add(map);
        }

        List<Map<String, Object>> result =  ResultAsTree.createTreeData(resultMapList);
        return result;
    }



}
