package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.PartDocDetailEntity;
import com.ejianc.foundation.share.bean.PartDocEntity;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.IPartDocDetailService;
import com.ejianc.foundation.share.service.IPartDocService;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.PartDocDetailVO;
import com.ejianc.foundation.share.vo.PartDocVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2020/6/30 15:03
 */
@RestController
@RequestMapping("/api/partApi/")
public class PartApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPartDocService partDocService;
    @Autowired
    private IPartDocDetailService partDocDetailService;


    /***
     *根据分部分项子表主键查询List
     */
    @PostMapping(value = "getPartDetailListByIds")
    public CommonResponse<List<PartDocDetailVO>> getPartDetailListByIds(@RequestBody PartDocVO partDocVO) {
        LambdaQueryWrapper<PartDocDetailEntity> lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(PartDocDetailEntity::getId, partDocVO.getIds());
        List<PartDocDetailEntity> list = partDocDetailService.list(lambdaQueryWrapper);

        List<PartDocDetailVO> docDetailVOS = BeanMapper.mapList(list, PartDocDetailVO.class);
        return CommonResponse.success("通过条件获取账户成功！", docDetailVOS);
    }
    /***
     *根据分部分项主表主键查询List
     */
    @PostMapping(value = "getPartListByIds")
    public CommonResponse<List<PartDocVO>> getPartListByIds(@RequestBody PartDocVO partDocVO) {
        LambdaQueryWrapper<PartDocEntity> lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(PartDocEntity::getId, partDocVO.getIds());
        List<PartDocEntity> list = partDocService.list(lambdaQueryWrapper);

        List<PartDocVO> docDetailVOS = BeanMapper.mapList(list, PartDocVO.class);
        return CommonResponse.success("通过条件获取账户成功！", docDetailVOS);
    }



}
