package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.bean.ItemDocApplyDetailEntity;
import com.ejianc.foundation.share.bean.ItemDocApplyEntity;
import com.ejianc.foundation.share.service.*;
import com.ejianc.foundation.share.vo.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 清单档案入库申请主实体
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("itemDocApply")
public class ItemDocApplyController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String PROSUB_BILL_CODE = "PROSUB_ITEM_DOC_APPLY";//此处需要根据实际修改
    private static final String LABSUB_BILL_CODE = "LABSUB_ITEM_DOC_APPLY";//此处需要根据实际修改

    @Autowired
    private IItemDocApplyService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IItemDocApplyDetailService detailService;

    @Autowired
    private IProsubCategoryService prosubCategoryService;

    @Autowired
    private ILabsubCategoryService labsubCategoryService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdateLabSub", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LabSubItemDocApplyVO> saveOrUpdateLabSub(@RequestBody LabSubItemDocApplyVO saveOrUpdateVO) {
    	ItemDocApplyEntity entity = BeanMapper.map(saveOrUpdateVO, ItemDocApplyEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(ItemDocApplyVO.APPLY_ITEM_TYPE_PROSUB.equals(saveOrUpdateVO.getApplyItemType())
                    ? PROSUB_BILL_CODE : LABSUB_BILL_CODE ,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        List<ItemDocApplyDetailEntity> empCodeList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(entity.getDetailList())) {
            //继承分类成本科目信息
            List<Long> categoryids = new ArrayList<>(entity.getDetailList().stream().map(ItemDocApplyDetailEntity::getCategoryId).collect(Collectors.toSet()));
            List<LabsubCategoryVO> categoryVOS = labsubCategoryService.queryCategoryListByIds(categoryids);
            Map<Long, LabsubCategoryVO> categoryVOMap = categoryVOS.stream().collect(Collectors.toMap(LabsubCategoryVO::getId, Function.identity()));

            LabsubCategoryVO materialCategoryVo = null;
            for(ItemDocApplyDetailEntity item : entity.getDetailList()) {
                materialCategoryVo = categoryVOMap.get(item.getCategoryId());
                item.setExtField1(materialCategoryVo.getSubjectIds());
                item.setExtField2(materialCategoryVo.getSubjectNames());
                item.setExtField3(materialCategoryVo.getSubjectRelations());

                if(StringUtils.isBlank(item.getItemCode())) {
                    empCodeList.add(item);
                }
            }
        }

        if(CollectionUtils.isNotEmpty(empCodeList)) {
            return CommonResponse.error("操作失败，存在未设置编码的清单项");
        }

//        if(CollectionUtils.isNotEmpty(empCodeList)) {
//            //自动生成编码
//            detailService.generateCodeBatch(empCodeList);
//        }

        String msg= detailService.validateLabSubItem(entity.getDetailList());
        if(StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }

    	service.saveOrUpdate(entity, false);
        LabSubItemDocApplyVO vo = BeanMapper.map(entity, LabSubItemDocApplyVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdateProSub", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProSubItemDocApplyVO> saveOrUpdateProSub(@RequestBody ProSubItemDocApplyVO saveOrUpdateVO) {
    	ItemDocApplyEntity entity = BeanMapper.map(saveOrUpdateVO, ItemDocApplyEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(ItemDocApplyVO.APPLY_ITEM_TYPE_PROSUB.equals(saveOrUpdateVO.getApplyItemType())
                    ? PROSUB_BILL_CODE : LABSUB_BILL_CODE ,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        List<ItemDocApplyDetailEntity> empCodeList = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(entity.getDetailList())) {
            //继承分类成本科目信息
            List<Long> categoryids = new ArrayList<>(entity.getDetailList().stream().map(ItemDocApplyDetailEntity::getCategoryId).collect(Collectors.toSet()));
            List<ProsubCategoryVO> categoryVOS = prosubCategoryService.queryCategoryListByIds(categoryids);
            Map<Long, ProsubCategoryVO> categoryVOMap = categoryVOS.stream().collect(Collectors.toMap(ProsubCategoryVO::getId, Function.identity()));

            ProsubCategoryVO materialCategoryVo = null;
            for(ItemDocApplyDetailEntity item : entity.getDetailList()) {
                materialCategoryVo = categoryVOMap.get(item.getCategoryId());
                item.setExtField1(materialCategoryVo.getSubjectIds());
                item.setExtField2(materialCategoryVo.getSubjectNames());
                item.setExtField3(materialCategoryVo.getSubjectRelations());

                if(StringUtils.isBlank(item.getItemCode())) {
                    empCodeList.add(item);
                }
            }
        }

        if(CollectionUtils.isNotEmpty(empCodeList)) {
            //自动生成编码
            detailService.generateCodeBatch(empCodeList);
        }

        String msg= detailService.validateProSubItem(entity.getDetailList());
        if(StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }

    	service.saveOrUpdate(entity, false);
        ProSubItemDocApplyVO vo = BeanMapper.map(entity, ProSubItemDocApplyVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryLabSubDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LabSubItemDocApplyVO> queryLabSubDetail(Long id) {
    	ItemDocApplyEntity entity = service.selectById(id);
        LabSubItemDocApplyVO vo = BeanMapper.map(entity, LabSubItemDocApplyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryProSubDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProSubItemDocApplyVO> queryProSubDetail(Long id) {
    	ItemDocApplyEntity entity = service.selectById(id);
        ProSubItemDocApplyVO vo = BeanMapper.map(entity, ProSubItemDocApplyVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ItemDocApplyVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ItemDocApplyVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ItemDocApplyVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryLabSubList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LabSubItemDocApplyVO>> queryLabSubList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("applyItemType", new Parameter(QueryParam.EQ, ItemDocApplyVO.APPLY_ITEM_TYPE_LABSUB));

        IPage<ItemDocApplyEntity> page = service.queryPage(param,false);
        IPage<LabSubItemDocApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), LabSubItemDocApplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryProSubList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProSubItemDocApplyVO>> queryProSubList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("applyItemType", new Parameter(QueryParam.EQ, ItemDocApplyVO.APPLY_ITEM_TYPE_PROSUB));

        IPage<ItemDocApplyEntity> page = service.queryPage(param,false);
        IPage<ProSubItemDocApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProSubItemDocApplyVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<ItemDocApplyEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ItemDocApply-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refItemDocApplyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ItemDocApplyVO>> refItemDocApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ItemDocApplyEntity> page = service.queryPage(param,false);
        IPage<ItemDocApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ItemDocApplyVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "item-doc-apply-import.xlsx", "清单导入模板");
    }

    /**
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelItemDocImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelItemDocImport(HttpServletRequest request) {
        return detailService.excelItemDocImport(request);
    }

}
