/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.SupplierEntity;
import com.ejianc.foundation.share.service.ISupplierService;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.bean.BankAccountEntity;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.service.IBankAccountService;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.foundation.support.vo.BankAccountVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/bankApi/"})
public class BankApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBankAccountService bankAccountService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IBankService bankService;

    @PostMapping(value={"pushToBank"})
    public CommonResponse<String> pushToBank(@RequestBody byte[] supplyByte) {
        String supplyStr = new String(supplyByte, StandardCharsets.UTF_8);
        SupplierVO supplierVO = (SupplierVO)JSONObject.parseObject((String)supplyStr, SupplierVO.class);
        supplierVO.setSocialCreditCode(supplierVO.getTaxPayerIdentifier());
        supplierVO.setEnabled(Integer.valueOf(1));
        supplierVO.setComeFrom("\u9080\u8bf7\u5165\u5e93");
        supplierVO.setInsideOrg(Boolean.valueOf(false));
        supplierVO.setGroupInOrOut("out");
        supplierVO.setSupplierFlag(Integer.valueOf(1));
        SupplierEntity se = (SupplierEntity)((Object)BeanMapper.map((Object)supplierVO, SupplierEntity.class));
        Boolean coordination = se.getCoordination();
        if (coordination == null) {
            se.setCoordination(false);
        }
        this.supplierService.saveOrUpdate((Object)se, false);
        SupplierVO vo = (SupplierVO)BeanMapper.map((Object)((Object)se), SupplierVO.class);
        List banks = supplierVO.getBanks();
        if (banks.size() != 0) {
            QueryParam params = new QueryParam();
            List collect = banks.stream().map(BaseVO::getId).collect(Collectors.toList());
            params.getParams().put("id", new Parameter("in", collect));
            List bankAccountEntityList = this.bankAccountService.queryList(params);
            if (CollectionUtils.isNotEmpty((Collection)bankAccountEntityList)) {
                return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25\uff01\u5df2\u5b58\u5728\u76f8\u540c\u8d26\u53f7\u7684\u94f6\u884c\u8d26\u6237");
            }
            this.logger.info("\u63a8\u9001\uff0c\u751f\u6210\u94f6\u884c\u8d26\u6237pushToBank--=-=-=-=-=-=----------------------------------------------{}", (Object)supplyStr);
            for (BankAccountVO bankVO : banks) {
                BankAccountEntity accountEntity = (BankAccountEntity)((Object)BeanMapper.map((Object)bankVO, BankAccountEntity.class));
                accountEntity.setOrgName(supplierVO.getApplyOrgName());
                accountEntity.setOrgId(supplierVO.getApplyOrgId());
                accountEntity.setSupplierId(supplierVO.getId());
                accountEntity.setSupplierName(supplierVO.getName());
                accountEntity.setSupplierCode(supplierVO.getCode());
                if (bankVO.getBankNum() == null) {
                    BankEntity bankEntity = (BankEntity)((Object)this.bankService.selectById(bankVO.getBankId()));
                    accountEntity.setBankNum(bankEntity.getCode());
                    accountEntity.setCategoryName(bankEntity.getBankCategoryName());
                    accountEntity.setCategoryId(bankEntity.getBankCategoryId());
                }
                accountEntity.setTenantId(999999L);
                accountEntity.setEnabled(1);
                accountEntity.setInsideState(0);
                accountEntity.setSupplierFlag(1);
                if (accountEntity.getDefaultFlag() == null) {
                    accountEntity.setDefaultFlag(0);
                }
                this.bankAccountService.saveOrUpdate((Object)accountEntity);
            }
        }
        return CommonResponse.success();
    }

    @PostMapping(value={"getBankAccountsByCondition"})
    public CommonResponse<List<BankAccountVO>> getBankAccountsByCondition(@RequestBody BankAccountVO bankAccountVO) {
        QueryWrapper bankAccountEntityQueryWrapper = new QueryWrapper();
        bankAccountEntityQueryWrapper.eq(bankAccountVO.getSupplierId() != null, (Object)"supplier_id", (Object)bankAccountVO.getSupplierId());
        bankAccountEntityQueryWrapper.in(CollectionUtils.isNotEmpty((Collection)bankAccountVO.getSupplierIds()), (Object)"supplier_id", (Collection)bankAccountVO.getSupplierIds());
        bankAccountEntityQueryWrapper.eq(bankAccountVO.getSupplierName() != null, (Object)"supplier_name", (Object)bankAccountVO.getSupplierName());
        bankAccountEntityQueryWrapper.eq(bankAccountVO.getEnabled() != null, (Object)"enabled", (Object)bankAccountVO.getEnabled());
        bankAccountEntityQueryWrapper.eq(bankAccountVO.getDefaultFlag() != null, (Object)"default_flag", (Object)bankAccountVO.getDefaultFlag());
        List list = this.bankAccountService.list((Wrapper)bankAccountEntityQueryWrapper);
        List bankAccountVOS = BeanMapper.mapList((Iterable)list, BankAccountVO.class);
        return CommonResponse.success((String)"\u901a\u8fc7\u6761\u4ef6\u83b7\u53d6\u8d26\u6237\u6210\u529f\uff01", (Object)bankAccountVOS);
    }

    @PostMapping(value={"batchSaveOrUpdBankAccount"})
    CommonResponse<String> batchSaveOrUpdBankAccount(@RequestBody List<BankAccountVO> bankAccountVOS) {
        if (CollectionUtils.isEmpty(bankAccountVOS)) {
            return CommonResponse.error((String)"\u94f6\u884c\u8d26\u53f7\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<BankAccountVO> addItems = bankAccountVOS.stream().filter(s -> s.getId() == null).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(addItems)) {
            this.bankAccountService.validate(addItems, null, null, false);
            for (BankAccountVO addItem : addItems) {
                if (!StringUtils.isNotEmpty((CharSequence)addItem.getWarnType())) continue;
                return CommonResponse.error((String)addItem.getWarnType());
            }
        }
        List bankAccountEntities = BeanMapper.mapList(bankAccountVOS, BankAccountEntity.class);
        this.bankAccountService.saveOrUpdateBatch(bankAccountEntities);
        return CommonResponse.success((String)"\u6279\u91cf\u63d2\u5165/\u66f4\u65b0\u94f6\u884c\u8d26\u6237\u6210\u529f\uff01");
    }
}

