package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.bpm.vo.BPMTaskInfoVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.controller.resp.InformationPortletContent;
import com.ejianc.foundation.share.controller.resp.InformationPortletData;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.response.CommonResponse;
import com.sun.xml.bind.marshaller.CharacterEscapeHandler;
import com.sun.xml.bind.marshaller.NoEscapeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import java.io.StringWriter;
import java.util.*;


@Component
@WebService(
        serviceName = "PortalService",
        targetNamespace = "http://pm.cni-ht.com/",
        endpointInterface = "com.ejianc.foundation.share.controller.PortalHandler")
public class PortalHandler {
    @Autowired
    private IBpmApi bpmApi;
    @Autowired
    private IEmployeeApi employeeApi;

    @Value("${common.env.base-host}")
    private String baseHost;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi orgApi;
    public PortalHandler() {
        SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
    }


    @WebMethod(operationName = "Todo")
    @WebResult(name = "TodoResponse", targetNamespace = "http://pm.cni-ht.com/")
    public String todo(
            @WebParam(name = "userCode", targetNamespace = "http://pm.cni-ht.com/")
                    String userCode) throws DatatypeConfigurationException, UnsupportedEncodingException { // 接收字符串参数
//        try {

//        String userCode1 = wrapper.getUserCode();
//        logger.info("userId2----"+userId2);
        logger.info("userCode----"+userCode);
        Long userId = 1247777316689256450L;
        getUserContext(userId);
        //根据oa的用户编码查询用户信息
        CommonResponse<EmployeeVO> oneBySourceId = employeeApi.getByMobilePhone(userCode);
        if (!oneBySourceId.isSuccess()){
            logger.info("查询用户信息失败");
            throw new BusinessException("查询用户信息失败！");
        }
            logger.info("888---");

            EmployeeVO employeeVO = oneBySourceId.getData();
        Long tenantid = InvocationInfoProxy.getTenantid();
        getUserContext(employeeVO.getUserId());
            logger.info("999---");


        InformationPortletData data = new InformationPortletData();
        //根据
        Map<String,Object> queryParam = new HashMap<>();
        queryParam.put("userId",employeeVO.getUserId());
//        queryParam.put("userId",userId);
        queryParam.put("pageIndex",1);
        queryParam.put("pageSize",10);
        CommonResponse<List<BPMTaskInfoVO>> approveList = bpmApi.queryWaitList(queryParam);
        logger.info("approveList:{}",JSONObject.toJSON(approveList));
        if (!approveList.isSuccess()){
            logger.info("查询待办信息失败");
            throw new BusinessException("查询待办信息失败!");
        }

        List<BPMTaskInfoVO> records = approveList.getData();
        // 构建示例数据（实际应根据参数查询）
        List<InformationPortletContent> items = new ArrayList<>();
        String encodedUserCode = URLEncoder.encode(userCode, "UTF-8");
        for(BPMTaskInfoVO bpmTaskInfoVO : records){
            InformationPortletContent item = new InformationPortletContent();
            item.setContentTitle(bpmTaskInfoVO.getName());

            //设置单点url
//            String url = "https://pm.cni-ht.com/portal/zhhtsso/login?userCode=" + encodedUserCode + "&appCode=" + "APP-2005210008";
            String url = String.format(
                    "https://pm.cni-ht.com/portal/zhhtsso/login?userCode=%s&appCode=%s",
                    encodedUserCode,
                    "APP-2005210008"
            );
            logger.info("url---"+url);
            item.setContentUrl(url);


//            try {
                XMLGregorianCalendar cal = DatatypeFactory.newInstance()
                        .newXMLGregorianCalendar(new GregorianCalendar());
                item.setDateTime(cal);
//            } catch (Exception e) {
//
//                logger.info("111");
//                logger.info(e.getMessage());
//                e.printStackTrace();
//            }
            items.add(item);
        }

//        items.add(createItem("数据显示标题", "点击跳转Url", paramMap));
//        items.add(createItem("", "", paramMap)); // 空数据项

        data.setItems(items.toArray(new InformationPortletContent[0]));
        data.setTotal(items.size());
        logger.info("0000---");
        logger.info("items:{}",JSONObject.toJSON(items));

        return convertToXml(data);
//        } catch (Exception e) {
//            logger.info("222");
//            logger.info(e.getMessage());
//            return generateSoapFault("SERVER", "处理请求时发生错误");
//        }
    }
    private String generateSoapFault(String code, String message) {
        return "<soap:Fault xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">" +
                "<faultcode>" + code + "</faultcode>" +
                "<faultstring>" + message + "</faultstring>" +
                "</soap:Fault>";
    }

    private void getUserContext(Long userId) {
        JSONObject userContext = getToken(userId);
        StringBuilder authtoken = new StringBuilder();
        authtoken.append("userType=").append(userContext.get("userType"))
                .append(";userCode=").append(userContext.get("userCode"))
                .append(";orgId=").append(userContext.get("orgId"))
                .append(";tenantid=").append(userContext.get("tenantid"))
                .append(";token=").append(userContext.get("token"))
                .append(";u_logints=").append(userContext.get("u_logints"))
                .append(";u_usercode=").append(userContext.get("u_usercode"))
                .append(";userId=").append(userContext.get("userId"));

        if(authtoken.length() > 0) {
            InvocationInfoProxy.setExtendAttribute("authority", authtoken.toString());
        }
        if(null != userContext) {
            InvocationInfoProxy.setTenantid(userContext.getLong("tenantid"));
            InvocationInfoProxy.setUserid(userContext.getLong("userId"));
            InvocationInfoProxy.setUsercode(userContext.getString("userCode"));
            InvocationInfoProxy.setOrgId(userContext.getLong("orgId"));

        }
    }

    //    private InformationPortletContent createItem(String title, String url,
//                                                 Map<String, String> params) {
//        InformationPortletContent item = new InformationPortletContent();
//        item.setContentTitle(title);
//        item.setContentUrl(url);
//        item.setEmpID(params.getOrDefault("userId", ""));
//
//        try {
//            XMLGregorianCalendar cal = DatatypeFactory.newInstance()
//                    .newXMLGregorianCalendar(new GregorianCalendar());
//            item.setDateTime(cal);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        return item;
//    }

    private JSONObject getToken(Long userId) {
    if(null != baseHost) {
        String initContextUrl = baseHost + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
        if(null != InvocationInfoProxy.getUserid()) {
            initContextUrl = initContextUrl + "&userId="+userId;
        }
        String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);

        CommonResponse<JSONObject> userContextResponse = JSON.parseObject(responseStr, CommonResponse.class);
        try {
            if(userContextResponse.isSuccess()) {
                return userContextResponse.getData().getJSONObject("userContext");
            }
        } catch (Exception e) {
            logger.error("初始化异步任务上下文异常：",e);
            return null;
        }
    }
    return null;
}
    // 添加内部类禁止转义
    private static class NoEscapeHandler implements CharacterEscapeHandler {
        public void escape(char[] ch, int start, int length,
                           boolean isAttVal, Writer writer) throws IOException {
            writer.write(ch, start, length);
        }
    }
    private String convertToXml(InformationPortletData data) {
        try {
            JAXBContext context = JAXBContext.newInstance(InformationPortletData.class);
            Marshaller marshaller = context.createMarshaller();

            // 关键配置
            marshaller.setProperty(Marshaller.JAXB_ENCODING, "UTF-8");
            marshaller.setProperty("com.sun.xml.bind.characterEscapeHandler",
                    new NoEscapeHandler());
//            marshaller.setProperty(Marshaller.JAXB_FRAGMENT, true);
//            marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
//            marshaller.setProperty(Marshaller.JAXB_SCHEMA_LOCATION, " ");

            StringWriter sw = new StringWriter();
            marshaller.marshal(data, sw);

            return sw.toString();
        } catch (Exception e) {
            throw new RuntimeException("XML生成失败", e);
        }
    }

    private Map<String, String> parseParams(String paramStr) {
        Map<String, String> params = new HashMap<>();
        if (paramStr != null) {
            String[] pairs = paramStr.split("&");
            for (String pair : pairs) {
                String[] kv = pair.split("=");
                if (kv.length == 2) {
                    params.put(kv[0], kv[1]);
                }
            }
        }
        return params;
    }
}