package com.ejianc.foundation.share.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.share.bean.ProsubItemEntity;
import com.ejianc.foundation.share.service.IProsubCategoryService;
import com.ejianc.foundation.share.service.IProsubItemService;
import com.ejianc.foundation.share.vo.ProsubCategoryVO;
import com.ejianc.foundation.share.vo.ProsubItemVO;
import com.ejianc.foundation.share.vo.SubjectProjectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/shareProsubApi/")
public class ProsubApi {

    @Autowired
    private IProsubCategoryService prosubCategoryService;

    @Autowired
    private IProsubItemService prosubItemService;

    /**
     * @Author xuannl
     * @Date 2022/04/18 根据id查询
     * @Param [id]
     * @Return
     */
    @GetMapping(value = "queryProsubItemByIds")
    CommonResponse<List<ProsubItemVO>> queryProsubItemById(@RequestParam(value = "ids") List<Long> ids){
        QueryWrapper<ProsubItemEntity> wrapper = new QueryWrapper<>();
        wrapper.in("id",ids);
        List<ProsubItemEntity> entitys = prosubItemService.list(wrapper);
        if(null != entitys && entitys.size() > 0){
            return CommonResponse.success(BeanMapper.mapList(entitys, ProsubItemVO.class));
        }
        return CommonResponse.error("查询失败,未查到相关数据。");
    }

    /**
     * @Author xuannl
     * @Date 2022/04/18 根据id查询
     * @Param [id]
     * @Return
     */
    @GetMapping(value = "queryProsubItemByIdsNew")
    CommonResponse<List<ProsubItemVO>> queryProsubItemByIdsNew(
            @RequestParam(value = "ids") List<Long> ids,
            @RequestParam(value = "projectId", required = false) Long projectId){
        List<ProsubItemVO> resp = null;
        QueryWrapper<ProsubItemEntity> wrapper = new QueryWrapper<>();
        wrapper.in("id",ids);
        List<ProsubItemEntity> entitys = prosubItemService.list(wrapper);
        if(null != entitys && entitys.size() > 0){
            resp = BeanMapper.mapList(entitys, ProsubItemVO.class);
            if(null != projectId) {
                prosubItemService.getDefaultSubject(resp, projectId);
            }
            return CommonResponse.success(resp);
        }
        return CommonResponse.error("查询失败,未查到相关数据。");
    }
    /**
     * @Author xuannl
     * @Date 2022/04/18 根据id查询
     * @Param [id]
     * @Return
     */
    @PostMapping(value = "getProsubItemByIdsNew")
    @ResponseBody
    CommonResponse<List<ProsubItemVO>> getProsubItemByIdsNew(
            @RequestBody SubjectProjectVO subjectProjectVO){
        List<ProsubItemVO> resp = null;
        QueryWrapper<ProsubItemEntity> wrapper = new QueryWrapper<>();
        wrapper.in("id",subjectProjectVO.getIds());
        List<ProsubItemEntity> entitys = prosubItemService.list(wrapper);
        if(null != entitys && entitys.size() > 0){
            resp = BeanMapper.mapList(entitys, ProsubItemVO.class);
            if(null != subjectProjectVO.getProjectId()) {
                prosubItemService.getDefaultSubject(resp, subjectProjectVO.getProjectId());
            }
            return CommonResponse.success(resp);
        }
        return CommonResponse.error("查询失败,未查到相关数据。");
    }

    @GetMapping("queryCategoryListByIds")
    public CommonResponse<List<ProsubCategoryVO>> queryCategoryListByIds(@RequestParam(value = "ids", required = false) List<Long> ids) {
        List<ProsubCategoryVO> list = prosubCategoryService.queryCategoryListByIds(ids);
        return CommonResponse.success("查询成功！", list);
    }

    @GetMapping("queryCategoryListByIdsNew")
    public CommonResponse<List<ProsubCategoryVO>> queryCategoryListByIdsNew(
            @RequestParam(value = "ids", required = false) List<Long> ids,
            @RequestParam(value = "projectId", required = false) Long projectId) {
        List<ProsubCategoryVO> list = prosubCategoryService.queryCategoryListByIds(ids);
        if(null != projectId) {
            prosubCategoryService.getDefaultSubject(list, projectId);
        }
        return CommonResponse.success("查询成功！", list);
    }

    /**
     * 根据编码集合查询档案列表
     * @Author zhangwx
     * @param codeList
     * @return
     */
    @GetMapping("queryItemListByCodes")
    public CommonResponse<List<ProsubItemVO>> queryItemListByCodes(@RequestParam(value = "codeList") List<String> codeList) {
        QueryWrapper<ProsubItemEntity> wrapper = new QueryWrapper<>();
        wrapper.in("trawling_code", codeList);
        List<ProsubItemEntity> entitys = prosubItemService.list(wrapper);
        if(null != entitys && entitys.size() > 0){
            return CommonResponse.success(BeanMapper.mapList(entitys, ProsubItemVO.class));
        }
        return CommonResponse.error("查询失败,未查到相关数据。");
    }

    /**
     * 根据编码集合查询档案列表
     * @Author zhangwx
     * @param codeList
     * @return
     */
    @GetMapping("queryItemListByCodesNew")
    public CommonResponse<List<ProsubItemVO>> queryItemListByCodesNew(
            @RequestParam(value = "codeList") List<String> codeList,
            @RequestParam(value = "projectId", required = false) Long projectId) {
        List<ProsubItemVO> resp = null;
        QueryWrapper<ProsubItemEntity> wrapper = new QueryWrapper<>();
        wrapper.in("trawling_code", codeList);
        List<ProsubItemEntity> entitys = prosubItemService.list(wrapper);
        if(null != entitys && entitys.size() > 0){
            resp = BeanMapper.mapList(entitys, ProsubItemVO.class);
            if(null != projectId) {
                prosubItemService.getDefaultSubject(resp, projectId);
            }
            return CommonResponse.success(resp);
        }
        return CommonResponse.error("查询失败,未查到相关数据。");
    }
}
