package com.ejianc.foundation.support.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.bean.BankCategoryEntity;
import com.ejianc.foundation.support.bean.BankEntity;
import com.ejianc.foundation.support.service.IBankCategoryService;
import com.ejianc.foundation.support.service.IBankService;
import com.ejianc.foundation.support.vo.BankCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 银行类别实体
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("bankCategory")
public class BankCategoryController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    //此处需要根据实际修改
    private static final String BILL_CODE = "SUPPORT_BANK_CATEGORY_CODE";
    
    @Autowired
    private IBankCategoryService service; 

    @Autowired
    private IBankService bankService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BankCategoryVO> saveOrUpdate(@RequestBody BankCategoryVO saveorUpdateVO) {
    	BankCategoryEntity entity = BeanMapper.map(saveorUpdateVO, BankCategoryEntity.class);
    	if((entity.getId() == null || entity.getId() == 0) && StringUtils.isBlank(entity.getCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 银行类别编码已存在唯一性校验
        if (StringUtils.isNotEmpty(entity.getCode())) {
            QueryWrapper<BankCategoryEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("code", entity.getCode());
            queryWrapper.ne(entity.getId() != null, "id", entity.getId());
            int count = service.count(queryWrapper);
            if (count > 0) {
                throw new BusinessException("保存失败！银行类别编码已存在");
            }
        }
    	service.saveOrUpdate(entity, false);
    	//更新右表银行类别名称
    	if (saveorUpdateVO.getId()!=null){
            bankService.updateCategoryNameByCategoryId(saveorUpdateVO.getId(),saveorUpdateVO.getName());
        }
    	BankCategoryVO vo = BeanMapper.map(entity, BankCategoryVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BankCategoryVO> queryDetail(Long id) {
    	BankCategoryEntity entity = service.selectById(id);
    	BankCategoryVO vo = BeanMapper.map(entity, BankCategoryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        LambdaQueryWrapper<BankEntity> lambda = Wrappers.<BankEntity>lambdaQuery();
        lambda.in(BankEntity::getBankCategoryId, ids);
        lambda.eq(BankEntity::getDr, 0);
        lambda.eq(BankEntity::getTenantId, InvocationInfoProxy.getTenantid());
        List<BankEntity> entities = bankService.list(lambda);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(entities)) {
            return CommonResponse.error("删除失败！该银行类别已存在银行档案信息，不允许删除");
        } else {
            service.removeByIds(ids, false);
            return CommonResponse.success("删除成功");
        }
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BankCategoryVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<BankCategoryEntity> page = service.queryPage(param,false);
        IPage<BankCategoryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BankCategoryVO.class));
        
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refBankCategoryData", method = RequestMethod.GET)
    @ResponseBody
    public List<BankCategoryEntity> refBankCategoryData(@RequestParam(required=false) String searchText) {
        QueryParam param = new QueryParam();

        if(InvocationInfoProxy.getTenantid() !=null){
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        }else {
            param.getParams().put("tenantId", new Parameter(QueryParam.EQ, "999999"));
        }

        if(StringUtils.isNotBlank(searchText)) {
            param.getParams().put("name", new Parameter(QueryParam.LIKE, searchText));
        }
        param.getOrderMap().put("code", "asc");
        List<BankCategoryEntity> dataList = service.queryList(param,false);
        if(ListUtil.isEmpty(dataList)){
            return new ArrayList<>();
        }
        return dataList;
     }

    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return service.excelImport(request,response);
    }
    /**
     * 导出的模板 的下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "bankCategory-export.xlsx", "银行档案分类导出模板");
    }

    @RequestMapping(value = "/saveImportExcel", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<BankCategoryVO> importVOS) {
        return CommonResponse.success(service.saveImportExcel(request, importVOS));
    }

}
