/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.share.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.bpm.vo.BPMTaskInfoVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.controller.resp.InformationPortletContent;
import com.ejianc.foundation.share.controller.resp.InformationPortletData;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.response.CommonResponse;
import com.sun.xml.bind.marshaller.CharacterEscapeHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

@Component
@WebService(serviceName="PortalService", targetNamespace="http://pm.cni-ht.com/", endpointInterface="com.ejianc.foundation.share.controller.PortalHandler")
public class PortalHandler {
    @Autowired
    private IBpmApi bpmApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;

    public PortalHandler() {
        SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext((Object)this);
    }

    @WebMethod(operationName="Todo")
    @WebResult(name="TodoResponse", targetNamespace="http://pm.cni-ht.com/")
    public String todo(@WebParam(name="userCode", targetNamespace="http://pm.cni-ht.com/") String userCode) throws DatatypeConfigurationException, UnsupportedEncodingException {
        this.logger.info("userCode----" + userCode);
        Long userId = 1247777316689256450L;
        this.getUserContext(userId);
        CommonResponse oneBySourceId = this.employeeApi.getByMobilePhone(userCode);
        if (!oneBySourceId.isSuccess()) {
            this.logger.info("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            throw new BusinessException("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
        this.logger.info("888---");
        EmployeeVO employeeVO = (EmployeeVO)oneBySourceId.getData();
        Long tenantid = InvocationInfoProxy.getTenantid();
        this.getUserContext(employeeVO.getUserId());
        this.logger.info("999---");
        InformationPortletData data = new InformationPortletData();
        HashMap<String, Number> queryParam = new HashMap<String, Number>();
        queryParam.put("userId", employeeVO.getUserId());
        queryParam.put("pageIndex", 1);
        queryParam.put("pageSize", 10);
        CommonResponse approveList = this.bpmApi.queryWaitList(queryParam);
        this.logger.info("approveList:{}", JSONObject.toJSON((Object)approveList));
        if (!approveList.isSuccess()) {
            this.logger.info("\u67e5\u8be2\u5f85\u529e\u4fe1\u606f\u5931\u8d25");
            throw new BusinessException("\u67e5\u8be2\u5f85\u529e\u4fe1\u606f\u5931\u8d25!");
        }
        List records = (List)approveList.getData();
        ArrayList<InformationPortletContent> items = new ArrayList<InformationPortletContent>();
        String encodedUserCode = URLEncoder.encode(userCode, "UTF-8");
        for (BPMTaskInfoVO bpmTaskInfoVO : records) {
            InformationPortletContent item = new InformationPortletContent();
            item.setContentTitle(bpmTaskInfoVO.getName());
            String url = String.format("https://pm.cni-ht.com/portal/zhhtsso/login?userCode=%s&appCode=%s", encodedUserCode, "APP-2005210008");
            this.logger.info("url---" + url);
            item.setContentUrl(url);
            XMLGregorianCalendar cal = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
            item.setDateTime(cal);
            items.add(item);
        }
        data.setItems(items.toArray(new InformationPortletContent[0]));
        data.setTotal(items.size());
        this.logger.info("0000---");
        this.logger.info("items:{}", JSONObject.toJSON(items));
        return this.convertToXml(data);
    }

    private String generateSoapFault(String code, String message) {
        return "<soap:Fault xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><faultcode>" + code + "</faultcode><faultstring>" + message + "</faultstring></soap:Fault>";
    }

    private void getUserContext(Long userId) {
        JSONObject userContext = this.getToken(userId);
        StringBuilder authtoken = new StringBuilder();
        authtoken.append("userType=").append(userContext.get((Object)"userType")).append(";userCode=").append(userContext.get((Object)"userCode")).append(";orgId=").append(userContext.get((Object)"orgId")).append(";tenantid=").append(userContext.get((Object)"tenantid")).append(";token=").append(userContext.get((Object)"token")).append(";u_logints=").append(userContext.get((Object)"u_logints")).append(";u_usercode=").append(userContext.get((Object)"u_usercode")).append(";userId=").append(userContext.get((Object)"userId"));
        if (authtoken.length() > 0) {
            InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authtoken.toString());
        }
        if (null != userContext) {
            InvocationInfoProxy.setTenantid((Long)userContext.getLong("tenantid"));
            InvocationInfoProxy.setUserid((Long)userContext.getLong("userId"));
            InvocationInfoProxy.setUsercode((String)userContext.getString("userCode"));
            InvocationInfoProxy.setOrgId((Long)userContext.getLong("orgId"));
        }
    }

    private JSONObject getToken(Long userId) {
        if (null != this.baseHost) {
            String initContextUrl = this.baseHost + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
            if (null != InvocationInfoProxy.getUserid()) {
                initContextUrl = initContextUrl + "&userId=" + userId;
            }
            String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);
            CommonResponse userContextResponse = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
            try {
                if (userContextResponse.isSuccess()) {
                    return ((JSONObject)userContextResponse.getData()).getJSONObject("userContext");
                }
            }
            catch (Exception e) {
                this.logger.error("\u521d\u59cb\u5316\u5f02\u6b65\u4efb\u52a1\u4e0a\u4e0b\u6587\u5f02\u5e38\uff1a", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private String convertToXml(InformationPortletData data) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{InformationPortletData.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("com.sun.xml.bind.characterEscapeHandler", (Object)new NoEscapeHandler());
            StringWriter sw = new StringWriter();
            marshaller.marshal((Object)data, (Writer)sw);
            return sw.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("XML\u751f\u6210\u5931\u8d25", e);
        }
    }

    private Map<String, String> parseParams(String paramStr) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (paramStr != null) {
            String[] pairs;
            for (String pair : pairs = paramStr.split("&")) {
                String[] kv = pair.split("=");
                if (kv.length != 2) continue;
                params.put(kv[0], kv[1]);
            }
        }
        return params;
    }

    private static class NoEscapeHandler
    implements CharacterEscapeHandler {
        private NoEscapeHandler() {
        }

        public void escape(char[] ch, int start, int length, boolean isAttVal, Writer writer) throws IOException {
            writer.write(ch, start, length);
        }
    }
}

