package com.ejianc.business.signaturemanage.api;

import com.ejianc.business.signaturemanage.hystrix.SealManageHystrix;
import com.ejianc.business.signaturemanage.vo.ManagementVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name = "ejc-signaturemanage-web", url = "${common.env.feign-client-url}", path = "ejc-signaturemanage-web", fallback = SealManageHystrix.class)
public interface ISealManageApi {

    /**
     * 查询公司下的印章列表
     *
     * @param companyName
     * @return
     */
    @PostMapping(value = "/api/sealManager/querySealsByCompanyName")
    CommonResponse<List<ManagementVO>> querySealsByCompanyName(@RequestParam(value = "companyName") String companyName);


    /**
     * 查询所有内部企业的印章列表
     *
     * @return
     */
    @PostMapping(value = "/api/sealManager/queryAllSeal")
    CommonResponse<List<ManagementVO>> queryAllSeal();
}
