package com.ejianc.business.signaturemanage.api;


import com.ejianc.business.signaturemanage.hystrix.SignatureManageHystrix;
import com.ejianc.business.signaturemanage.vo.InitSignatureVO;
import com.ejianc.business.signaturemanage.vo.PrivateSignUrlVO;
import com.ejianc.business.signaturemanage.vo.SignMgrVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

@FeignClient(name = "ejc-signaturemanage-web", url = "${common.env.feign-client-url}", path = "ejc-signaturemanage-web", fallback = SignatureManageHystrix.class)
public interface ISignatureManageApi {


    /**
     * 发起签章
     *
     * @param signMgrVO
     * @return
     */
    @PostMapping(value = "/api/signaturemanage/initiateSignature")
    CommonResponse<SignMgrVO> initiateSignature(@RequestBody SignMgrVO signMgrVO);


    /**
     * 契约锁，发起方状态回调
     *
     * @param map
     * @param httpServletRequest
     * @param httpServletResponse
     * @return
     */
    @PostMapping(value = "/api/signaturemanage/qysCallBack/organizer")
    CommonResponse<String> organizer(@RequestParam Map<String, String> map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse);


    /**
     * 发起签章
     * 1.创建合同文档
     * 2.创建合同
     * 3.获取下一个待签章的人员列表
     * 4.推送消息通知
     *
     * @param initSignatureVO 发起签章VO
     * @return contractId
     */
    @PostMapping(value = "/api/signaturemanage/sendSignature")
    CommonResponse<Long> initiateSignature(@RequestBody InitSignatureVO initSignatureVO);


    /**
     * 获取私有云合同签署短链接
     *
     * @param privateSignUrlVO
     * @return privateSignUrl
     */
    @PostMapping(value = "/api/signaturemanage/getPrivateSignUrl")
    CommonResponse<String> privateSignUrl(@RequestBody PrivateSignUrlVO privateSignUrlVO);

}
