package com.ejianc.business.signaturemanage.hystrix;

import com.ejianc.business.signaturemanage.api.ISignatureManageApi;
import com.ejianc.business.signaturemanage.vo.InitSignatureVO;
import com.ejianc.business.signaturemanage.vo.PrivateSignUrlVO;
import com.ejianc.business.signaturemanage.vo.SignMgrVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;


/**
 * 模板服务降级处理
 *
 * @author baipengyan
 * @Description: 签章管理服务降级处理
 */
@Component
public class SignatureManageHystrix implements ISignatureManageApi {


    /**
     * 发起签章
     *
     * @param signMgrVO
     * @return
     */
    @Override
    public CommonResponse<SignMgrVO> initiateSignature(SignMgrVO signMgrVO) {
        return CommonResponse.error("网络问题，操作失败！");
    }

    /**
     * 契约锁，发起方状态回调
     *
     * @param map
     * @param httpServletRequest
     * @param httpServletResponse
     * @return
     */
    @Override
    public CommonResponse<String> organizer(Map<String, String> map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return CommonResponse.error("网络问题，操作失败！");
    }

    /**
     * 发起签章
     * 1.创建合同文档
     * 2.创建合同
     * 3.获取下一个待签章的人员列表
     * 4.推送消息通知
     *
     * @param initSignatureVO 发起签章VO
     * @return contractId
     */
    @Override
    public CommonResponse<Long> initiateSignature(InitSignatureVO initSignatureVO) {
        return CommonResponse.error("网络问题，操作失败！");
    }

    /**
     * 获取私有云合同签署短链接
     *
     * @param privateSignUrlVO
     * @return privateSignUrl
     */
    @Override
    public CommonResponse<String> privateSignUrl(PrivateSignUrlVO privateSignUrlVO) {
        return CommonResponse.error("网络问题，操作失败！");
    }
}
