package com.ejianc.business.signaturemanage.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 签章管理-签署方子表
 *
 * @author generator
 */
public class SignMgrSignatoryVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private java.lang.Integer signatureType; // 签署方类型：0-内部单位，1-外部单位

    private java.lang.String tenantName; // 签约主体名称
    private java.lang.String tenantType; // 签约主体类型：COMPANY（外部企业），PERSONAL（个人）

    private java.lang.String receiverName; // 接收人姓名
    private java.lang.String contact; // 接收人手机号

    private java.lang.Long signatureId; // 签署方Id，我们平台内的签署方id（外部单位为空）
    private java.lang.String signatureName; // 签署方名称
    private java.lang.String signatureContact; // 签署方手机号

    private java.lang.Integer signOrder; // 签署顺序,前置设置1，后置逐渐增大，无序设置相同
    private java.lang.String signActionType; // 签署动作类型:CORPORATE（企业签 章），PERSONAL（个人签字），LP（法 定代表人签字）
    private java.lang.String name; // 签署动作名称,根据签署动作类型填写
    private java.lang.String sourceSealId; // 印章id第三方系统返回的）
    private java.lang.String sourceSealName; // 印章name（第三方系统返回的）
    private java.lang.String sealId; // 平台印章id
    private java.lang.String sealName; // 平台印章name
    private java.lang.String signatureUserIds; // 印章使用平台用户id范围（静态）多个逗号分隔

    private java.lang.String signatoryNo; // 签署方编号
    private java.lang.String actionNo; // 签署动作编号，唯一


    private java.lang.Long actualSignatoryId; // 实际签署方Id，我们平台内的签署方id（外部单位为空）
    private java.lang.String actualSignatoryName; // 实际签署人
    private java.lang.String actualSignatoryContact; // 实际签署人联系方式
    private java.lang.Integer sealSignOrder; // 签章顺序,前置设置1，后置逐渐增大，无序设置相同
    private java.lang.Integer jobStatus; // 0-待激活，1-待签章，2-已完成
    private java.lang.Integer signResult; // 已签章（已完成）-1，已退回（已拒签）-2，已撤回-3，已过期-4，其他-5
    private java.lang.String mark; // 备注，描述签署状态
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date startTime; // 开始时间：状态由待激活变为待签章，可以开始签署动作的时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date endTime; // 结束时间：状态为完成签署动作的时间
    private java.lang.Long pid; // 签章管理表id


    /**
     * 签署方类型：0-内部单位，1-外部单位
     */
    public java.lang.Integer getSignatureType() {
        return signatureType;
    }

    /**
     * 签署方类型：0-内部单位，1-外部单位
     */
    public void setSignatureType(java.lang.Integer signatureType) {
        this.signatureType = signatureType;
    }

    /**
     * 签约主体名称
     */
    public java.lang.String getTenantName() {
        return tenantName;
    }

    /**
     * 签约主体名称
     */
    public void setTenantName(java.lang.String tenantName) {
        this.tenantName = tenantName;
    }

    /**
     * 签约主体类型：COMPANY（外部企业），PERSONAL（个人）
     */
    public java.lang.String getTenantType() {
        return tenantType;
    }

    /**
     * 签约主体类型：COMPANY（外部企业），PERSONAL（个人）
     */
    public void setTenantType(java.lang.String tenantType) {
        this.tenantType = tenantType;
    }

    public String getReceiverName() {
        return receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public String getContact() {
        return contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    /**
     * 签署方Id，我们平台内的签署方id（外部单位为空）
     */
    public java.lang.Long getSignatureId() {
        return signatureId;
    }

    /**
     * 签署方Id，我们平台内的签署方id（外部单位为空）
     */
    public void setSignatureId(java.lang.Long signatureId) {
        this.signatureId = signatureId;
    }

    /**
     * 签署方名称
     */
    public java.lang.String getSignatureName() {
        return signatureName;
    }

    /**
     * 签署方名称
     */
    public void setSignatureName(java.lang.String signatureName) {
        this.signatureName = signatureName;
    }

    /**
     * 签署方手机号
     */
    public String getSignatureContact() {
        return signatureContact;
    }

    /**
     * 签署方手机号
     */
    public void setSignatureContact(String signatureContact) {
        this.signatureContact = signatureContact;
    }

    /**
     * 签署顺序,前置设置1，后置逐渐增大，无序设置相同
     */
    public java.lang.Integer getSignOrder() {
        return signOrder;
    }

    /**
     * 签署顺序,前置设置1，后置逐渐增大，无序设置相同
     */
    public void setSignOrder(java.lang.Integer signOrder) {
        this.signOrder = signOrder;
    }

    /**
     * 签署动作类型:CORPORATE（企业签 章），PERSONAL（个人签字），LP（法 定代表人签字）
     */
    public java.lang.String getSignActionType() {
        return signActionType;
    }

    /**
     * 签署动作类型:CORPORATE（企业签 章），PERSONAL（个人签字），LP（法 定代表人签字）
     */
    public void setSignActionType(java.lang.String signActionType) {
        this.signActionType = signActionType;
    }

    /**
     * 签署动作名称,根据签署动作类型填写
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * 签署动作名称,根据签署动作类型填写
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * 印章id第三方系统返回的）
     */
    public java.lang.String getSourceSealId() {
        return sourceSealId;
    }

    /**
     * 印章id第三方系统返回的）
     */
    public void setSourceSealId(java.lang.String sourceSealId) {
        this.sourceSealId = sourceSealId;
    }

    /**
     * 印章name（第三方系统返回的）
     */
    public java.lang.String getSourceSealName() {
        return sourceSealName;
    }

    /**
     * 印章name（第三方系统返回的）
     */
    public void setSourceSealName(java.lang.String sourceSealName) {
        this.sourceSealName = sourceSealName;
    }

    /**
     * 平台印章id
     */
    public java.lang.String getSealId() {
        return sealId;
    }

    /**
     * 平台印章id
     */
    public void setSealId(java.lang.String sealId) {
        this.sealId = sealId;
    }

    /**
     * 平台印章name
     */
    public java.lang.String getSealName() {
        return sealName;
    }

    /**
     * 平台印章name
     */
    public void setSealName(java.lang.String sealName) {
        this.sealName = sealName;
    }

    /**
     * 印章使用平台用户id范围（静态）多个逗号分隔
     */
    public java.lang.String getSignatureUserIds() {
        return signatureUserIds;
    }

    /**
     * 印章使用平台用户id范围（静态）多个逗号分隔
     */
    public void setSignatureUserIds(java.lang.String signatureUserIds) {
        this.signatureUserIds = signatureUserIds;
    }

    /**
     * 签署方编号
     */
    public String getSignatoryNo() {
        return signatoryNo;
    }

    /**
     * 签署方编号
     */
    public void setSignatoryNo(String signatoryNo) {
        this.signatoryNo = signatoryNo;
    }

    /**
     * 签署动作编号，唯一
     */
    public String getActionNo() {
        return actionNo;
    }

    /**
     * 签署动作编号，唯一
     */
    public void setActionNo(String actionNo) {
        this.actionNo = actionNo;
    }

    /**
     * 实际签署方Id，我们平台内的签署方id（外部单位为空）
     */
    public Long getActualSignatoryId() {
        return actualSignatoryId;
    }

    /**
     * 实际签署方Id，我们平台内的签署方id（外部单位为空）
     */
    public void setActualSignatoryId(Long actualSignatoryId) {
        this.actualSignatoryId = actualSignatoryId;
    }

    /**
     * 实际签署人
     */
    public java.lang.String getActualSignatoryName() {
        return actualSignatoryName;
    }

    /**
     * 实际签署人
     */
    public void setActualSignatoryName(java.lang.String actualSignatoryName) {
        this.actualSignatoryName = actualSignatoryName;
    }

    /**
     * 实际签署人联系方式
     */
    public java.lang.String getActualSignatoryContact() {
        return actualSignatoryContact;
    }

    /**
     * 实际签署人联系方式
     */
    public void setActualSignatoryContact(java.lang.String actualSignatoryContact) {
        this.actualSignatoryContact = actualSignatoryContact;
    }

    /**
     * 签章顺序,前置设置1，后置逐渐增大，无序设置相同
     */
    public java.lang.Integer getSealSignOrder() {
        return sealSignOrder;
    }

    /**
     * 签章顺序,前置设置1，后置逐渐增大，无序设置相同
     */
    public void setSealSignOrder(java.lang.Integer sealSignOrder) {
        this.sealSignOrder = sealSignOrder;
    }

    /**
     * 0-待激活，1-待签章，2-已完成
     */
    public java.lang.Integer getJobStatus() {
        return jobStatus;
    }

    /**
     * 0-待激活，1-待签章，2-已完成
     */
    public void setJobStatus(java.lang.Integer jobStatus) {
        this.jobStatus = jobStatus;
    }

    /**
     * 已签章（已完成）-1，已退回（已拒签）-2，已撤回-3，已过期-4，其他-5
     */
    public java.lang.Integer getSignResult() {
        return signResult;
    }

    /**
     * 已签章（已完成）-1，已退回（已拒签）-2，已撤回-3，已过期-4，其他-5
     */
    public void setSignResult(java.lang.Integer signResult) {
        this.signResult = signResult;
    }

    /**
     * 备注，描述签署状态
     */
    public java.lang.String getMark() {
        return mark;
    }

    /**
     * 备注，描述签署状态
     */
    public void setMark(java.lang.String mark) {
        this.mark = mark;
    }

    /**
     * 开始时间：状态由待激活变为待签章，可以开始签署动作的时间
     */
    public java.util.Date getStartTime() {
        return startTime;
    }

    /**
     * 开始时间：状态由待激活变为待签章，可以开始签署动作的时间
     */
    public void setStartTime(java.util.Date startTime) {
        this.startTime = startTime;
    }

    /**
     * 结束时间：状态为完成签署动作的时间
     */
    public java.util.Date getEndTime() {
        return endTime;
    }

    /**
     * 结束时间：状态为完成签署动作的时间
     */
    public void setEndTime(java.util.Date endTime) {
        this.endTime = endTime;
    }

    /**
     * 签章管理表id
     */
    public java.lang.Long getPid() {
        return pid;
    }

    /**
     * 签章管理表id
     */
    public void setPid(java.lang.Long pid) {
        this.pid = pid;
    }

}
