package com.ejianc.business.signaturemanage.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.util.ArrayList;
import java.util.List;

/**
 * @author:刘家乐
 * @version: 1
 * @date:2021/11/20
 * @document:
 */


public class ManagementVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    /**
     * 印章ID（第三方返回）@
     */
    private Long sourceSealId;

    /**
     * 印章名称（第三方返回）@
     */
    private String sourceSealName;

    /**
     * 签章类型，COMPANY("企业公章"),LP("法定代表人章")@
     */
    private String sealType;
    /**
     * 印章图片KEY@
     */
    private String sourceKey;
    /**
     * 图片地址@
     */
    private String imgUrl;
    /**
     * 第三方返回的印章状态名称@
     */
    private String sourceStatusDescription;
    /**
     * 第三方返回的印章状态，NORMAL("正 常"),FREEZE("冻结"),DELETE("删 除"),INVALID("失效")@
     */
    private String sourceStatus;
    /**
     * 状态，1-启用，0-停用
     */
    private Integer enableStatus;
    /**
     * 印章分类，PHYSICS(物理章),ELECTRONIC(电子章)@
     */
    private String sealCategory;
    /**
     * 公司ID,第三方@
     */
    private Long sourceCompanyId;
    /**
     * 所属公司名称 第三方@
     */
    private String sourceCompanyName;
    /**
     * 组织id
     */
    private Long orgId;
    /**
     * 所属组织名称
     */
    private String orgName;
    /**
     * 印章类型（类别）子类别@
     */
    private String sealSubType;
    /**
     * 印章类型名称子类别@
     */
    private String sealSubTypeName;
    /**
     * 是否匹配 1匹配 0不匹配
     */
    private Integer isMatch;
    /**
     * 印章使用者
     */
    private String sealUseName;

    /**
     * 默认印章使用者
     */
    private String sealDefaultName;
    /**
     * 默认印章使用者id
     */
    private Long sealDefaultId;

    /**
     * 单据类型
     */
    private String billCode;

    private List<ManagementUserVO> userEntityList = new ArrayList<>();

    public List<ManagementUserVO> getUserEntityList() {
        return userEntityList;
    }

    public void setUserEntityList(List<ManagementUserVO> userEntityList) {
        this.userEntityList = userEntityList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getSealUseName() {
        return sealUseName;
    }

    public void setSealUseName(String sealUseName) {
        this.sealUseName = sealUseName;
    }

    public String getSealDefaultName() {
        return sealDefaultName;
    }

    public void setSealDefaultName(String sealDefaultName) {
        this.sealDefaultName = sealDefaultName;
    }

    public Long getSealDefaultId() {
        return sealDefaultId;
    }

    public void setSealDefaultId(Long sealDefaultId) {
        this.sealDefaultId = sealDefaultId;
    }

    public Long getSourceSealId() {
        return sourceSealId;
    }

    public void setSourceSealId(Long sourceSealId) {
        this.sourceSealId = sourceSealId;
    }

    public String getSourceSealName() {
        return sourceSealName;
    }

    public void setSourceSealName(String sourceSealName) {
        this.sourceSealName = sourceSealName;
    }

    public String getSealType() {
        return sealType;
    }

    public void setSealType(String sealType) {
        this.sealType = sealType;
    }

    public String getSourceKey() {
        return sourceKey;
    }

    public void setSourceKey(String sourceKey) {
        this.sourceKey = sourceKey;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getSourceStatusDescription() {
        return sourceStatusDescription;
    }

    public void setSourceStatusDescription(String sourceStatusDescription) {
        this.sourceStatusDescription = sourceStatusDescription;
    }

    public String getSourceStatus() {
        return sourceStatus;
    }

    public void setSourceStatus(String sourceStatus) {
        this.sourceStatus = sourceStatus;
    }

    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    public String getSealCategory() {
        return sealCategory;
    }

    public void setSealCategory(String sealCategory) {
        this.sealCategory = sealCategory;
    }

    public Long getSourceCompanyId() {
        return sourceCompanyId;
    }

    public void setSourceCompanyId(Long sourceCompanyId) {
        this.sourceCompanyId = sourceCompanyId;
    }

    public String getSourceCompanyName() {
        return sourceCompanyName;
    }

    public void setSourceCompanyName(String sourceCompanyName) {
        this.sourceCompanyName = sourceCompanyName;
    }

    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getSealSubType() {
        return sealSubType;
    }

    public void setSealSubType(String sealSubType) {
        this.sealSubType = sealSubType;
    }

    public String getSealSubTypeName() {
        return sealSubTypeName;
    }

    public void setSealSubTypeName(String sealSubTypeName) {
        this.sealSubTypeName = sealSubTypeName;
    }

    public Integer getIsMatch() {
        return isMatch;
    }

    public void setIsMatch(Integer isMatch) {
        this.isMatch = isMatch;
    }
}
