package com.ejianc.business.signaturemanage.hystrix;

import com.ejianc.business.signaturemanage.api.ISignatureManageApi;
import com.ejianc.business.signaturemanage.vo.InitSignatoryVO;
import com.ejianc.business.signaturemanage.vo.InitSignatureVO;
import com.ejianc.business.signaturemanage.vo.PrivateSignUrlVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;


/**
 * 模板服务降级处理
 *
 * @author baipengyan
 * @Description: 签章管理服务降级处理
 */
@Component
public class SignatureManageHystrix implements ISignatureManageApi {

    /**
     * 契约锁，发起方状态回调
     *
     * @param map
     * @return
     */
    @Override
    public CommonResponse<String> organizer(Map<String, String> map) {
        return CommonResponse.error("网络问题，操作失败！");
    }

    /**
     * 发起签章
     * 1.创建合同文档
     * 2.创建合同
     * 3.获取下一个待签章的人员列表
     * 4.推送消息通知
     *
     * @param initSignatureVO 发起签章VO
     * @return contractId
     */
    @Override
    public CommonResponse<Long> initiateSignature(InitSignatureVO initSignatureVO) {
        return CommonResponse.error("网络问题，操作失败！");
    }

    /**
     * 获取私有云合同签署短链接
     *
     * @param privateSignUrlVO
     * @return privateSignUrl
     */
    @Override
    public CommonResponse<String> privateSignUrl(PrivateSignUrlVO privateSignUrlVO) {
        return CommonResponse.error("网络问题，操作失败！");
    }

    /**
     * 下载签章文件
     *
     * @param billId
     * @param response
     */
    @Override
    public void downloadHasSignedFile(Long billId, HttpServletResponse response) {
        throw new BusinessException("网络问题，操作失败！");
    }

    @Override
    public CommonResponse<List<SignMgrPreviewVO>> previewContract(Long billId, List<String> sourceTypes) {
        return CommonResponse.error("网络问题，操作失败！");
    }

    /**
     * 签章详情
     *
     * @param billId
     * @return
     */
    @Override
    public CommonResponse<List<InitSignatoryVO>> signDetail(Long billId) {
        return CommonResponse.error("网络问题，操作失败！");
    }


}
