package com.ejianc.business.signaturemanage.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;
import java.util.List;

public class SignatoryDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer status; // 签署状态,0-等待中(待激活)，1-签署中(待签章)，2-已完成(已完成)
    private String signatoryName; // 签署方标识名称
    private String tenantName; // 签署方名称
    private String operatorName; // 经办人名称
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date acceptTime; // 接收时间
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date finishTime; // 完成时间
    private List<ActionDetailVO> actionDetails; // 签署动作

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getSignatoryName() {
        return signatoryName;
    }

    public void setSignatoryName(String signatoryName) {
        this.signatoryName = signatoryName;
    }

    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public Date getAcceptTime() {
        return acceptTime;
    }

    public void setAcceptTime(Date acceptTime) {
        this.acceptTime = acceptTime;
    }

    public Date getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public List<ActionDetailVO> getActionDetails() {
        return actionDetails;
    }

    public void setActionDetails(List<ActionDetailVO> actionDetails) {
        this.actionDetails = actionDetails;
    }
}
