package com.ejianc.business.signaturemanage.api;

import com.ejianc.business.signaturemanage.hystrix.SignatureCommonHystrix;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import feign.Response;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author baipengyan
 * @date 2022/5/17
 * @description 签章通用接口
 */
@FeignClient(
        name = "ejc-signaturemanage-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-signaturemanage-web",
        fallback = SignatureCommonHystrix.class
)
public interface ISignatureCommonApi {

    String API_PREFIX = "/common";

    /**
     * 合同文件添加水印
     *
     * @param watermarkVO 合同文件添加水印参数
     * @return Response    feign.Response
     */
    @PostMapping(value = API_PREFIX + "/addWatermark", consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    Response addWatermark(@RequestBody WatermarkVO watermarkVO);

    /**
     * 获取加水印的合同附件
     *
     * @param watermarkVO 合同文件添加水印参数
     * @return AttachmentVO 文件中心的水印附件
     */
    @PostMapping(value = API_PREFIX + "/fetchWatermarkAttachment")
    AttachmentVO fetchWatermarkAttachment(@RequestBody WatermarkVO watermarkVO);

    // TODO: 多文件转水印

}
